/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import stec.iws.ServletContextImpl;
import stec.iws.SessionContext;
import stec.iws.iws;

public final class Session
implements HttpSession {
    protected ServletContextImpl context;
    protected String id;
    protected long creationTime;
    protected long lastAccessedTime;
    protected long sessionTimeout;
    protected long lastUpdate;
    protected InetAddress remote_address;
    protected boolean isValid = true;
    protected boolean isNew = true;
    protected Hashtable sessionData = new Hashtable();
    private int resident = 0;
    int session_source = iws.sessionSource;

    protected Session() {
        this.sessionTimeout = iws.sessionTimeout;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.lastUpdate = this.creationTime;
    }

    public Session(String _id, ServletContextImpl _context, InetAddress _remote_address) {
        this();
        this.id = _id;
        this.context = _context;
        this.remote_address = _remote_address;
    }

    public final synchronized long getCreationTime() {
        this.checkSession();
        return this.creationTime;
    }

    public final synchronized String getId() {
        return this.id;
    }

    public final synchronized long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public final synchronized int getMaxInactiveInterval() {
        if (this.sessionTimeout < 0L) {
            return -1;
        }
        return (int)(this.sessionTimeout / 1000L);
    }

    public final synchronized void setMaxInactiveInterval(int timeout) {
        this.sessionTimeout = timeout < 0 ? -1L : (long)timeout * 1000L;
        this.lastUpdate = System.currentTimeMillis();
    }

    public final Object getAttribute(String name) {
        return this.getValue(name);
    }

    public final synchronized Object getValue(String name) {
        this.checkSession();
        return this.sessionData.get(name);
    }

    public final void setAttribute(String name, Object attribute) {
        this.putValue(name, attribute);
    }

    public final synchronized void putValue(String name, Object value) {
        this.checkSession();
        this._putValue(name, value);
    }

    protected final synchronized void _putValue(String name, Object value) {
        this._removeValue(name);
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
        this.sessionData.put(name, value);
        if (!(value instanceof Serializable)) {
            this.resident();
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public final void removeAttribute(String name) {
        this.removeValue(name);
    }

    public final synchronized void removeValue(String name) {
        this.checkSession();
        this._removeValue(name);
    }

    private final void _removeValue(String name) {
        Object value = this.sessionData.remove(name);
        if (value == null) {
            return;
        }
        if (!(value instanceof Serializable)) {
            --this.resident;
        }
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public final synchronized Enumeration getAttributeNames() {
        this.checkSession();
        return this.sessionData.keys();
    }

    public final synchronized String[] getValueNames() {
        this.checkSession();
        int i = 0;
        String[] names = new String[this.sessionData.size()];
        Enumeration e = this.sessionData.keys();
        while (e.hasMoreElements()) {
            names[i++] = e.nextElement().toString();
        }
        return names;
    }

    public final synchronized void clear() {
        this.checkSession();
        this._clear();
    }

    protected final void _clear() {
        try {
            Enumeration e = this.sessionData.keys();
            while (e.hasMoreElements()) {
                this._removeValue((String)e.nextElement());
            }
        }
        finally {
            this.resident = 0;
            this.sessionData.clear();
        }
    }

    public final HttpSessionContext getSessionContext() {
        return new SessionContext();
    }

    public final synchronized void invalidate() {
        this.checkSession();
        this._invalidate();
    }

    public final synchronized boolean isNew() {
        this.checkSession();
        return this.isNew;
    }

    public final synchronized boolean isValid() {
        if (!this._isValid()) {
            this._invalidate();
        }
        return this.isValid;
    }

    public final synchronized void sync() throws Exception {
        iws.sessionStore.saveSession(this, true);
    }

    protected final synchronized void _invalidate() {
        if (this.isValid) {
            try {
                this._clear();
            }
            finally {
                try {
                    try {
                        iws.sessionStore.removeSession(this);
                    }
                    catch (Exception ex) {
                        iws.logger.log(iws.local_strings.getLocalString("err.unable_to_remove_session", this.id, ex.getMessage()));
                    }
                }
                finally {
                    this.isValid = false;
                }
            }
        }
    }

    protected final synchronized boolean _isValid() {
        if (this.isValid && this.sessionTimeout >= 0L && System.currentTimeMillis() > this.lastAccessedTime + this.sessionTimeout) {
            return false;
        }
        return this.isValid;
    }

    protected final synchronized void access() {
        this.lastAccessedTime = System.currentTimeMillis();
        this.isNew = false;
        this.lastUpdate = this.lastAccessedTime;
    }

    private final void checkSession() {
        if (!this.isValid()) {
            throw new IllegalStateException(iws.local_strings.getLocalString("err.session_id_is_not_valid", this.id));
        }
    }

    public final boolean canSerialize() {
        return this.resident == 0;
    }

    public final void resident() {
        if (this.resident == 0) {
            try {
                iws.sessionStore.removeResidentSession(this);
            }
            catch (Exception ex) {
                iws.logger.log(iws.local_strings.getLocalString("err.unable_to_remove_session", this.id, ex.getMessage()));
            }
        }
        ++this.resident;
    }

    public synchronized void useURL() {
        this.session_source = 1;
    }

    public synchronized void useCookie() {
        this.session_source = 2;
    }

    public synchronized boolean isSessionSourceCookie() {
        return this.session_source == 2;
    }

    public synchronized boolean isSessionSourceURL() {
        return this.session_source == 1;
    }
}

