/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import stec.iws.Delay;
import stec.iws.IOHandler;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.ServletContextImpl;
import stec.iws.ServletImpl;
import stec.iws.ServletInstance;
import stec.iws.ServletManager;
import stec.iws.Utils;
import stec.iws.iws;

public final class ServletTagServlet
extends HttpServlet {
    private static final String BTAG = "<servlet";
    private static final String ETAG = "</servlet>";
    private static final int BTAG_LENGTH = "<servlet".length();
    private static final int ETAG_LENGTH = "</servlet>".length();

    public final void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException {
        Request request = (Request)_request;
        Response response = (Response)_response;
        String item = null;
        if (iws.servlet_chaining && request.handler.in_servlet_chain && request.handler.servlet_chain_index > 0) {
            int size = (int)request.requestInputStream.getBytesAvailable();
            byte[] buffer = new byte[size];
            InputStream is = request.requestInputStream.getInputStream();
            int bytesRead = is.read(buffer, 0, size);
            if (size != 0 && bytesRead != size) {
                throw new ServletException(iws.local_strings.getLocalString("err.unable_to_completely_read_item"));
            }
            item = new String(buffer, 0, bytesRead);
            Enumeration e = request.headers.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object obj = request.headers.get(key);
                response.headers.put(key, obj);
            }
            request.setHeader("Content-Length", "0");
        } else {
            String charset;
            String script_name = Utils.concatURIs(response.handler.servlet_context.uri, response.handler.request.getServletPath());
            String filename = _request.getRealPath(script_name);
            IOHandler handler = Utils.getBestHandler(filename, request, response);
            if (handler == null) {
                if (iws.content_negotiation) {
                    _response.sendError(406);
                } else {
                    _response.sendError(404);
                }
            }
            if ((charset = response.getCharacterEncoding()) == null) {
                charset = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
            }
            InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(handler.getInputStream()), charset);
            try {
                item = Utils.getItem(reader);
            }
            finally {
                reader.close();
            }
        }
        if (item == null) {
            _response.sendError(404);
            return;
        }
        this.process(request, response, item);
    }

    private final void process(Request _request, Response _response, String item) throws IOException, ServletException {
        int btagOffset;
        PrintWriter writer = _response.getWriter();
        int offset = 0;
        int item_length = item.length();
        while ((btagOffset = this.indexOfIgnoreCase(item, BTAG, offset)) != -1) {
            writer.print(item.substring(offset, btagOffset));
            int etagOffset = this.indexOfIgnoreCase(item, ETAG, btagOffset + ETAG_LENGTH);
            if (etagOffset == -1) {
                etagOffset = item_length;
                break;
            }
            String tag = item.substring(btagOffset + BTAG_LENGTH, etagOffset);
            if (!this.processTag(_request, _response, tag)) {
                writer.print(item.substring(btagOffset, etagOffset + ETAG_LENGTH));
            }
            offset = etagOffset + ETAG_LENGTH;
        }
        writer.print(item.substring(offset));
    }

    private final int indexOfIgnoreCase(String str, String substr, int soffset) {
        int str_length = str.length();
        int substr_length = substr.length();
        int i = soffset;
        while (i < str_length) {
            if (str.regionMatches(true, i, substr, 0, substr_length)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processTag(Request _request, Response _response, String tag) throws IOException, ServletException {
        boolean isClass;
        int offset = tag.indexOf(62);
        if (offset == -1) {
            return true;
        }
        String tinit_params = tag.substring(0, offset);
        Hashtable init_params = this.parseInitParams(tinit_params);
        if (init_params == null) {
            throw new ServletException(iws.local_strings.getLocalString("err.invalid_initialization_parameters", tinit_params));
        }
        String tparams = tag.substring(offset + 1);
        Hashtable params = this.parseParams(tparams);
        if (params == null) {
            throw new ServletException(iws.local_strings.getLocalString("err.invalid_parameters", tparams));
        }
        ServletImpl servlet_instance = null;
        String name = null;
        ServletContextImpl servlet_context = (ServletContextImpl)this.getServletConfig().getServletContext();
        Object obj = init_params.get("name");
        if (obj == null) {
            obj = init_params.get("code");
            if (obj == null) {
                throw new ServletException(iws.local_strings.getLocalString("err.servlet_or_class_must_be_specified"));
            }
            name = ((String[])obj)[0];
            offset = name.lastIndexOf(46);
            if (offset != -1 && name.substring(offset).equalsIgnoreCase(".class")) {
                name = name.substring(0, offset);
            }
            try {
                servlet_instance = this.loadServletClass(servlet_context, name, init_params);
            }
            catch (Exception ex) {
                throw new ServletException(iws.local_strings.getLocalString("err.error_loading", iws.local_strings.getLocalString("Class"), name, ex.getMessage()));
            }
            isClass = true;
        } else {
            name = ((String[])obj)[0];
            try {
                servlet_instance = ServletManager.loadServlet(servlet_context, name, init_params);
            }
            catch (Exception ex) {
                throw new ServletException(iws.local_strings.getLocalString("err.error_loading", iws.local_strings.getLocalString("Servlet"), name, ex.getMessage()));
            }
            isClass = false;
        }
        if (servlet_instance == null) {
            throw new ServletException(iws.local_strings.getLocalString("err.unable_to_load", iws.local_strings.getLocalString("Servlet"), name));
        }
        _response.flush();
        int o_whichOutputStream = _response.whichOutputStream;
        PrintWriter o_responseWriter = _response.responseWriter;
        _response.responseWriter = null;
        _response.whichOutputStream = 0;
        try {
            try {
                Hashtable request_params = _request.params;
                _request.params = params;
                if (servlet_instance.servlet instanceof SingleThreadModel) {
                    Servlet servlet = servlet_instance.servlet;
                    synchronized (servlet) {
                        servlet_instance.servlet.service((ServletRequest)_request, (ServletResponse)_response);
                    }
                } else {
                    servlet_instance.servlet.service((ServletRequest)_request, (ServletResponse)_response);
                }
                _request.params = request_params;
            }
            catch (UnavailableException ex) {
                name = servlet_instance.config.name;
                int delay = ex.getUnavailableSeconds();
                ServletManager.unavailable_servlets.put(name, new Delay(delay));
                if (ex.isPermanent()) {
                    ServletManager.unloadServlet(servlet_context, name);
                }
                throw new ServletException(ex.getMessage());
            }
        }
        finally {
            _response.flush();
            _response.whichOutputStream = o_whichOutputStream;
            _response.responseWriter = o_responseWriter;
            if (isClass) {
                servlet_instance.servlet.destroy();
            }
        }
        return true;
    }

    private final Hashtable parseInitParams(String str) {
        String key;
        Hashtable ht = new Hashtable();
        Tokenizer tokenizer = new Tokenizer(str, "=");
        while ((key = tokenizer.next()) != null) {
            String token = tokenizer.next();
            if (token == null) {
                return null;
            }
            if (!token.equals("=")) {
                return null;
            }
            String value = tokenizer.next();
            if (value == null) {
                value = "";
            }
            ServletTagServlet.addElement(ht, key, value);
        }
        return ServletTagServlet.convert(ht);
    }

    private final Hashtable parseParams(String str) {
        String token;
        Hashtable ht = new Hashtable();
        Tokenizer tokenizer = new Tokenizer(str, "=>");
        while ((token = tokenizer.next()) != null) {
            String value;
            if (token == null) {
                return null;
            }
            if (!token.equalsIgnoreCase("<param")) {
                return null;
            }
            token = tokenizer.next();
            if (token == null) {
                return null;
            }
            if (!token.equalsIgnoreCase("name")) {
                return null;
            }
            token = tokenizer.next();
            if (token == null) {
                return null;
            }
            if (!token.equals("=")) {
                return null;
            }
            String key = tokenizer.next();
            if (key == null) {
                return null;
            }
            token = tokenizer.next();
            if (token == null) {
                return null;
            }
            if (token.equalsIgnoreCase("value")) {
                token = tokenizer.next();
                if (token == null) {
                    return null;
                }
                if (!token.equals("=")) {
                    return null;
                }
                value = tokenizer.next();
                if (value == null) {
                    value = "";
                }
                if (value.equals(">")) {
                    value = "";
                } else {
                    token = tokenizer.next();
                    if (token == null) {
                        return null;
                    }
                }
            } else {
                value = "";
            }
            if (!token.equals(">")) {
                return null;
            }
            ServletTagServlet.addElement(ht, key, value);
        }
        return ServletTagServlet.convert(ht);
    }

    private static final Hashtable convert(Hashtable ht) {
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Vector values = (Vector)ht.get(key);
            Object[] avalues = new String[values.size()];
            values.copyInto(avalues);
            ht.put(key, avalues);
        }
        return ht;
    }

    private static final void addElement(Hashtable ht, String key, String value) {
        Vector values;
        if (ht.containsKey(key)) {
            values = (Vector)ht.get(key);
            values.addElement(value);
        } else {
            values = new Vector();
            values.addElement(value);
        }
        ht.put(key, values);
    }

    private final ServletImpl loadServletClass(ServletContextImpl servlet_context, String _name, Hashtable _args) throws Exception {
        Class<?> cls = Class.forName(_name);
        Object obj = cls.newInstance();
        ServletInstance servlet_instance = new ServletInstance(_name, (Servlet)obj, _args);
        ServletImpl servlet = new ServletImpl(servlet_instance, servlet_context);
        servlet.servlet.init((ServletConfig)servlet.config);
        return servlet;
    }

    final class Tokenizer {
        String item;
        String delimiters;
        int offset;

        Tokenizer(String _item) {
            this.item = _item;
            this.offset = 0;
        }

        Tokenizer(String _item, String _delimiters) {
            this.item = _item;
            this.delimiters = _delimiters;
            this.offset = 0;
        }

        protected final String next() {
            int eOffset;
            int item_length = this.item.length();
            if (this.offset >= item_length) {
                return null;
            }
            int sOffset = this.offset;
            while (sOffset < item_length) {
                if (!Character.isWhitespace(this.item.charAt(sOffset))) break;
                ++sOffset;
            }
            if (sOffset >= item_length) {
                this.offset = sOffset;
                return null;
            }
            if (this.delimiters.indexOf(this.item.charAt(sOffset)) != -1) {
                eOffset = sOffset + 1;
            } else if (this.item.charAt(sOffset) == '\"' || this.item.charAt(sOffset) == '\'') {
                char quoteChar = this.item.charAt(sOffset);
                eOffset = sOffset + 1;
                while (eOffset < item_length) {
                    if (this.item.charAt(eOffset) == quoteChar) {
                        this.offset = eOffset + 1;
                        return this.item.substring(sOffset + 1, eOffset);
                    }
                    ++eOffset;
                }
            } else {
                eOffset = sOffset + 1;
                while (eOffset < item_length) {
                    if (!Character.isWhitespace(this.item.charAt(eOffset)) && this.delimiters.indexOf(this.item.charAt(eOffset)) == -1) {
                        ++eOffset;
                        continue;
                    }
                    break;
                }
            }
            this.offset = eOffset;
            return this.item.substring(sOffset, eOffset);
        }
    }
}

