/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.util.Enumeration;
import java.util.Hashtable;
import stec.iws.ServletContextImpl;
import stec.iws.Utils;
import stec.iws.iws;

public final class ServletContextManager {
    protected static Hashtable servlet_contexts = new Hashtable();

    private static final synchronized ServletContextImpl loadServletContext(String name, String uri, String parameters) throws Exception {
        Object obj = servlet_contexts.get(name);
        if (obj != null) {
            return (ServletContextImpl)obj;
        }
        Hashtable ht = Utils.parseParameters(parameters);
        ServletContextImpl servlet_context = new ServletContextImpl(name, uri, ht);
        servlet_contexts.put(name, servlet_context);
        return servlet_context;
    }

    public static final synchronized ServletContextImpl getServletContext(String uri) throws Exception {
        while (true) {
            String value;
            Object obj;
            if ((obj = iws.aliases.get(uri)) != null && (value = (String)obj).startsWith("context:")) {
                String name = value.substring("context:".length());
                obj = iws.servlet_contexts.get(name);
                if (obj == null) {
                    throw new Exception(iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Servlet_Context"), name));
                }
                return ServletContextManager.loadServletContext(name, uri, (String)obj);
            }
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
                continue;
            }
            int offset = uri.lastIndexOf(47);
            if (offset == -1) {
                obj = iws.aliases.get("*");
                if (obj == null) {
                    String name = "Default";
                    obj = iws.servlet_contexts.get(name);
                    if (obj == null) {
                        return ServletContextManager.loadServletContext(name, "/", "");
                    }
                    return ServletContextManager.loadServletContext(name, "/", (String)obj);
                }
                value = (String)obj;
                if (value.startsWith("context:")) {
                    String name = value.substring("context:".length());
                    obj = iws.servlet_contexts.get(name);
                    if (obj == null) {
                        throw new Exception(iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Servlet_Context"), name));
                    }
                    return ServletContextManager.loadServletContext(name, "/", (String)obj);
                }
            }
            uri = uri.substring(0, offset + 1);
        }
    }

    protected static final synchronized void destroyAllServletContexts() {
        Enumeration e = servlet_contexts.elements();
        while (e.hasMoreElements()) {
            ServletContextImpl context = (ServletContextImpl)e.nextElement();
            servlet_contexts.remove(context.name);
            context.destroy();
        }
    }

    public static final Enumeration getServletContexts() {
        return servlet_contexts.elements();
    }
}

