/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import stec.iws.RequestDispatcherImpl;
import stec.iws.ServletContextManager;
import stec.iws.ServletManager;
import stec.iws.Utils;
import stec.iws.iws;

public final class ServletContextImpl
implements ServletContext {
    private static final String DEFAULT_TEMP_DIR = "./temp";
    protected Hashtable sessions;
    protected String name;
    protected String uri;
    protected Hashtable args;
    protected Hashtable attributes;

    ServletContextImpl(String _name, String _uri, Hashtable _args) throws Exception {
        this.name = _name;
        this.uri = _uri;
        this.args = _args;
        this.sessions = new Hashtable();
        this.attributes = new Hashtable();
        String dir = Utils.concatPaths(Utils.concatPaths(iws.contextdir, _name), Utils.normalizeURI(DEFAULT_TEMP_DIR));
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.attributes.put("javax.servlet.context.tempdir", file);
        iws.sessionStore.load(this);
    }

    public final Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public final Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public final void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public final void setAttribute(String name, Object obj) {
        this.attributes.put(name, obj);
    }

    public final String getInitParameter(String name) {
        Object obj = this.args.get(name);
        return obj == null ? null : ((String[])obj)[0];
    }

    public final String[] getInitParameterValues(String name) {
        Object obj = this.args.get(name);
        return obj == null ? null : (String[])obj;
    }

    public final Enumeration getInitParameterNames() {
        return this.args.keys();
    }

    public final ServletContext getContext(String uri) {
        try {
            return ServletContextManager.getServletContext(uri);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final int getMajorVersion() {
        return 2;
    }

    public final int getMinorVersion() {
        return 2;
    }

    public final String getMimeType(String filename) {
        return iws.getMimeType(filename);
    }

    public final String getRealPath(String path) {
        try {
            return Utils.translatePath("*", Utils.concatURIs(this.uri, Utils.normalizeURI(path)));
        }
        catch (IOException ex) {
            return null;
        }
    }

    public final RequestDispatcher getRequestDispatcher(String request_uri) {
        return this.getRequestDispatcher("*", request_uri);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RequestDispatcher getRequestDispatcher(String server_name, String request_uri) {
        try {
            String servlet;
            RequestDispatcherImpl dispatcher = new RequestDispatcherImpl();
            dispatcher.raw_request_uri = Utils.concatURIs(this.uri, request_uri);
            int offset = dispatcher.raw_request_uri.indexOf(63);
            if (offset == -1) {
                dispatcher.request_uri = dispatcher.raw_request_uri;
                dispatcher.query_string = null;
            } else {
                dispatcher.request_uri = dispatcher.raw_request_uri.substring(0, offset);
                dispatcher.query_string = dispatcher.raw_request_uri.substring(offset + 1);
            }
            dispatcher.script_name = Utils.decodeURL(Utils.normalizeURI(dispatcher.request_uri));
            String filter_uri = ServletManager.findFilter(dispatcher.script_name);
            if (filter_uri != null) {
                String filter;
                if (dispatcher.script_name.length() == filter_uri.length()) {
                    dispatcher.path_info = null;
                } else {
                    dispatcher.path_info = dispatcher.script_name.substring(filter_uri.length());
                    if (dispatcher.path_info.charAt(0) != '/') {
                        dispatcher.path_info = "/" + dispatcher.path_info;
                    }
                }
                if (filter_uri.startsWith(this.uri)) {
                    dispatcher.script_name = Utils.concatURIs("/", filter_uri.substring(this.uri.length()));
                }
                if ((filter = ServletManager.getFilter(filter_uri)) == null) {
                    return null;
                }
                dispatcher.servlet_instance = ServletManager.loadServlet(this, filter);
                if (dispatcher.servlet_instance != null) return dispatcher;
                return null;
            }
            String servlet_uri = ServletManager.findServlet(dispatcher.script_name);
            if (servlet_uri == null) return null;
            if (dispatcher.script_name.length() == servlet_uri.length()) {
                dispatcher.path_info = null;
            } else {
                dispatcher.path_info = dispatcher.script_name.substring(servlet_uri.length());
                if (dispatcher.path_info.charAt(0) != '/') {
                    dispatcher.path_info = "/" + dispatcher.path_info;
                }
            }
            if (servlet_uri.startsWith(this.uri)) {
                dispatcher.script_name = Utils.concatURIs("/", servlet_uri.substring(this.uri.length()));
            }
            if ((servlet = ServletManager.getServlet(servlet_uri)) == null) {
                return null;
            }
            dispatcher.servlet_instance = ServletManager.loadServlet(this, servlet);
            if (dispatcher.servlet_instance != null) return dispatcher;
            return null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final RequestDispatcher getNamedDispatcher(String servlet_name) {
        return this.getNamedDispatcher("*", servlet_name);
    }

    public final RequestDispatcher getNamedDispatcher(String server_name, String servlet_name) {
        RequestDispatcherImpl dispatcher;
        block3: {
            try {
                dispatcher = new RequestDispatcherImpl();
                dispatcher.request_uri = dispatcher.raw_request_uri = Utils.concatURIs(this.uri, servlet_name);
                dispatcher.path_info = null;
                dispatcher.script_name = Utils.concatURIs("/", servlet_name);
                dispatcher.servlet_instance = ServletManager.loadServlet(this, servlet_name);
                if (dispatcher.servlet_instance != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return dispatcher;
    }

    public final URL getResource(String uri) throws MalformedURLException {
        return new URL("file", null, -1, this.getRealPath(uri));
    }

    public final InputStream getResourceAsStream(String uri) {
        try {
            return new FileInputStream(this.getRealPath(uri));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final String getServerInfo() {
        return iws.SERVER_SOFTWARE;
    }

    public final Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public final Enumeration getServletNames() {
        return new Vector(0).elements();
    }

    public final Enumeration getServlets() {
        return new Vector(0).elements();
    }

    public final void log(Exception ex, String msg) {
        iws.logger.log(ex, msg);
    }

    public final void log(String msg, Throwable ex) {
        iws.logger.log(ex, msg);
    }

    public final void log(String msg) {
        iws.logger.log(msg);
    }

    protected final void destroy() {
        try {
            if (iws.sessionStore != null) {
                iws.sessionStore.unload(this);
            }
        }
        catch (Exception ex) {
            iws.logger.log(iws.local_strings.getLocalString("err.error_while_unloading_context", this.name, ex.getMessage()));
        }
    }

    public final Enumeration getSessions() {
        return this.sessions.elements();
    }

    public final String getName() {
        return this.name;
    }

    public final String getURI() {
        return this.uri;
    }
}

