/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import stec.iws.CgiServlet;
import stec.iws.IOHandler;
import stec.iws.IOManager;
import stec.iws.InputReader;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public final class SSIncludeServlet
extends HttpServlet {
    private static final String BOS = "<!--";
    private static final String EOS = "-->";
    private static final int BOS_LENGTH = "<!--".length();
    private static final int EOS_LENGTH = "-->".length();
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int ERROR = -1;
    private static final int BYTES = 1;

    public final void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException {
        Request request = (Request)_request;
        Response response = (Response)_response;
        ServletContext context = new ServletContext(request, response);
        context.path = context.request.getRealPath(context.request.getRequestURI());
        IOHandler handler = Utils.getBestHandler(context.path, request, response);
        if (handler == null) {
            if (iws.content_negotiation) {
                _response.sendError(406);
            } else {
                _response.sendError(404);
            }
            return;
        }
        response.setDateHeader("Date", System.currentTimeMillis());
        response.setDateHeader("Last-Modified", handler.lastModified());
        context.charset = response.getCharacterEncoding();
        if (context.charset == null) {
            context.charset = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(handler.getInputStream()), context.charset);
        try {
            context.item = Utils.getItem(reader);
        }
        finally {
            reader.close();
        }
        if (context.item == null) {
            _response.sendError(404);
            return;
        }
        context.writer = _response.getWriter();
        context.vars = this.getEnvironmentalVariables(context);
        this.process(context);
    }

    private final void process(ServletContext context) throws IOException {
        int bosOffset;
        int offset = 0;
        while ((bosOffset = context.item.indexOf(BOS, offset)) != -1) {
            context.writer.print(context.item.substring(offset, bosOffset));
            int eosOffset = context.item.indexOf(EOS, bosOffset + BOS_LENGTH);
            if (eosOffset == -1) {
                eosOffset = context.item.length();
                break;
            }
            context.statement = context.item.substring(bosOffset + BOS_LENGTH, eosOffset);
            if (!this.processStatement(context)) {
                context.writer.print(context.item.substring(bosOffset, eosOffset + EOS_LENGTH));
            }
            offset = eosOffset + EOS_LENGTH;
        }
        context.writer.print(context.item.substring(offset));
    }

    private final boolean processStatement(ServletContext context) throws IOException {
        context.st = new StringTokenizer(context.statement);
        if (context.st.hasMoreElements()) {
            String command = ((String)context.st.nextElement()).toLowerCase();
            if (command.equals("#echo")) {
                return this.processEcho(context);
            }
            if (command.equals("#include")) {
                return this.processInclude(context);
            }
            if (command.equals("#exec")) {
                return this.processExec(context);
            }
            if (command.equals("#config")) {
                return this.processConfig(context);
            }
            if (command.equals("#fsize")) {
                return this.processFSIZE(context);
            }
            if (command.equals("#flastmod")) {
                return this.processFLASTMOD(context);
            }
        }
        return false;
    }

    private final boolean parseStatement(ServletContext context) {
        if (context.st.hasMoreElements()) {
            context.var = context.st.nextToken("=").trim();
            if (context.st.hasMoreElements()) {
                context.value = ((String)context.st.nextElement()).trim();
                if (context.st.hasMoreElements()) {
                    return false;
                }
                if (!context.value.startsWith("\"") || !context.value.endsWith("\"")) {
                    return false;
                }
                context.value = context.value.substring(1, context.value.length() - 1);
                return true;
            }
        }
        return false;
    }

    private final boolean processEcho(ServletContext context) throws IOException {
        if (this.parseStatement(context)) {
            if (!context.var.equalsIgnoreCase("var")) {
                return false;
            }
            Object obj = context.vars.get(context.value);
            if (obj == null) {
                this.outputError(context, iws.local_strings.getLocalString("err.variable_does_not_exist", context.value));
            } else {
                context.writer.print(SSIncludeServlet.format(context, obj));
            }
            return true;
        }
        return false;
    }

    private final int getPath(ServletContext context) throws IOException {
        if (context.var.equalsIgnoreCase("file")) {
            context.value = context.value.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            if (!Utils.isAbsolute(context.value)) {
                context.path = (String)context.vars.get("DOCUMENT_NAME");
                int offset = context.path.lastIndexOf(File.separatorChar);
                context.path = offset == -1 ? File.separator : context.path.substring(0, offset);
                context.value = Utils.concatPaths(context.path, context.value);
            }
            context.path = Utils.normalizePath(context.value);
        } else if (context.var.equalsIgnoreCase("virtual")) {
            if (!Utils.isAbsolute(context.value)) {
                context.path = Utils.normalizeURI((String)context.vars.get("DOCUMENT_URI"));
                int offset = context.path.lastIndexOf(47);
                context.path = offset == -1 ? "/" : context.path.substring(0, offset);
                context.value = Utils.concatURIs(context.path, context.value);
            }
            context.path = Utils.translatePath(context.request.server_name, context.value);
        } else {
            return 0;
        }
        context.handler = IOManager.getHandler(context.path);
        if (!context.handler.exists() || context.handler.isDirectory()) {
            this.outputError(context, iws.local_strings.getLocalString("err.file_does_not_exist", context.path));
            return -1;
        }
        return 1;
    }

    private final boolean processInclude(ServletContext context) throws IOException {
        if (this.parseStatement(context)) {
            switch (this.getPath(context)) {
                case 0: {
                    return false;
                }
                case -1: {
                    return true;
                }
            }
            ServletContext tContext = new ServletContext(context.request, context.response);
            tContext.errmsg = context.errmsg;
            tContext.timefmt = context.timefmt;
            tContext.sizefmt = context.sizefmt;
            tContext.vars = context.vars;
            tContext.writer = context.writer;
            tContext.path = context.path;
            tContext.charset = context.charset;
            tContext.item = this.getFile(tContext.path, tContext.charset);
            if (tContext.item == null) {
                this.outputError(context, iws.local_strings.getLocalString("err.file_does_not_exist", tContext.path));
            } else {
                this.process(tContext);
                context.errmsg = tContext.errmsg;
                context.timefmt = tContext.timefmt;
                context.sizefmt = tContext.sizefmt;
            }
            return true;
        }
        return false;
    }

    private final void processCmd(ServletContext context) throws IOException {
        String cmd;
        InputStream es;
        InputStream is;
        block28: {
            block29: {
                is = null;
                es = null;
                cmd = context.value.trim();
                if (cmd.length() != 0) break block28;
                this.outputError(context, iws.local_strings.getLocalString("err.command_was_not_specified"));
                if (is == null) break block29;
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (es != null) {
                try {
                    es.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(cmd);
                String[] envp = new String[context.vars.size()];
                StringBuffer tsb = new StringBuffer();
                int i = 0;
                Enumeration e = context.vars.keys();
                while (e.hasMoreElements()) {
                    String key = new String(((String)e.nextElement()).getBytes(context.charset));
                    String value = new String(context.vars.get(key).toString().getBytes(context.charset));
                    tsb.append(key);
                    tsb.append('=');
                    tsb.append(value);
                    envp[i++] = tsb.toString();
                    tsb.setLength(0);
                }
                Process p = Runtime.getRuntime().exec(sb.toString(), envp);
                is = p.getInputStream();
                es = p.getErrorStream();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                InputReader ir = new InputReader(is, buffer);
                InputReader er = new InputReader(es, buffer);
                ir.start();
                er.start();
                int rc = -1;
                try {
                    rc = p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ir.waitFor();
                er.waitFor();
                context.writer.print(new String(buffer.toByteArray(), context.charset));
            }
            catch (Exception ex) {
                this.outputError(context, iws.local_strings.getLocalString("err.unable_to_execute_exception", context.value, ex.getMessage()));
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (es != null) {
                try {
                    es.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private final void processCgi(ServletContext context) throws IOException {
        try {
            if (!Utils.isAbsolute(context.value)) {
                context.path = Utils.normalizeURI((String)context.vars.get("DOCUMENT_URI"));
                int offset = context.path.lastIndexOf(47);
                context.path = offset == -1 ? "/" : context.path.substring(0, offset);
                context.value = Utils.concatURIs(context.path, context.value);
            }
            String cmd = context.value;
            ServletConfig config = this.getServletConfig();
            String basedir = config.getInitParameter("bindir");
            if (basedir != null) {
                if (Utils.isAbsolute(basedir)) {
                    basedir = Utils.normalizePath(basedir);
                } else {
                    String server_basedir;
                    Object obj;
                    if (File.separatorChar == '\\') {
                        basedir = Utils.parsePath(basedir);
                    }
                    if ((obj = iws.hosts.get(context.request.getServerName().toLowerCase())) == null && (obj = iws.hosts.get("*")) == null) {
                        obj = "./wwwroot";
                    }
                    basedir = Utils.isAbsolute(server_basedir = (String)obj) ? Utils.normalizePath(Utils.concatPaths(server_basedir, Utils.normalizeURI(basedir))) : Utils.normalizePath(Utils.concatPaths(iws.getRealPath(server_basedir), Utils.normalizeURI(basedir)));
                }
            }
            cmd = basedir == null ? Utils.normalizePath(cmd) : Utils.normalizePath(Utils.concatPaths(basedir, cmd));
            context.path = cmd;
            File file = new File(cmd);
            if (!file.exists() || !file.isFile()) {
                this.outputError(context, iws.local_strings.getLocalString("err.file_was_not_found", context.value));
                return;
            }
            context.response.flush();
            int oWhichOutputStream = context.response.whichOutputStream;
            Response cfr_ignored_0 = context.response;
            context.response.whichOutputStream = 0;
            try {
                CgiServlet.execute(config, context.request, context.response, context.vars, cmd, context.charset);
            }
            finally {
                context.response.whichOutputStream = oWhichOutputStream;
            }
        }
        catch (Exception ex) {
            this.outputError(context, iws.local_strings.getLocalString("err.unable_to_execute_exception", context.value, ex.getMessage()));
        }
    }

    private final boolean processExec(ServletContext context) throws IOException {
        if (this.parseStatement(context)) {
            if (!iws.shell) {
                this.outputError(context, iws.local_strings.getLocalString("err.unable_to_execute", context.value));
                return false;
            }
            if (context.var.equalsIgnoreCase("cgi")) {
                this.processCgi(context);
            } else if (context.var.equalsIgnoreCase("cmd")) {
                this.processCmd(context);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean processConfig(ServletContext context) throws IOException {
        if (this.parseStatement(context)) {
            if (context.var.equalsIgnoreCase("errmsg")) {
                context.errmsg = context.value;
                return true;
            }
            if (context.var.equalsIgnoreCase("timefmt")) {
                context.value = context.value.trim();
                if (context.value.length() == 0) {
                    this.outputError(context, iws.local_strings.getLocalString("err.is_not_valid", "timefmt", context.value));
                } else {
                    context.timefmt = context.value;
                }
                return true;
            }
            if (context.var.equalsIgnoreCase("sizefmt")) {
                if (context.value.equalsIgnoreCase("bytes")) {
                    context.sizefmt = 1;
                } else if (context.value.equalsIgnoreCase("abbrev")) {
                    context.sizefmt = 1024;
                } else {
                    this.outputError(context, iws.local_strings.getLocalString("err.is_not_valid", "timefmt", context.value));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private final boolean processFSIZE(ServletContext context) throws IOException {
        if (this.parseStatement(context)) {
            switch (this.getPath(context)) {
                case 0: {
                    return false;
                }
                case -1: {
                    return true;
                }
            }
            if (context.sizefmt == 1) {
                context.writer.print(String.valueOf(context.handler.length()));
            } else {
                context.writer.print(String.valueOf((int)(context.handler.length() / 1024L)));
            }
            return true;
        }
        return false;
    }

    private final String getFileDate(ServletContext context) {
        return SSIncludeServlet.formatDate(new Date(context.handler.lastModified()), context.timefmt);
    }

    private final boolean processFLASTMOD(ServletContext context) throws IOException {
        if (this.parseStatement(context)) {
            switch (this.getPath(context)) {
                case 0: {
                    return false;
                }
                case -1: {
                    return true;
                }
            }
            context.writer.print(this.getFileDate(context));
            return true;
        }
        return false;
    }

    private final String getFile(String filename, String charset) throws IOException {
        IOHandler handler = IOManager.getHandler(filename);
        if (!handler.exists()) {
            return null;
        }
        if (handler.isDirectory()) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(handler.getInputStream(), charset);
        try {
            String string = Utils.getItem(reader);
            return string;
        }
        finally {
            reader.close();
        }
    }

    private final Hashtable getEnvironmentalVariables(ServletContext context) throws IOException {
        Object obj;
        Request request = context.request;
        Hashtable vars = CgiServlet.getEnvironmentalVariables(request);
        int length = CgiServlet.HEADERS.length;
        int i = 0;
        while (i < length) {
            String header = CgiServlet.HEADERS[i];
            obj = vars.get(header);
            if (obj == null) {
                vars.put(header, "");
            }
            ++i;
        }
        String path = request.getRequestURI();
        vars.put("DOCUMENT_URI", path);
        vars.put("URL", path);
        path = request.getRealPath(path).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        vars.put("DOCUMENT_NAME", path);
        IOHandler handler = IOManager.getHandler(path);
        vars.put("LAST_MODIFIED", new Date(handler.lastModified()));
        obj = vars.get("QUERY_STRING");
        if (obj != null) {
            vars.put("QUERY_STRING_UNESCAPED", Utils.decodeURL((String)obj, context.charset));
        }
        return vars;
    }

    private final void outputError(ServletContext context, String msg) throws IOException {
        if (context.errmsg == null) {
            context.writer.print(msg);
        } else {
            context.writer.print(context.errmsg);
        }
    }

    private static final String format(ServletContext context, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return SSIncludeServlet.formatDate((Date)obj, context.timefmt);
        }
        return (String)obj;
    }

    private static final String formatDate(Date _dt, String _mask) {
        String value;
        int bosOffset;
        if (_mask == null) {
            return _dt.toString();
        }
        StringBuffer mask = new StringBuffer();
        int offset = 0;
        while ((bosOffset = _mask.indexOf(37, offset)) != -1) {
            value = DString.change(_mask.substring(offset, bosOffset), "'", "''");
            if (value.length() > 0) {
                mask.append("'");
                mask.append(value);
                mask.append("'");
            }
            if (_mask.length() > bosOffset + 1) {
                switch (_mask.charAt(bosOffset + 1)) {
                    case 'a': {
                        mask.append("EEE");
                        break;
                    }
                    case 'A': {
                        mask.append("E");
                        break;
                    }
                    case 'b': {
                        mask.append("MMM");
                        break;
                    }
                    case 'B': {
                        mask.append("M");
                        break;
                    }
                    case 'c': {
                        mask.append("MM/dd/yy HH:mm:ss");
                        break;
                    }
                    case 'C': {
                        mask.append("MM/dd/yyyy HH:mm:ss");
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        mask.append("d");
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        mask.append("G");
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        mask.append("HH");
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        mask.append("hh");
                        break;
                    }
                    case 'J': 
                    case 'j': {
                        mask.append("D");
                        break;
                    }
                    case 'm': {
                        mask.append("MM");
                        break;
                    }
                    case 'M': {
                        mask.append("mm");
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        mask.append("a");
                        break;
                    }
                    case 'S': 
                    case 's': {
                        mask.append("ss");
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        mask.append("ww");
                        break;
                    }
                    case 'w': {
                        mask.append("EE");
                        break;
                    }
                    case 'W': {
                        mask.append("w");
                        break;
                    }
                    case 'x': {
                        mask.append("MM/dd/yy");
                        break;
                    }
                    case 'X': {
                        mask.append("HH:mm:ss");
                        break;
                    }
                    case 'y': {
                        mask.append("yy");
                        break;
                    }
                    case 'Y': {
                        mask.append("y");
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        mask.append("z");
                        break;
                    }
                    case '%': {
                        mask.append("%");
                    }
                }
            }
            offset = bosOffset + 2;
        }
        value = DString.change(_mask.substring(offset, _mask.length()), "'", "''");
        if (value.length() > 0) {
            mask.append("'");
            mask.append(value);
            mask.append("'");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(mask.toString());
        return formatter.format(_dt);
    }

    private final class ServletContext {
        PrintWriter writer;
        Hashtable vars;
        String item;
        String statement;
        StringTokenizer st;
        String errmsg;
        String timefmt;
        int sizefmt = 1024;
        String var;
        String value;
        String path;
        IOHandler handler;
        Request request;
        Response response;
        String charset;

        ServletContext(Request _request, Response _response) {
            this.request = _request;
            this.response = _response;
        }
    }
}

