/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import stec.iws.RequestHandler;
import stec.iws.ResponseOutputStream;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public final class Response
implements HttpServletResponse {
    protected ResponseOutputStream responseOutputStream;
    protected PrintWriter responseWriter = null;
    protected static final int NONE = 0;
    protected static final int SERVLET_WRITER = 1;
    protected static final int SERVLET_OUTPUT_STREAM = 2;
    protected int whichOutputStream = 0;
    protected int iStatus;
    protected boolean headersSent = false;
    protected Hashtable headers = new Hashtable();
    protected Vector cookies = new Vector();
    protected String item = null;
    protected int bufsize;
    protected RequestHandler handler;
    protected Locale locale = iws.default_locale;
    protected boolean send_session_id = true;
    private SimpleDateFormat dtFmt;

    protected Response(RequestHandler _handler) {
        this.handler = _handler;
        this.responseOutputStream = new ResponseOutputStream(this);
        this.dtFmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        this.bufsize = iws.output_buffer_size;
    }

    protected final void init(Socket socket) throws IOException {
        if (this.bufsize < 0) {
            this.responseOutputStream._init(new BufferedOutputStream(socket.getOutputStream()));
        } else if (this.bufsize == 0) {
            this.responseOutputStream._init(socket.getOutputStream());
        } else {
            this.responseOutputStream._init(new BufferedOutputStream(socket.getOutputStream(), this.bufsize));
        }
    }

    private final void resetOutputStream() throws IOException {
        if (this.bufsize != iws.output_buffer_size && !this.handler.in_servlet_chain) {
            if (this.bufsize < 0) {
                this.responseOutputStream._init(new BufferedOutputStream(this.handler.socket.getOutputStream()));
            } else if (this.bufsize == 0) {
                this.responseOutputStream._init(this.handler.socket.getOutputStream());
            } else {
                this.responseOutputStream._init(new BufferedOutputStream(this.handler.socket.getOutputStream(), this.bufsize));
            }
        }
    }

    public final void flush() throws IOException {
        if (this.responseWriter != null) {
            this.responseWriter.flush();
        }
        if (this.responseOutputStream != null) {
            this.responseOutputStream.flush();
        }
    }

    protected final void _wrapup() {
        if (this.responseWriter != null) {
            try {
                this.responseWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.responseWriter = null;
        this.whichOutputStream = 0;
        this.bufsize = iws.output_buffer_size;
        this.cookies.removeAllElements();
        this.headers.clear();
        this.headersSent = false;
        this.locale = iws.default_locale;
        this.send_session_id = true;
    }

    public final void addCookie(Cookie cookie) {
        this.cookies.addElement(cookie);
    }

    public final boolean containsHeader(String name) {
        return this.headers.contains(name);
    }

    public final String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public final String encodeRedirectURL(String _url) {
        if (_url.charAt(0) == '#') {
            return _url;
        }
        if (this.handler.request.session == null) {
            return _url;
        }
        if (this.handler.request.session.session_source != 1) {
            return _url;
        }
        if (!this.handler.request.session.isValid()) {
            return _url;
        }
        try {
            URL url = new URL(_url);
            if (!url.getProtocol().equalsIgnoreCase(this.handler.request.getScheme())) {
                return _url;
            }
            if (!url.getHost().equalsIgnoreCase(this.handler.request.getServerName())) {
                return _url;
            }
            if (url.getPort() != iws.port) {
                return _url;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return this._encodeURL(_url);
    }

    public final String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public final String encodeURL(String url) {
        if (this.handler.request.session == null) {
            return url;
        }
        if (this.handler.request.session.session_source != 1) {
            return url;
        }
        if (!this.handler.request.session.isValid()) {
            return url;
        }
        return this._encodeURL(url);
    }

    private final String _encodeURL(String url) {
        StringBuffer sb;
        int toffset;
        String path = url;
        String query = "";
        String anchor = "";
        int offset = url.indexOf(63);
        if (offset != -1) {
            path = url.substring(0, offset);
            query = url.substring(offset);
        }
        if ((offset = path.indexOf(35)) != -1) {
            anchor = path.substring(offset);
            path = path.substring(0, offset);
        }
        if (path.length() > 0 && (offset = path.indexOf(59)) != -1 && (toffset = path.indexOf(iws.sessionName, offset)) != -1) {
            path = path.substring(0, offset);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(';');
            sb.append(iws.sessionName);
            sb.append('=');
            sb.append(this.handler.request.session.id);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public final void sendRedirect(String location) throws IOException {
        this.setHeader("Location", location);
        this.handler.request.location = location;
        this.sendMessage(302, null);
    }

    public final void sendRedirect(String location, boolean permanent) throws IOException {
        this.setHeader("Location", location);
        this.handler.request.location = location;
        this.sendMessage(permanent ? 301 : 302, null);
    }

    public final void sendError(int errorcode) throws IOException {
        this._sendError(errorcode, null);
    }

    public final void sendError(int sc, String msg) throws IOException {
        this._sendError(sc, msg);
    }

    protected final void sendError(Throwable _ex) throws IOException {
        try {
            iws.logger.log(_ex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.iStatus < 400) {
            this.iStatus = 500;
        }
        this._sendError(this.iStatus, _ex.toString());
    }

    protected final void _sendError(int sc, String msg) throws IOException {
        this.sendMessage(sc, msg);
    }

    private final String replaceServerVariables(int status_code, String str) {
        if (str.indexOf(37) == -1) {
            return str;
        }
        str = DString.replace(str, "%error%", String.valueOf(status_code));
        str = Response.replaceServerVariable(str, "%auth_type%", Utils.filter(this.handler.request.auth_type));
        str = Response.replaceServerVariable(str, "%auth_user%", Utils.filter(this.handler.request.auth_user));
        str = Response.replaceServerVariable(str, "%auth_password%", Utils.filter(this.handler.request.auth_password));
        str = Response.replaceServerVariable(str, "%https%", this.handler.request.isSecure() ? "on" : "off");
        str = Response.replaceServerVariable(str, "%location%", this.handler.request.location);
        str = Response.replaceServerVariable(str, "%instance_id%", this.handler.request.session == null ? null : this.handler.request.session.id);
        str = Response.replaceServerVariable(str, "%server_software%", this.handler.request.server_software);
        str = Response.replaceServerVariable(str, "%remote_host%", Utils.filter(this.handler.request.remote_host));
        str = Response.replaceServerVariable(str, "%remote_addr%", this.handler.request.remote_addr);
        str = Response.replaceServerVariable(str, "%server_name%", Utils.filter(this.handler.request.server_name));
        str = Response.replaceServerVariable(str, "%server_port%", String.valueOf(this.handler.request.server_port));
        str = Response.replaceServerVariable(str, "%request_method%", Utils.filter(this.handler.request.request_method));
        str = Response.replaceServerVariable(str, "%request_uri%", Utils.filter(this.handler.request.request_uri));
        str = Response.replaceServerVariable(str, "%query_string%", Utils.filter(this.handler.request.query_string));
        str = Response.replaceServerVariable(str, "%script_name%", Utils.filter(this.handler.request.script_name));
        str = Response.replaceServerVariable(str, "%server_protocol%", this.handler.request.server_protocol);
        str = Response.replaceServerVariable(str, "%path_translated%", Utils.filter(this.handler.request.getPathTranslated()));
        str = Response.replaceServerVariable(str, "%local_addr%", this.handler.request.local_addr);
        return str;
    }

    private static final String replaceServerVariable(String str, String key, String value) {
        if (value == null) {
            value = "";
        }
        return DString.replace(str, key, value);
    }

    private final String getMessage(int status_code) {
        Object obj = iws.messages.get(String.valueOf(status_code));
        if (obj == null && (obj = iws.messages.get(String.valueOf(500))) == null) {
            obj = iws.local_strings.getLocalString("err.server_error", String.valueOf(status_code));
        }
        return (String)obj;
    }

    private final String getErrorMessage(int status_code) {
        String message = this.getMessage(status_code);
        int offset = message.indexOf(59);
        if (offset != -1) {
            message = message.substring(offset + 1);
        }
        return this.replaceServerVariables(status_code, message);
    }

    private final String getHeaderMessage(int status_code) {
        String message = this.getMessage(status_code);
        int offset = message.indexOf(59);
        if (offset != -1) {
            message = message.substring(0, offset);
        }
        return this.replaceServerVariables(status_code, message);
    }

    private final void sendMessage(int status, String message) throws IOException {
        this._reset();
        this.whichOutputStream = 0;
        this.headers.remove("Vary");
        this.headers.remove("Date");
        this.headers.remove("Content-Type");
        this.headers.remove("Content-Language");
        this.headers.remove("Content-Length");
        this.headers.remove("Content-Encoding");
        this.headers.remove("Last-Modified");
        this.headers.remove("Accept-Ranges");
        this.headers.remove("ETag");
        this.headers.remove("Content-Range");
        if (status > 399) {
            this.handler.keepAlive = false;
        }
        StringBuffer sb = new StringBuffer("text/html");
        if (iws.default_charset != null) {
            sb.append("; charset=");
            sb.append(iws.default_charset);
        }
        this.setContentType(sb.toString());
        if (iws.default_language != null) {
            this.setHeader("Content-Language", iws.default_language);
        }
        String item = new String(iws.error_message_template);
        item = DString.replace(item, "%error%", this.getHeaderMessage(status));
        if (message == null) {
            message = this.getErrorMessage(status);
        }
        item = DString.replace(item, "%message%", message);
        this.setStatus(status);
        this.setContentLength(item.length());
        PrintWriter writer = this.getWriter();
        writer.write(item);
    }

    protected final void sendHeaders() throws IOException {
        if (this.handler.in_servlet_chain) {
            return;
        }
        if (this.headersSent) {
            return;
        }
        this.headersSent = true;
        if (this.handler.request.getServerProtocolVersion() > 0) {
            this.responseOutputStream._print("HTTP/1.1 ");
        } else {
            this.responseOutputStream._print("HTTP/1.0 ");
        }
        this.responseOutputStream._println(this.getHeaderMessage(this.iStatus));
        if (!iws.obscure_server) {
            this.responseOutputStream._print("Server: ");
            this.responseOutputStream._println(iws.SERVER_SOFTWARE);
        }
        if (this.handler.canKeepAlive() && this.handler.keepAlive && this.handler.request.getServerProtocolVersion() > 0) {
            String value;
            if (iws.keepAliveTimeout != -1 && this.handler.keepAliveTimeout < System.currentTimeMillis()) {
                this.handler.keepAlive = false;
            }
            if (this.handler.keepAliveRequests != -1) {
                --this.handler.keepAliveRequests;
                if (this.handler.keepAliveRequests < 0) {
                    this.handler.keepAlive = false;
                }
            }
            if ((value = this.getHeader("Connection")) != null && value.equalsIgnoreCase("close")) {
                this.handler.keepAlive = false;
            }
            if (this.handler.keepAlive && this.getContentLength() < 0) {
                this.handler.keepAlive = false;
            }
        } else {
            this.handler.keepAlive = false;
        }
        if (this.handler.keepAlive) {
            this.setHeader("Connection", "Keep-Alive");
        } else {
            this.setHeader("Connection", "Close");
        }
        Enumeration<Object> e = this.headers.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] values = (String[])this.headers.get(key);
            int length = values.length;
            int i = 0;
            while (i < length) {
                this.responseOutputStream._print(key);
                this.responseOutputStream._print(": ");
                this.responseOutputStream._println(values[i]);
                ++i;
            }
        }
        if (this.send_session_id) {
            if (this.handler.request.session == null) {
                this.clearCookie(iws.sessionName);
                this.clearCookie("iwsServerID");
            } else if (this.handler.request.session.isValid()) {
                if (this.handler.request.session.session_source != 1) {
                    Utils.addCookie(this.handler, this.cookies, iws.sessionName, this.handler.request.session.id);
                }
                if (!iws.sessionStore.isDistributed() || !this.handler.request.session.canSerialize()) {
                    Cookie tcookie = Utils.extractCookie(this.handler.request.cookies, "iwsClusterID");
                    if (tcookie != null) {
                        Utils.addCookie(this.handler, this.cookies, "iwsServerID", tcookie.getValue());
                    }
                } else {
                    this.clearCookie("iwsServerID");
                }
            } else {
                this.clearCookie(iws.sessionName);
                this.clearCookie("iwsServerID");
            }
        }
        e = this.cookies.elements();
        while (e.hasMoreElements()) {
            this.responseOutputStream._print("Set-Cookie: ");
            this.responseOutputStream._println(Utils.encodeCookie((Cookie)e.nextElement()));
        }
        this.responseOutputStream._println();
    }

    public final void setDateHeader(String name, long date) {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        this.dtFmt.setTimeZone(tz);
        this.setHeader(name, this.dtFmt.format(new Date(date)));
    }

    public final void setHeader(String name, String value) {
        Utils.setHeader(this.headers, name, value);
    }

    public final void addHeader(String name, String value) {
        String[] avalue;
        Object obj = this.headers.get(name);
        if (obj == null) {
            avalue = new String[]{value};
        } else {
            String[] tarray = (String[])obj;
            avalue = new String[tarray.length + 1];
            System.arraycopy(tarray, 0, avalue, 0, tarray.length);
            avalue[tarray.length] = value;
        }
        this.headers.put(name, avalue);
    }

    public final void addDateHeader(String name, long date) {
        SimpleDateFormat dtFmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        TimeZone tz = TimeZone.getTimeZone("GMT");
        dtFmt.setTimeZone(tz);
        this.addHeader(name, dtFmt.format(new Date(date)));
    }

    public final void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public final String getHeader(String name) {
        Object obj = this.headers.get(name);
        if (obj == null) {
            return null;
        }
        return ((String[])obj)[0];
    }

    public final void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public final void setStatus(int status) {
        this.setStatus(status, null);
    }

    public final void setStatus(int status, String msg) {
        this.iStatus = status;
    }

    public final String getCharacterEncoding() {
        String charset = Utils.parseCharacterEncoding(this.getContentType(), null);
        if (charset == null) {
            String language;
            Object obj = iws.locales.get(this.locale.toString());
            if (obj == null && (obj = iws.locales.get(language = this.locale.getLanguage())) == null) {
                obj = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
            }
            charset = (String)obj;
        }
        return charset;
    }

    public final ServletOutputStream getOutputStream() throws IOException {
        if (this.whichOutputStream == 1) {
            throw new IllegalStateException(iws.local_strings.getLocalString("err.has_already_been_called", "getWriter()"));
        }
        if (this.whichOutputStream == 0) {
            this.whichOutputStream = 2;
            this.resetOutputStream();
        }
        return this.responseOutputStream;
    }

    public final PrintWriter getWriter() throws IOException {
        if (this.whichOutputStream == 2) {
            throw new IllegalStateException(iws.local_strings.getLocalString("err.has_already_been_called", "getOutputStream()"));
        }
        if (this.whichOutputStream == 0) {
            this.whichOutputStream = 1;
            this.resetOutputStream();
            this.responseWriter = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.responseOutputStream), this.getCharacterEncoding()));
        }
        return this.responseWriter;
    }

    public final void setContentLength(int len) {
        this.setHeader("Content-Length", String.valueOf(len));
    }

    public final void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    protected final String getContentType() {
        return this.getHeader("Content-Type");
    }

    protected final int getContentLength() {
        String value = this.getHeader("Content-Length");
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public final void setBufferSize(int size) {
        if (this.responseOutputStream.getBytesWritten() > 0L || this.headersSent || this.whichOutputStream != 0) {
            throw new IllegalStateException(iws.local_strings.getLocalString("err.output_stream_has_already_been_used"));
        }
        if (!this.handler.in_servlet_chain) {
            this.bufsize = size;
        }
    }

    public final int getBufferSize() {
        if (this.handler.in_servlet_chain) {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)this.responseOutputStream.getOutputStream();
            return bos.size();
        }
        return this.bufsize;
    }

    public final void reset() throws IllegalStateException {
        this._reset();
        this.headers.clear();
        this.cookies.removeAllElements();
    }

    private final void _reset() throws IllegalStateException {
        if (this.handler.in_servlet_chain) {
            try {
                this.responseOutputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.headers.remove("Content-Length");
            this.handler.in_servlet_chain = false;
            this.headersSent = false;
            ByteArrayOutputStream bos = (ByteArrayOutputStream)this.responseOutputStream.getOutputStream();
            bos.reset();
            this.responseOutputStream._init(bos);
        } else if (this.headersSent) {
            throw new IllegalStateException(iws.local_strings.getLocalString("err.headers_have_already_been_sent"));
        }
    }

    public final boolean isCommitted() {
        return this.headersSent;
    }

    public final void flushBuffer() throws IOException {
        this.flush();
    }

    public final void setLocale(Locale _locale) {
        this.locale = _locale;
        String content_type = this.getContentType();
        int offset = content_type.indexOf("charset=");
        content_type = offset == -1 ? String.valueOf(content_type) + "; charset=" + this.getCharacterEncoding() : String.valueOf(content_type.substring(0, offset + 1)) + this.getCharacterEncoding();
        this.setContentType(content_type);
    }

    public final Locale getLocale() {
        return this.locale;
    }

    protected final void removeCookie(String id) {
        int count = this.cookies.size();
        int i = 0;
        int o = 0;
        while (i < count) {
            Cookie cookie = (Cookie)this.cookies.elementAt(o);
            if (cookie.getName().equals(id)) {
                this.cookies.removeElementAt(o);
            } else {
                ++o;
            }
            ++i;
        }
    }

    private final void clearCookie(String id) {
        this.removeCookie(id);
        Cookie cookie = Utils.extractCookie(this.handler.request.cookies, id);
        if (cookie != null) {
            cookie = new Cookie(id, cookie.getValue());
            if (iws.sessionDomain != null) {
                String domain = DString.replace(iws.sessionDomain, "%host%", this.handler.request.getServerName());
                domain = DString.replace(domain, "%local_address%", this.handler.request.getLocalAddr());
                cookie.setDomain(domain);
            }
            if (iws.sessionPath != null) {
                String path = DString.replace(iws.sessionPath, "%base_uri%", this.handler.request.getRequestURI());
                path = DString.replace(path, "%request_uri%", this.handler.request.getRequestURI());
                path = DString.replace(path, "%script_name%", this.handler.request.getServletPath());
                path = DString.replace(path, "%servlet_context_path%", this.handler.request.getContextPath());
                cookie.setPath(path);
            }
            cookie.setSecure(iws.sessionSecure);
            cookie.setMaxAge(0);
            this.cookies.addElement(cookie);
        }
    }

    protected final void close() {
        if (this.responseOutputStream != null) {
            try {
                this.responseOutputStream._close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void sendSessionID(boolean send_session_id) {
        this.send_session_id = send_session_id;
    }

    public final boolean sendSessionID() {
        return this.send_session_id;
    }

    public final void shutdown() {
        this.handler.shutdown();
    }

    public final boolean getHeadersSent() {
        return this.headersSent;
    }

    public final void setHeadersSent(boolean headers_sent) {
        this.headersSent = headers_sent;
    }

    public final void setKeepAlive(boolean keep_alive) {
        this.handler.keepAlive = false;
    }

    public boolean getKeepAlive() {
        return this.handler.keepAlive;
    }
}

