/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.Utils;
import stec.iws.iws;

public final class RequestInputStream
extends ServletInputStream {
    private Request request;
    private InputStream is;
    private long bytesRead;
    private long bytesAvailable;
    byte[] header_buffer;

    public RequestInputStream(Request _request) {
        if (iws.max_request_header_length != -1) {
            this.header_buffer = new byte[iws.max_request_header_length];
        }
        this.request = _request;
    }

    protected final void _init(InputStream _is) {
        this.is = _is;
        this.bytesRead = 0L;
        this.bytesAvailable = 0L;
    }

    protected final int _read() throws IOException {
        int byt = this.is.read();
        if (byt != -1) {
            ++this.bytesRead;
            if (this.request.handler.debug_log_request_os != null && !(this.is instanceof ByteArrayInputStream)) {
                this.request.handler.debug_log_request_os.write(byt);
            }
        }
        return byt;
    }

    protected final int _read(byte[] bytes) throws IOException {
        return this._read(bytes, 0, bytes.length);
    }

    protected final int _read(byte[] bytes, int offset, int length) throws IOException {
        int count = this.is.read(bytes, offset, length);
        if (count > 0) {
            this.bytesRead += (long)count;
            if (this.request.handler.debug_log_request_os != null && !(this.is instanceof ByteArrayInputStream)) {
                this.request.handler.debug_log_request_os.write(bytes, offset, count);
            }
        }
        return count;
    }

    protected final long _skip(long n) throws IOException {
        long count = this.is.skip(n);
        if (count > 0L) {
            this.bytesRead += count;
        }
        return count;
    }

    private static final byte[] grow_array(byte[] buffer, int size) {
        byte[] nbuffer = new byte[buffer.length + size];
        System.arraycopy(buffer, 0, nbuffer, 0, buffer.length);
        return nbuffer;
    }

    protected final String _readLine() throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        int total_length = 0;
        int remaining_length = 1024;
        while ((length = this._readLine(buffer, total_length, remaining_length)) != -1) {
            if (length <= 0) continue;
            if (buffer[(total_length += length) - 1] == 10) {
                if (--total_length <= 0 || buffer[total_length - 1] != 13) break;
                --total_length;
                break;
            }
            if ((remaining_length -= length) >= 128) continue;
            remaining_length += 1024;
            buffer = RequestInputStream.grow_array(buffer, 1024);
        }
        return new String(buffer, 0, total_length);
    }

    protected final int _readLine(byte[] buffer, int sOffset, int length) throws IOException {
        int count = Utils.readLine(this.is, buffer, sOffset, length);
        if (count > 0) {
            this.bytesRead += (long)count;
            if (this.request.handler.debug_log_request_os != null && !(this.is instanceof ByteArrayInputStream)) {
                this.request.handler.debug_log_request_os.write(buffer, sOffset, count);
            }
        }
        return count;
    }

    protected final String _readHeader(boolean uri) throws IOException {
        int length;
        byte[] buffer;
        int remaining_length;
        if (iws.max_request_header_length == -1) {
            remaining_length = 1024;
            buffer = new byte[1024];
        } else {
            remaining_length = iws.max_request_header_length;
            buffer = this.header_buffer;
        }
        int total_length = 0;
        boolean multiline = false;
        while ((length = this._readLine(buffer, total_length, remaining_length)) != -1) {
            if (length <= 0) continue;
            total_length += length;
            if (multiline) {
                int tlength = total_length - length;
                buffer[tlength] = 32;
                boolean found = false;
                int i = ++tlength;
                while (i < total_length) {
                    if (buffer[i] != 32 && buffer[i] != 9) {
                        System.arraycopy(buffer, i, buffer, tlength, total_length - i);
                        total_length -= i - tlength;
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    total_length -= length;
                }
                multiline = false;
            }
            if (buffer[total_length - 1] == 10) {
                if (--total_length > 0 && buffer[total_length - 1] == 13) {
                    --total_length;
                }
                if (total_length <= 0 || !iws.multiline_request_headers) break;
                this.is.mark(1);
                int chr = this.is.read();
                this.is.reset();
                if (chr != 32 && chr != 9) break;
                multiline = true;
            }
            remaining_length -= length;
            if (iws.max_request_header_length == -1) {
                if (remaining_length >= 128) continue;
                remaining_length += 1024;
                buffer = RequestInputStream.grow_array(buffer, 1024);
                continue;
            }
            if (remaining_length > 0) continue;
            if (uri) {
                Response cfr_ignored_0 = this.request.handler.response;
                this.request.handler.response.setStatus(414);
            } else {
                Response cfr_ignored_1 = this.request.handler.response;
                this.request.handler.response.setStatus(413);
            }
            throw new IOException(iws.local_strings.getLocalString("err.request_header_length_exceeds_maximum_request_header_length", String.valueOf(iws.max_request_header_length)));
        }
        return new String(buffer, 0, total_length);
    }

    protected final void setBytesAvailable(long _bytesAvailable) {
        this.bytesAvailable = _bytesAvailable;
    }

    public final int read() throws IOException {
        if (this.bytesAvailable > 0L) {
            int byt = this._read();
            this.bytesAvailable = byt == -1 ? 0L : --this.bytesAvailable;
            return byt;
        }
        return -1;
    }

    public final int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public final int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.bytesAvailable > 0L) {
            int count;
            if ((long)length > this.bytesAvailable) {
                length = (int)this.bytesAvailable;
            }
            this.bytesAvailable = (count = this._read(bytes, offset, length)) == -1 ? 0L : (this.bytesAvailable -= (long)count);
            return count;
        }
        return -1;
    }

    public final long skip(long length) throws IOException {
        if (this.bytesAvailable > 0L) {
            long count;
            if (length > this.bytesAvailable) {
                length = this.bytesAvailable;
            }
            if ((count = this._skip(length)) > 0L) {
                this.bytesAvailable -= count;
            }
            return count;
        }
        return 0L;
    }

    public final String readLine() throws IOException {
        if (this.bytesAvailable > 0L) {
            String line = this._readLine();
            this.bytesAvailable = line == null ? 0L : (this.bytesAvailable -= (long)line.length());
            return line;
        }
        return null;
    }

    public final int readLine(byte[] buffer, int sOffset, int length) throws IOException {
        if (this.bytesAvailable > 0L) {
            int count;
            if ((long)length > this.bytesAvailable) {
                length = (int)this.bytesAvailable;
            }
            this.bytesAvailable = (count = this._readLine(buffer, sOffset, length)) == -1 ? 0L : (this.bytesAvailable -= (long)count);
            return count;
        }
        return -1;
    }

    public final void close() throws IOException {
    }

    public final long getBytesRead() {
        return this.bytesRead;
    }

    public final long getBytesAvailable() {
        return this.bytesAvailable;
    }

    public final InputStream getInputStream() {
        return this.is;
    }

    final void _close() throws IOException {
        this.is.close();
    }
}

