/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.iws;
import stec.lang.DString;

public class RedirectServlet
extends HttpServlet {
    private String url;
    private boolean permanently = false;

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.url = config.getInitParameter("url");
        if (this.url == null) {
            throw new ServletException(iws.local_strings.getLocalString("err.was_not_specified", "url"));
        }
        String value = config.getInitParameter("permanently");
        if (value == null) {
            value = "n";
        }
        this.permanently = (value = value.trim()).equalsIgnoreCase("y");
    }

    public final void service(HttpServletRequest _request, HttpServletResponse _response) throws IOException, ServletException {
        Request request = (Request)_request;
        String turl = new String(this.url);
        turl = DString.replace(turl, "%protocol%", request.getScheme());
        turl = DString.replace(turl, "%hostname%", request.getServerName());
        turl = DString.replace(turl, "%port%", String.valueOf(request.getServerPort()));
        turl = DString.replace(turl, "%raw_request_uri%", request.raw_request_uri);
        turl = DString.replace(turl, "%request_uri%", request.getRequestURI());
        turl = DString.replace(turl, "%request_method%", request.getMethod());
        turl = DString.replace(turl, "%context_path%", request.getContextPath());
        turl = DString.replace(turl, "%script_name%", request.getServletPath());
        String value = request.getPathInfo();
        if (value == null) {
            value = "";
        }
        turl = DString.replace(turl, "%path_info%", value);
        value = request.getQueryString();
        if (value == null) {
            value = "";
        }
        turl = DString.replace(turl, "%query_string%", value);
        ((Response)_response).sendRedirect(turl, this.permanently);
    }
}

