/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stec.iws.LockTable;
import stec.iws.MemorySessionStore;
import stec.iws.ServletContextImpl;
import stec.iws.Session;
import stec.iws.Utils;
import stec.pos.Blob;
import stec.pos.ObjectStoreEnumeration;
import stec.xpos.ObjectStore;
import stec.xpos.ObjectStoreReference;

public final class PosSessionStore
extends MemorySessionStore {
    private static final String BASEDIR = "./databases";
    private static final byte[] delimiter = new byte[]{-1};
    private static final String DELIMITER = new String(delimiter);
    private boolean persistent = true;
    private long save_interval;
    private LockTable locks = new LockTable();
    private boolean checking = false;
    private String object_store;

    @Override
    public final void init(Hashtable _parameters) throws Exception {
        super.init(_parameters);
        Object obj = _parameters.get("sessions_store");
        this.object_store = obj == null ? Utils.concatPaths(BASEDIR, "/sessions.store") : ((String[])obj)[0];
        this.object_store = Utils.getAbsolutePath(this.object_store);
        if (!ObjectStore.exists((String)this.object_store)) {
            long capacity;
            obj = _parameters.get("sessions_capacity");
            if (obj == null) {
                capacity = 65536L;
            } else {
                capacity = Long.parseLong(((String[])obj)[0]);
                if (capacity < 1L) {
                    throw new IllegalArgumentException("capacity must be at least 1: " + capacity);
                }
            }
            ObjectStore.create((String)this.object_store, (long)capacity, (long)-1L, (long)-1L, (long)-1L, (int)64, (int)256, (boolean)false);
        }
        String value = (obj = _parameters.get("persistent")) == null ? "n" : ((String[])obj)[0];
        this.persistent = value.equalsIgnoreCase("y");
        obj = _parameters.get("save_interval");
        if (obj == null) {
            this.save_interval = 300000L;
        } else {
            try {
                this.save_interval = Integer.parseInt(((String[])obj)[0]);
            }
            catch (NumberFormatException ex) {
                this.save_interval = -1L;
            }
            this.save_interval = this.save_interval < 0L ? 300000L : (this.save_interval *= 60000L);
        }
    }

    @Override
    public final void checkSessionStore() throws Exception {
        this.checking = true;
        try {
            super.checkSessionStore();
            this.checkPosSessionStore();
        }
        finally {
            this.checking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkPosSessionStore() throws Exception {
        ObjectStoreReference reference = ObjectStore.open((String)this.object_store, (boolean)false);
        try {
            ObjectStoreEnumeration e = reference.keys();
            while (e.hasMoreElements()) {
                Object lock;
                String id = (String)e.nextElement();
                Object object = lock = this.locks.lock(id);
                synchronized (object) {
                    block15: {
                        try {
                            Object obj = reference.get((Object)id);
                            if (obj == null) break block15;
                            Blob blob = (Blob)obj;
                            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(blob.getValue()));
                            boolean remove = false;
                            try {
                                is.readUTF();
                                is.readLong();
                                long lastAccessedTime = is.readLong();
                                long sessionTimeout = is.readLong();
                                if (sessionTimeout != -1L && System.currentTimeMillis() > lastAccessedTime + sessionTimeout) {
                                    remove = true;
                                }
                            }
                            finally {
                                is.close();
                            }
                            if (remove) {
                                reference.remove((Object)id);
                            }
                        }
                        finally {
                            this.locks.unlock(lock);
                        }
                    }
                }
            }
        }
        finally {
            reference.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkSession(Session _session) throws Exception {
        Object lock;
        String id = this.getID(_session);
        Object object = lock = this.locks.lock(id);
        synchronized (object) {
            block9: {
                try {
                    super.checkSession(_session);
                    if (!_session.isValid || this.save_interval <= 0L || System.currentTimeMillis() <= _session.lastUpdate + this.save_interval || _session.lastUpdate == -1L) break block9;
                    ObjectStoreReference reference = ObjectStore.open((String)this.object_store, (boolean)false);
                    try {
                        this._saveSession(reference, id, _session);
                    }
                    finally {
                        reference.close();
                    }
                }
                finally {
                    this.locks.unlock(lock);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Session getSession(ServletContextImpl _context, String _session_id) throws Exception {
        Object lock;
        Session session = null;
        String id = this.getID(_context, _session_id);
        Object object = lock = this.locks.lock(id);
        synchronized (object) {
            try {
                session = super.getSession(_context, _session_id);
                if (session == null) {
                    session = this._getSession(_context, id);
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
        return session;
    }

    private final Session _getSession(ServletContextImpl _context, String id) throws Exception {
        ObjectStoreReference reference = ObjectStore.open((String)this.object_store, (boolean)false);
        try {
            Session session = null;
            Object obj = reference.get((Object)id);
            if (obj != null) {
                boolean remove = false;
                Blob blob = (Blob)obj;
                ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(blob.getValue()));
                try {
                    session = new Session();
                    session.context = _context;
                    session.lastUpdate = -1L;
                    session.isValid = true;
                    session.id = is.readUTF();
                    session.creationTime = is.readLong();
                    session.lastAccessedTime = is.readLong();
                    session.sessionTimeout = is.readLong();
                    if (session._isValid()) {
                        session.remote_address = (InetAddress)is.readObject();
                        session.isNew = is.readBoolean();
                        int count = is.readInt();
                        int i = 0;
                        while (i < count) {
                            String key = is.readUTF();
                            Object value = is.readObject();
                            session._putValue(key, value);
                            ++i;
                        }
                        _context.sessions.put(session.id, session);
                    } else {
                        session = null;
                        remove = true;
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                if (remove) {
                    reference.remove((Object)id);
                }
            }
            Session session2 = session;
            return session2;
        }
        finally {
            reference.close();
        }
    }

    @Override
    public final void load(ServletContextImpl _context) throws Exception {
        if (!this.persistent) {
            ObjectStoreReference reference = ObjectStore.open((String)this.object_store, (boolean)false);
            try {
                this.removeAllSessions(reference, _context);
            }
            finally {
                reference.close();
            }
        }
    }

    @Override
    public final void unload(ServletContextImpl _context) throws Exception {
        try {
            ObjectStoreReference reference = ObjectStore.open((String)this.object_store, (boolean)false);
            try {
                if (this.persistent) {
                    this.saveAllSessions(reference, _context);
                } else {
                    this.removeAllSessions(reference, _context);
                }
            }
            finally {
                reference.close();
            }
        }
        finally {
            super.unload(_context);
        }
    }

    @Override
    public final void saveSession(Session _session, boolean _immediately) throws Exception {
        if (this.save_interval == 0L || _immediately) {
            ObjectStoreReference reference = ObjectStore.open((String)this.object_store, (boolean)false);
            try {
                this.saveSession(reference, _session);
            }
            finally {
                reference.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveSession(ObjectStoreReference reference, Session _session) throws Exception {
        Object lock;
        String id = this.getID(_session);
        Object object = lock = this.locks.lock(id);
        synchronized (object) {
            try {
                if (_session.isValid() && _session.lastUpdate != -1L) {
                    this._saveSession(reference, id, _session);
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _saveSession(ObjectStoreReference reference, String id, Session session) throws Exception {
        Session session2 = session;
        synchronized (session2) {
            session.lastUpdate = -1L;
            reference.remove((Object)id);
            if (!session.canSerialize()) {
                return;
            }
            session.context.sessions.remove(session.id);
            try {
                Object[] obj;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream os = new ObjectOutputStream(bos);
                os.writeUTF(session.id);
                os.writeLong(session.creationTime);
                os.writeLong(session.lastAccessedTime);
                os.writeLong(session.sessionTimeout);
                os.writeObject(session.remote_address);
                os.writeBoolean(session.isNew);
                Vector<Object[]> list = new Vector<Object[]>();
                Enumeration e = session.sessionData.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object value = session.sessionData.get(key);
                    obj = new Object[]{key, value};
                    list.addElement(obj);
                }
                os.writeInt(list.size());
                int i = 0;
                while (i < list.size()) {
                    obj = (Object[])list.elementAt(i);
                    os.writeUTF((String)obj[0]);
                    os.writeObject(obj[1]);
                    ++i;
                }
                os.flush();
                Blob blob = new Blob(bos.toByteArray());
                reference.put((Object)id, (Object)blob);
            }
            finally {
                session._clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeSession(Session _session) throws Exception {
        Object lock;
        String id = this.getID(_session);
        Object object = lock = this.locks.lock(id);
        synchronized (object) {
            try {
                super.removeSession(_session);
                ObjectStoreReference reference = ObjectStore.open((String)this.object_store, (boolean)false);
                try {
                    reference.remove((Object)id);
                }
                finally {
                    reference.close();
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeResidentSession(Session _session) throws Exception {
        Object lock;
        String id = this.getID(_session);
        Object object = lock = this.locks.lock(id);
        synchronized (object) {
            try {
                ObjectStoreReference reference = ObjectStore.open((String)this.object_store, (boolean)false);
                try {
                    reference.remove((Object)id);
                }
                finally {
                    reference.close();
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    private final void saveAllSessions(ObjectStoreReference reference, ServletContextImpl _context) throws Exception {
        Enumeration e = _context.sessions.elements();
        while (e.hasMoreElements()) {
            Session session = (Session)e.nextElement();
            this.saveSession(reference, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeAllSessions(ObjectStoreReference reference, ServletContextImpl _context) throws Exception {
        ObjectStoreEnumeration e = reference.keys();
        while (e.hasMoreElements()) {
            Object lock;
            String id = (String)e.nextElement();
            Object object = lock = this.locks.lock(id);
            synchronized (object) {
                try {
                    if (id.startsWith(_context.name)) {
                        reference.remove((Object)id);
                    }
                }
                finally {
                    this.locks.unlock(lock);
                }
            }
        }
    }

    @Override
    public final boolean isDistributed() {
        return false;
    }

    private final String getID(ServletContextImpl _context, String _session_id) {
        StringBuffer sb = new StringBuffer(_context.name);
        sb.append(DELIMITER);
        sb.append(_session_id);
        return sb.toString();
    }

    private final String getID(Session _session) {
        StringBuffer sb = new StringBuffer(_session.context.name);
        sb.append(DELIMITER);
        sb.append(_session.id);
        return sb.toString();
    }
}

