/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Principal;
import java.util.Hashtable;
import stec.iws.PrincipalImpl;
import stec.iws.Realm;
import stec.iws.Utils;
import stec.lang.DString;
import stec.pos.ObjectStoreEnumeration;
import stec.xpos.ObjectStore;
import stec.xpos.ObjectStoreReference;

public final class PosRealm
extends Realm {
    private static final String BASEDIR = "./databases";
    private String acls_object_store;
    private String users_object_store;
    private String groups_object_store;
    private String computers_object_store;
    private String rights_object_store;

    @Override
    public final void init(Hashtable _parameters) throws Exception {
        long capacity;
        super.init(this.init_parameters);
        Object obj = _parameters.get("acls_store");
        this.acls_object_store = obj == null ? Utils.concatPaths(BASEDIR, "/acls.store") : ((String[])obj)[0];
        this.acls_object_store = Utils.getAbsolutePath(this.acls_object_store);
        if (!ObjectStore.exists((String)this.acls_object_store)) {
            obj = _parameters.get("acls_capacity");
            if (obj == null) {
                capacity = 1024L;
            } else {
                capacity = Long.parseLong(((String[])obj)[0]);
                if (capacity < 1L) {
                    throw new IllegalArgumentException("acls_capacity must be at least 1: " + capacity);
                }
            }
            ObjectStore.create((String)this.acls_object_store, (long)capacity, (long)-1L, (long)-1L, (long)-1L, (int)16, (int)16, (boolean)false);
        }
        this.groups_object_store = (obj = _parameters.get("groups_store")) == null ? Utils.concatPaths(BASEDIR, "/groups.store") : ((String[])obj)[0];
        this.groups_object_store = Utils.getAbsolutePath(this.groups_object_store);
        if (!ObjectStore.exists((String)this.groups_object_store)) {
            obj = _parameters.get("groups_capacity");
            if (obj == null) {
                capacity = 1024L;
            } else {
                capacity = Long.parseLong(((String[])obj)[0]);
                if (capacity < 1L) {
                    throw new IllegalArgumentException("groups_capacity must be at least 1: " + capacity);
                }
            }
            ObjectStore.create((String)this.groups_object_store, (long)capacity, (long)-1L, (long)-1L, (long)-1L, (int)16, (int)16, (boolean)false);
        }
        this.computers_object_store = (obj = _parameters.get("computers_store")) == null ? Utils.concatPaths(BASEDIR, "/computers.store") : ((String[])obj)[0];
        this.computers_object_store = Utils.getAbsolutePath(this.computers_object_store);
        if (!ObjectStore.exists((String)this.computers_object_store)) {
            obj = _parameters.get("computers_capacity");
            if (obj == null) {
                capacity = 1024L;
            } else {
                capacity = Long.parseLong(((String[])obj)[0]);
                if (capacity < 1L) {
                    throw new IllegalArgumentException("computers_capacity must be at least 1: " + capacity);
                }
            }
            ObjectStore.create((String)this.computers_object_store, (long)capacity, (long)-1L, (long)-1L, (long)-1L, (int)32, (int)16, (boolean)false);
        }
        this.rights_object_store = (obj = _parameters.get("rights_store")) == null ? Utils.concatPaths(BASEDIR, "/rights.store") : ((String[])obj)[0];
        this.rights_object_store = Utils.getAbsolutePath(this.rights_object_store);
        if (!ObjectStore.exists((String)this.rights_object_store)) {
            obj = _parameters.get("rights_capacity");
            if (obj == null) {
                capacity = 16L;
            } else {
                capacity = Long.parseLong(((String[])obj)[0]);
                if (capacity < 1L) {
                    throw new IllegalArgumentException("rights_capacity must be at least 1: " + capacity);
                }
            }
            ObjectStore.create((String)this.rights_object_store, (long)capacity, (long)-1L, (long)-1L, (long)-1L, (int)8, (int)1, (boolean)false);
        }
        this.users_object_store = (obj = _parameters.get("users_store")) == null ? Utils.concatPaths(BASEDIR, "/users.store") : ((String[])obj)[0];
        this.users_object_store = Utils.getAbsolutePath(this.users_object_store);
        if (!ObjectStore.exists((String)this.users_object_store)) {
            obj = _parameters.get("users_capacity");
            if (obj == null) {
                capacity = 1024L;
            } else {
                capacity = Long.parseLong(((String[])obj)[0]);
                if (capacity < 1L) {
                    throw new IllegalArgumentException("users_capacity must be at least 1: " + capacity);
                }
            }
            ObjectStore.create((String)this.users_object_store, (long)capacity, (long)-1L, (long)-1L, (long)-1L, (int)16, (int)16, (boolean)false);
        }
    }

    @Override
    public final boolean authenticateUser(String _acls, String _username, String _password, String _method) throws Exception {
        if (!this.isValid(_username, _password)) {
            return false;
        }
        int count = DString.dcount(_acls, ",");
        int i = 0;
        while (i < count) {
            String acl = DString.extract(_acls, ",", i).trim();
            String rights = this.checkACL(acl, _username);
            if (rights != null) {
                return this.canAccess(rights, _method);
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean isValid(String _username, String _password) throws FileNotFoundException, IOException {
        ObjectStoreReference reference = ObjectStore.open((String)this.users_object_store, (boolean)false);
        try {
            Object obj = reference.get((Object)_username);
            if (obj == null) {
                return false;
            }
            if (_password.equals((String)obj)) return true;
            return false;
        }
        finally {
            reference.close();
        }
    }

    private final boolean canAccess(String _rights, String _method) {
        int count = DString.dcount(_rights, ",");
        int i = 0;
        while (i < count) {
            String right = DString.extract(_rights, ",", i).trim();
            if (right.equals("*") || right.equalsIgnoreCase(_method)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String checkACL(String _acl, String _username) throws FileNotFoundException, IOException {
        offset = _acl.indexOf(46);
        type = _acl.substring(0, offset);
        name = _acl.substring(offset + 1);
        reference = ObjectStore.open((String)this.acls_object_store, (boolean)false);
        try {
            e = reference.keys();
            if (true) ** GOTO lbl22
            while (true) {
                if (!(key = (String)e.nextElement()).equals(_acl)) break block5;
                if (!type.equals("group")) ** GOTO lbl-1000
                if (!this.checkGroup(name, _username)) break;
                var10_9 = (String)reference.get((Object)key);
                break;
            }
        }
        catch (Throwable var9_11) {
            reference.close();
            throw var9_11;
        }
        {
            block5: {
                reference.close();
                return var10_9;
lbl-1000:
                // 1 sources

                {
                    if (!type.equals("user") || !name.equals(_username)) break;
                    var10_10 = (String)reference.get((Object)key);
                }
                reference.close();
                return var10_10;
            }
            if (e.hasMoreElements()) continue;
        }
        reference.close();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean checkGroup(String _groupname, String _username) throws FileNotFoundException, IOException {
        ObjectStoreReference reference = ObjectStore.open((String)this.groups_object_store, (boolean)false);
        try {
            Object obj = reference.get((Object)_groupname);
            if (obj == null) {
                return false;
            }
            String usernames = (String)obj;
            int count = DString.dcount(usernames, ",");
            int i = 0;
            while (i < count) {
                String username = DString.extract(usernames, ",", i).trim();
                if (username.equals(_username)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        finally {
            reference.close();
        }
    }

    @Override
    public final boolean authenticateComputer(String _acls, String _hostname, String _ip_address, String _method) throws Exception {
        int count = DString.dcount(_acls, ",");
        int i = 0;
        while (i < count) {
            String acl = DString.extract(_acls, ",", i).trim();
            String rights = this.checkACL(acl, _hostname, _ip_address);
            if (rights != null) {
                return this.canAccess(rights, _method);
            }
            ++i;
        }
        return false;
    }

    private final String checkACL(String _acl, String _hostname, String _ip_address) throws Exception {
        int offset = _acl.indexOf(46);
        String type = _acl.substring(0, offset);
        String value = _acl.substring(offset + 1);
        if (type.equalsIgnoreCase("hostname")) {
            if (!value.equalsIgnoreCase(_hostname)) {
                return null;
            }
        } else if (type.equalsIgnoreCase("ip_address")) {
            if (!value.equalsIgnoreCase(_ip_address)) {
                return null;
            }
        } else if (type.equalsIgnoreCase("ip_range")) {
            if (!PosRealm.checkRange(value, _ip_address)) {
                return null;
            }
        } else {
            return null;
        }
        ObjectStoreReference reference = ObjectStore.open((String)this.acls_object_store, (boolean)false);
        try {
            ObjectStoreEnumeration e = reference.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.equals(_acl)) continue;
                String string = (String)reference.get((Object)key);
                return string;
            }
            return null;
        }
        finally {
            reference.close();
        }
    }

    @Override
    public final Principal getPrincipal(String username) {
        return new PrincipalImpl(username);
    }
}

