/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.iws;

public abstract class Logger
implements Runnable {
    private Log log = new Log();
    private Hashtable parameters;
    protected int interval;

    public void init(Hashtable _parameters) throws Exception {
        this.parameters = _parameters;
        Object obj = _parameters.get("interval");
        if (obj == null) {
            this.interval = 0;
        } else {
            String value = ((String[])obj)[0].trim();
            if (value.length() == 0) {
                this.interval = 0;
            } else {
                try {
                    this.interval = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    throw new Exception(iws.local_strings.getLocalString("err.config_must_be_numeric", "logger.ini", "interval", value));
                }
                if (this.interval < 50 && this.interval != 0) {
                    this.interval = 50;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        if (this.interval != 0) ** GOTO lbl13
        return;
        {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
            if (iws.shutdown) {
                return;
            }
            do {
                if (this.log.size() == 0) continue block2;
                this.outputAll();
lbl13:
                // 2 sources

            } while (!iws.shutdown);
        }
    }

    private final synchronized void outputAll() {
        try {
            Object obj;
            while ((obj = this.log.next()) != null) {
                this._output(obj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    private final synchronized void _output(Object obj) {
        try {
            if (obj instanceof AccessLogEntry) {
                this.output((AccessLogEntry)obj);
            } else if (obj instanceof EventLogEntry) {
                this.output((EventLogEntry)obj);
            } else {
                this.output((ErrorLogEntry)obj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public abstract void output(AccessLogEntry var1) throws Exception;

    public abstract void output(EventLogEntry var1) throws Exception;

    public abstract void output(ErrorLogEntry var1) throws Exception;

    public void destroy() {
        this.outputAll();
    }

    public void log(AccessLogEntry entry) {
        if (!iws.logAccess) {
            return;
        }
        if (this.interval == 0) {
            this._output(entry);
        } else {
            this.log.add(entry);
        }
    }

    public void log(String msg) {
        if (!iws.logEvents) {
            return;
        }
        EventLogEntry entry = new EventLogEntry();
        entry.timestamp = System.currentTimeMillis();
        entry.message = msg;
        if (this.interval == 0) {
            this._output(entry);
        } else {
            this.log.add(entry);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void log(Throwable ex, String msg) {
        if (iws.logErrors) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            ex = ((InvocationTargetException)ex).getTargetException();
lbl4:
            // 2 sources

            ** while (ex instanceof InvocationTargetException)
        }
lbl5:
        // 1 sources

        entry = new ErrorLogEntry();
        entry.timestamp = System.currentTimeMillis();
        entry.error = ex;
        entry.message = msg;
        if (this.interval == 0) {
            this._output(entry);
        } else {
            this.log.add(entry);
        }
    }

    public void log(Throwable ex) {
        this.log(ex, "");
    }

    final class Log {
        private Vector items = new Vector();

        Log() {
        }

        final synchronized void add(Object obj) {
            this.items.addElement(obj);
        }

        final synchronized Object next() {
            if (this.items.size() > 0) {
                Object obj = this.items.elementAt(0);
                this.items.removeElementAt(0);
                return obj;
            }
            return null;
        }

        final synchronized int size() {
            return this.items.size();
        }
    }
}

