/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import stec.iws.LockTable;
import stec.iws.MemorySessionStore;
import stec.iws.ServletContextImpl;
import stec.iws.ServletContextManager;
import stec.iws.Session;
import stec.iws.Utils;
import stec.iws.iws;

public final class FileSessionStore
extends MemorySessionStore {
    private static final int FILE_EXT_LENGTH = ".ser".length();
    private String subdir;
    private boolean persistent = true;
    private long save_interval;
    private LockTable locks = new LockTable();
    private boolean checking = false;
    private boolean distributed;
    private boolean master;

    @Override
    public final void init(Hashtable _parameters) throws Exception {
        super.init(_parameters);
        Object obj = _parameters.get("basedir");
        this.subdir = obj == null ? "./session_store" : ((String[])obj)[0];
        obj = _parameters.get("master");
        String value = obj == null ? "n" : ((String[])obj)[0];
        this.master = value.equalsIgnoreCase("y");
        obj = _parameters.get("distributed");
        value = obj == null ? "n" : ((String[])obj)[0];
        this.distributed = value.equalsIgnoreCase("y");
        if (this.distributed) {
            this.persistent = true;
            this.save_interval = 0L;
        } else {
            obj = _parameters.get("persistent");
            value = obj == null ? "n" : ((String[])obj)[0];
            this.persistent = value.equalsIgnoreCase("y");
            obj = _parameters.get("save_interval");
            if (obj == null) {
                this.save_interval = 300000L;
            } else {
                try {
                    this.save_interval = Integer.parseInt(((String[])obj)[0]);
                }
                catch (NumberFormatException ex) {
                    this.save_interval = -1L;
                }
                this.save_interval = this.save_interval < 0L ? 300000L : (this.save_interval *= 60000L);
            }
        }
    }

    @Override
    public final void checkSessionStore() throws Exception {
        this.checking = true;
        try {
            super.checkSessionStore();
            if (this.master) {
                this.masterCheckFileSessionStore();
            } else if (!this.distributed) {
                this.checkFileSessionStore();
            }
        }
        finally {
            this.checking = false;
        }
    }

    private final void masterCheckFileSessionStore() throws Exception {
        if (Utils.isAbsolute(this.subdir)) {
            File basedir = new File(this.subdir);
            String[] contexts = basedir.list();
            int length = contexts.length;
            int i = 0;
            while (i < length) {
                File file = new File(basedir, contexts[i]);
                this.checkFileSessionStore(file);
                ++i;
            }
        } else {
            File basedir = new File(iws.contextdir);
            String[] contexts = basedir.list();
            String dir = Utils.normalizeURI(this.subdir);
            int length = contexts.length;
            int i = 0;
            while (i < length) {
                File file = new File(basedir, Utils.concatURIs(contexts[i], dir));
                this.checkFileSessionStore(file);
                ++i;
            }
        }
    }

    private final void checkFileSessionStore() throws Exception {
        Enumeration e = ServletContextManager.servlet_contexts.elements();
        while (e.hasMoreElements()) {
            ServletContextImpl context = (ServletContextImpl)e.nextElement();
            this.checkFileSessionStore(this.getFileStore(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkFileSessionStore(File basedir) throws Exception {
        if (basedir.exists() && basedir.isDirectory()) {
            String[] files = basedir.list();
            int length = files.length;
            int i = 0;
            while (i < length) {
                Object lock;
                String filename = files[i];
                String lockid = filename.substring(0, filename.length() - FILE_EXT_LENGTH);
                Object object = lock = this.locks.lock(lockid);
                synchronized (object) {
                    block13: {
                        try {
                            File file = new File(basedir, filename);
                            if (!file.exists()) break block13;
                            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                            boolean remove = false;
                            try {
                                is.readObject();
                                is.readLong();
                                long lastAccessedTime = is.readLong();
                                long sessionTimeout = is.readLong();
                                if (sessionTimeout != -1L && System.currentTimeMillis() > lastAccessedTime + sessionTimeout) {
                                    remove = true;
                                }
                            }
                            finally {
                                is.close();
                            }
                            if (remove) {
                                file.delete();
                            }
                        }
                        finally {
                            this.locks.unlock(lock);
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkSession(Session _session) throws Exception {
        Object lock;
        Object object = lock = this.locks.lock(_session.id);
        synchronized (object) {
            try {
                super.checkSession(_session);
                if (_session.isValid && this.save_interval > 0L && System.currentTimeMillis() > _session.lastUpdate + this.save_interval && _session.lastUpdate != -1L) {
                    _session.lastUpdate = -1L;
                    File basedir = this.getFileStore(_session.context);
                    File file = new File(basedir, String.valueOf(_session.id) + ".ser");
                    file.delete();
                    this._saveSession(_session, file);
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Session getSession(ServletContextImpl _context, String _session_id) throws Exception {
        Object lock;
        Session session = null;
        Object object = lock = this.locks.lock(_session_id);
        synchronized (object) {
            try {
                session = super.getSession(_context, _session_id);
                if (session == null) {
                    File basedir = this.getFileStore(_context);
                    File file = new File(basedir, String.valueOf(_session_id) + ".ser");
                    session = this._getSession(_context, file);
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
        return session;
    }

    private final Session _getSession(ServletContextImpl _context, File file) throws Exception {
        Session session = null;
        if (file.exists() && !file.isDirectory()) {
            boolean remove = false;
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            try {
                session = new Session();
                session.context = _context;
                session.lastUpdate = -1L;
                session.isValid = true;
                session.id = (String)is.readObject();
                session.creationTime = is.readLong();
                session.lastAccessedTime = is.readLong();
                session.sessionTimeout = is.readLong();
                if (session._isValid()) {
                    session.remote_address = (InetAddress)is.readObject();
                    session.isNew = is.readBoolean();
                    int count = is.readInt();
                    int i = 0;
                    while (i < count) {
                        String key = (String)is.readObject();
                        Object value = is.readObject();
                        session._putValue(key, value);
                        ++i;
                    }
                    _context.sessions.put(session.id, session);
                } else {
                    session = null;
                    remove = true;
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (remove) {
                file.delete();
            }
        }
        return session;
    }

    @Override
    public final void load(ServletContextImpl _context) throws Exception {
        File basedir = this.getFileStore(_context);
        basedir.mkdirs();
        if (!this.persistent) {
            this.removeAllSessions(_context, basedir);
        }
    }

    @Override
    public final void unload(ServletContextImpl _context) throws Exception {
        try {
            File basedir = this.getFileStore(_context);
            if (this.persistent) {
                this.saveAllSessions(_context, basedir);
            } else {
                this.removeAllSessions(_context, basedir);
            }
        }
        finally {
            super.unload(_context);
        }
    }

    @Override
    public final void saveSession(Session _session, boolean _immediately) throws Exception {
        if (this.save_interval == 0L || _immediately) {
            File basedir = this.getFileStore(_session.context);
            this.saveSession(_session, basedir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveSession(Session _session, File _basedir) throws Exception {
        Object lock;
        Object object = lock = this.locks.lock(_session.id);
        synchronized (object) {
            try {
                if (_session.isValid() && _session.lastUpdate != -1L) {
                    _session.lastUpdate = -1L;
                    File file = new File(_basedir, String.valueOf(_session.id) + ".ser");
                    file.delete();
                    this._saveSession(_session, file);
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _saveSession(Session session, File file) throws Exception {
        Session session2 = session;
        synchronized (session2) {
            if (!session.canSerialize()) {
                return;
            }
            session.context.sessions.remove(session.id);
            ObjectOutputStream os = null;
            try {
                os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                os.writeObject(session.id);
                os.writeLong(session.creationTime);
                os.writeLong(session.lastAccessedTime);
                os.writeLong(session.sessionTimeout);
                os.writeObject(session.remote_address);
                os.writeBoolean(session.isNew);
                os.writeInt(session.sessionData.size());
                Enumeration e = session.sessionData.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object value = session.sessionData.get(key);
                    os.writeObject(key);
                    os.writeObject(value);
                }
            }
            finally {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    session._clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeSession(Session _session) throws Exception {
        Object lock;
        Object object = lock = this.locks.lock(_session.id);
        synchronized (object) {
            try {
                super.removeSession(_session);
                File basedir = this.getFileStore(_session.context);
                File file = new File(basedir, String.valueOf(_session.id) + ".ser");
                file.delete();
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeResidentSession(Session _session) throws Exception {
        Object lock;
        Object object = lock = this.locks.lock(_session.id);
        synchronized (object) {
            try {
                File basedir = this.getFileStore(_session.context);
                File file = new File(basedir, String.valueOf(_session.id) + ".ser");
                file.delete();
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    private final void saveAllSessions(ServletContextImpl _context, File basedir) throws Exception {
        Enumeration e = _context.sessions.elements();
        while (e.hasMoreElements()) {
            Session session = (Session)e.nextElement();
            this.saveSession(session, basedir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeAllSessions(ServletContextImpl _context, File basedir) throws Exception {
        if (!basedir.exists() || !basedir.isDirectory()) {
            return;
        }
        String[] files = basedir.list();
        int length = files.length;
        int i = 0;
        while (i < length) {
            Object lock;
            String filename = files[i];
            String lockid = filename.substring(0, filename.length() - FILE_EXT_LENGTH);
            Object object = lock = this.locks.lock(lockid);
            synchronized (object) {
                try {
                    File file = new File(basedir, filename);
                    file.delete();
                }
                finally {
                    this.locks.unlock(lock);
                }
            }
            ++i;
        }
    }

    private final File getFileStore(ServletContextImpl _context) {
        String dir = Utils.isAbsolute(this.subdir) ? Utils.concatPaths(this.subdir, _context.name) : Utils.concatPaths(Utils.concatPaths(iws.contextdir, _context.name), Utils.normalizeURI(this.subdir));
        return new File(dir);
    }

    @Override
    public final boolean isDistributed() {
        return this.distributed;
    }
}

