/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.OutputStreamLogger;
import stec.iws.Utils;
import stec.iws.iws;

public final class FileLogger
extends OutputStreamLogger {
    private static final String DEFAULT_LOGGER_DIR = "./logs";
    private int rolloverInterval;
    private String basedir;
    private Calendar accessLogCalendar;
    private Calendar errorLogCalendar;
    private Calendar eventLogCalendar;

    @Override
    public final void init(Hashtable _parameters) throws Exception {
        try {
            super.init(_parameters);
            Object obj = _parameters.get("log_rollover_interval");
            if (obj == null) {
                this.rolloverInterval = 2;
            } else {
                String value = ((String[])obj)[0];
                if (value.equalsIgnoreCase("daily") || value.equalsIgnoreCase("d")) {
                    this.rolloverInterval = 1;
                } else if (value.equalsIgnoreCase("weekly") || value.equalsIgnoreCase("w")) {
                    this.rolloverInterval = 2;
                } else if (value.equalsIgnoreCase("monthly") || value.equalsIgnoreCase("m")) {
                    this.rolloverInterval = 3;
                } else if (value.equalsIgnoreCase("none") || value.equalsIgnoreCase("n")) {
                    this.rolloverInterval = 0;
                } else {
                    throw new Exception(iws.local_strings.getLocalString("err.invalid", "log_rollover_interval", value));
                }
            }
            obj = _parameters.get("basedir");
            this.basedir = obj == null ? DEFAULT_LOGGER_DIR : ((String[])obj)[0];
            this.basedir = iws.getWorkDirectory(this.basedir);
            Calendar cal = this.getCalendar();
            this.openAccessLog(cal);
            this.openErrorsLog(cal);
            this.openEventsLog(cal);
        }
        catch (Exception ex) {
            this._destroy();
            throw ex;
        }
    }

    private final String getBaseFileName(Calendar cal) {
        String value;
        if (this.rolloverInterval == 0) {
            value = "";
        } else {
            SimpleDateFormat dtFmt = new SimpleDateFormat("yyyyMMdd", Locale.US);
            value = String.valueOf(dtFmt.format(cal.getTime())) + "_";
        }
        return value;
    }

    private final void openAccessLog(Calendar cal) throws Exception {
        if (iws.logAccess) {
            this.accessLogCalendar = cal;
            String baseFilename = this.getBaseFileName(this.accessLogCalendar);
            if (this.accesslog != null) {
                try {
                    this.accesslog.close();
                }
                finally {
                    this.accesslog = null;
                }
            }
            this.accesslog = this.setFilePermissions(Utils.getCanonicalPath(Utils.concatPaths(this.basedir, String.valueOf(baseFilename) + "access.log")));
            if (this.accessLogHeaderTemplate != null) {
                this.accesslog.println(this.convertHeaderToString());
                this.accesslog.flush();
            }
        }
    }

    private final void openErrorsLog(Calendar cal) throws Exception {
        if (iws.logErrors) {
            this.errorLogCalendar = cal;
            String baseFilename = this.getBaseFileName(this.errorLogCalendar);
            if (this.errorslog != null) {
                try {
                    this.errorslog.close();
                }
                finally {
                    this.errorslog = null;
                }
            }
            this.errorslog = this.setFilePermissions(Utils.getCanonicalPath(Utils.concatPaths(this.basedir, String.valueOf(baseFilename) + "errors.log")));
        }
    }

    private final void openEventsLog(Calendar cal) throws Exception {
        if (iws.logEvents) {
            this.eventLogCalendar = cal;
            String baseFilename = this.getBaseFileName(this.eventLogCalendar);
            if (this.eventslog != null) {
                try {
                    this.eventslog.close();
                }
                finally {
                    this.eventslog = null;
                }
            }
            this.eventslog = this.setFilePermissions(Utils.getCanonicalPath(Utils.concatPaths(this.basedir, String.valueOf(baseFilename) + "events.log")));
        }
    }

    private PrintStream setFilePermissions(String fileName) throws Exception {
        PrintStream log_temp = null;
        File file = new File(fileName);
        file.createNewFile();
        file.setReadable(true, false);
        file.setWritable(false, false);
        file.setExecutable(false, false);
        file.setWritable(true);
        log_temp = new PrintStream(new BufferedOutputStream(new FileOutputStream(file, true)));
        return log_temp;
    }

    private final Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        if (this.rolloverInterval == 1) {
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        } else if (this.rolloverInterval == 3) {
            cal.set(cal.get(1), cal.get(2), 1, 0, 0, 0);
        } else {
            cal.set(cal.get(1), cal.get(2), cal.get(5) - cal.get(7) + 1, 0, 0, 0);
        }
        return cal;
    }

    private final boolean rollover(Calendar ocal, Calendar ncal) {
        if (ncal.get(1) != ocal.get(1)) {
            return true;
        }
        if (ncal.get(2) != ocal.get(2)) {
            return true;
        }
        return ncal.get(5) != ocal.get(5);
    }

    @Override
    public final void output(AccessLogEntry entry) throws Exception {
        Calendar cal = this.getCalendar();
        if (this.rollover(this.accessLogCalendar, cal)) {
            this.openAccessLog(cal);
        }
        this.accesslog.println(this.convertToString(entry));
        this.accesslog.flush();
    }

    @Override
    public final void output(EventLogEntry entry) throws Exception {
        Calendar cal = this.getCalendar();
        if (this.rollover(this.eventLogCalendar, cal)) {
            this.openEventsLog(cal);
        }
        this.eventslog.print("[");
        this.eventslog.print(new Date(entry.timestamp).toString());
        this.eventslog.print("] ");
        this.eventslog.println(entry.message);
        this.eventslog.flush();
    }

    @Override
    public final void output(ErrorLogEntry entry) throws Exception {
        System.err.println(entry.message);
        Utils.printStackTrace(System.err, entry.error);
        Calendar cal = this.getCalendar();
        if (this.rollover(this.errorLogCalendar, cal)) {
            this.openErrorsLog(cal);
        }
        this.errorslog.print("[");
        this.errorslog.print(new Date(entry.timestamp).toString());
        this.errorslog.print("] ");
        this.errorslog.println(entry.message);
        CharArrayWriter buf = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buf);
        Utils.printStackTrace(writer, entry.error);
        this.errorslog.println(buf.toString());
        this.errorslog.flush();
    }

    @Override
    public final synchronized void destroy() {
        try {
            super.destroy();
        }
        finally {
            this._destroy();
        }
    }

    public final void _destroy() {
        if (this.accesslog != null) {
            try {
                this.accesslog.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.accesslog = null;
        }
        if (this.errorslog != null) {
            try {
                this.errorslog.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.errorslog = null;
        }
        if (this.eventslog != null) {
            try {
                this.eventslog.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.eventslog = null;
        }
    }
}

