/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Hashtable;
import stec.iws.FileIOHandler;
import stec.iws.IOHandler;
import stec.util.LinkedList;

public final class FileCache {
    private int maxSize;
    private int currentSize = 0;
    private Hashtable ht = new Hashtable();
    private LinkedList ll = new LinkedList();

    public FileCache(int size) {
        this.maxSize = size;
    }

    public final synchronized int size() {
        return this.currentSize;
    }

    public final synchronized int capacity() {
        return this.maxSize;
    }

    public final synchronized int available() {
        return this.maxSize - this.currentSize;
    }

    public final synchronized void resize(int size) {
        if (size < this.maxSize) {
            this.makeSpace(this.maxSize - size);
        }
        this.maxSize = size;
    }

    public final synchronized boolean canCache(IOHandler handler) {
        return handler.length() <= (long)this.maxSize;
    }

    public final synchronized void remove(IOHandler handler) throws IOException {
        String fname = handler.getCanonicalPath();
        Object obj = this.ht.get(fname);
        if (obj != null) {
            this.ll.remove(obj);
            this.ht.remove(fname);
        }
    }

    public final synchronized byte[] get(IOHandler handler) throws IOException {
        String fname = handler.getCanonicalPath();
        Object obj = this.ht.get(fname);
        int flength = (int)handler.length();
        if (obj == null) {
            if (flength > this.maxSize) {
                return null;
            }
            return this.addItem(fname, handler);
        }
        Item item = (Item)obj;
        if (handler.lastModified() != item.lastModified || flength != item.bytes.length) {
            this.currentSize -= item.bytes.length;
            this.ll.remove(item);
            this.ht.remove(fname);
            if (flength > this.maxSize) {
                return null;
            }
            return this.addItem(fname, handler);
        }
        this.ll.moveLast(item);
        item.lastAccessed = System.currentTimeMillis();
        return item.bytes;
    }

    private final byte[] getFile(IOHandler handler) throws IOException {
        BufferedInputStream is = new BufferedInputStream(handler.getInputStream());
        try {
            int flength = (int)handler.length();
            byte[] buffer = new byte[flength];
            if (flength > 0) {
                if (handler instanceof FileIOHandler) {
                    int bytes_read = is.read(buffer);
                    if (bytes_read > 0) {
                        flength -= bytes_read;
                    }
                } else {
                    int bytes_read;
                    int total_bytes_read = 0;
                    while ((bytes_read = is.read(buffer, total_bytes_read, flength)) != -1) {
                        total_bytes_read += bytes_read;
                        if ((flength -= bytes_read) > 0) continue;
                    }
                }
                if (flength != 0) {
                    return null;
                }
            }
            byte[] byArray = buffer;
            return byArray;
        }
        finally {
            is.close();
        }
    }

    private final byte[] addItem(String fname, IOHandler handler) throws IOException {
        byte[] bytes = this.getFile(handler);
        int flength = (int)handler.length();
        Item item = new Item();
        item.bytes = bytes;
        item.lastModified = handler.lastModified();
        item.fname = fname;
        item.lastAccessed = System.currentTimeMillis();
        this.makeSpace(flength);
        this.currentSize += flength;
        this.ll.addLast(item);
        this.ht.put(fname, item);
        return bytes;
    }

    private final void makeSpace(int bytesNeeded) {
        int freeBytes = this.maxSize - this.currentSize;
        if (bytesNeeded > freeBytes) {
            int size = this.ll.size();
            int i = 0;
            while (i < size) {
                if (this.maxSize - this.currentSize >= bytesNeeded) {
                    return;
                }
                Item item = (Item)this.ll.remove(0);
                this.currentSize -= item.bytes.length;
                this.ht.remove(item.fname);
                ++i;
            }
        }
    }

    final class Item {
        String fname;
        long lastAccessed;
        byte[] bytes;
        long lastModified;

        Item() {
        }
    }
}

