/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import stec.iws.PrincipalImpl;
import stec.iws.Realm;
import stec.iws.iws;
import stec.lang.DString;

public final class DatabaseRealm
extends Realm {
    private Connection connection = null;

    @Override
    public final void init(Hashtable init_parameters) throws Exception {
        try {
            super.init(init_parameters);
            Object obj = init_parameters.get("driver");
            if (obj == null) {
                throw new Exception(iws.local_strings.getLocalString("err.field_was_not_found", "driver"));
            }
            String driver = ((String[])obj)[0];
            obj = init_parameters.get("url");
            if (obj == null) {
                throw new Exception(iws.local_strings.getLocalString("err.field_was_not_found", "url"));
            }
            String url = ((String[])obj)[0];
            obj = init_parameters.get("user");
            String username = obj == null ? "" : ((String[])obj)[0];
            obj = init_parameters.get("password");
            String password = obj == null ? "" : ((String[])obj)[0];
            Class.forName(driver);
            this.connection = DriverManager.getConnection(url, username, password);
            this.connection.setAutoCommit(true);
        }
        catch (Exception ex) {
            this.destroy();
            throw ex;
        }
    }

    @Override
    public final synchronized void destroy() {
        block5: {
            try {
                if (this.connection == null) break block5;
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection = null;
            }
            finally {
                super.destroy();
            }
        }
    }

    @Override
    public final boolean authenticateUser(String _acls, String _username, String _password, String _method) throws Exception {
        if (!this.isValid(_username, _password)) {
            return false;
        }
        int count = DString.dcount(_acls, ',');
        int i = 0;
        while (i < count) {
            String acl = DString.extract(_acls, ',', i).trim();
            int id = this.checkACL(acl, _username);
            if (id != -1) {
                return this.canAccess(id, _method);
            }
            ++i;
        }
        return false;
    }

    private final boolean isValid(String _username, String _password) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connection.createStatement();
            StringBuffer sb = new StringBuffer("SELECT ID FROM Users WHERE Username = '");
            sb.append(_username);
            sb.append("' and Password = '");
            sb.append(_password);
            sb.append("'");
            rs = stmt.executeQuery(sb.toString());
            return rs.next();
            {
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int checkACL(String _acl, String _username) throws Exception {
        ResultSet rs;
        Statement stmt;
        block23: {
            String name;
            String type;
            int id;
            block24: {
                int n;
                block25: {
                    stmt = null;
                    rs = null;
                    try {
                        stmt = this.connection.createStatement();
                        StringBuffer sb = new StringBuffer("SELECT ID FROM Select_ACL WHERE ACL = '");
                        sb.append(_acl);
                        sb.append("'");
                        rs = stmt.executeQuery(sb.toString());
                        if (!rs.next()) break block23;
                        id = rs.getInt(1);
                        int offset = _acl.indexOf(46);
                        type = _acl.substring(0, offset);
                        name = _acl.substring(offset + 1);
                        if (!type.equals("group")) break block24;
                        if (!this.checkGroup(name, _username)) break block23;
                        n = id;
                        if (rs == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (stmt == null) throw throwable;
                        try {
                            stmt.close();
                            throw throwable;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (stmt == null) return n;
                try {
                    stmt.close();
                    return n;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return n;
            }
            if (type.equals("user") && name.equals(_username)) {
                int n = id;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (stmt == null) return n;
                try {
                    stmt.close();
                    return n;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return n;
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stmt == null) return -1;
        try {
            stmt.close();
            return -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public final boolean checkGroup(String _groupname, String _username) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connection.createStatement();
            StringBuffer sb = new StringBuffer("SELECT Username FROM Users WHERE ID = (SELECT User_ID FROM GroupMembers WHERE Group_ID = (SELECT ID FROM Groups WHERE Groupname = '");
            sb.append(_groupname);
            sb.append("') and User_ID = (SELECT ID FROM Users WHERE Username = '");
            sb.append(_username);
            sb.append("'))");
            rs = stmt.executeQuery(sb.toString());
            return rs.next();
            {
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private final boolean canAccess(int _id, String _method) throws Exception {
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery("SELECT Access_Right FROM Select_ACLRights WHERE ID = " + _id);
            while (rs.next()) {
                String right = rs.getString(1);
                if (!right.equals("*") && !right.equalsIgnoreCase(_method)) continue;
                return true;
            }
            return false;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public final boolean authenticateComputer(String _acls, String _hostname, String _ip_address, String _method) throws Exception {
        int count = DString.dcount(_acls, ',');
        int i = 0;
        while (i < count) {
            String acl = DString.extract(_acls, ',', i).trim();
            int id = this.checkACL(acl, _hostname, _ip_address);
            if (id != -1) {
                return this.canAccess(id, _method);
            }
            ++i;
        }
        return false;
    }

    private final int checkACL(String _acl, String _hostname, String _ip_address) throws Exception {
        int offset = _acl.indexOf(46);
        String type = _acl.substring(0, offset);
        String value = _acl.substring(offset + 1);
        if (type.equalsIgnoreCase("hostname")) {
            if (!value.equalsIgnoreCase(_hostname)) {
                return -1;
            }
        } else if (type.equalsIgnoreCase("ip_address")) {
            if (!value.equalsIgnoreCase(_ip_address)) {
                return -1;
            }
        } else if (type.equalsIgnoreCase("ip_range")) {
            if (!DatabaseRealm.checkRange(value, _ip_address)) {
                return -1;
            }
        } else {
            return -1;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connection.createStatement();
            StringBuffer sb = new StringBuffer("SELECT ID FROM Select_ACL WHERE ACL = '");
            sb.append(_acl);
            sb.append("'");
            rs = stmt.executeQuery(sb.toString());
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            return -1;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public final Principal getPrincipal(String username) {
        return new PrincipalImpl(username);
    }
}

