/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.OutputStreamLogger;
import stec.iws.Utils;

public final class ConsoleLogger
extends OutputStreamLogger {
    @Override
    public final void init(Hashtable _parameters) throws Exception {
        super.init(_parameters);
        this.accesslog = System.out;
        this.eventslog = System.out;
        this.errorslog = System.err;
        if (this.accessLogHeaderTemplate != null) {
            this.accesslog.println(this.convertHeaderToString());
            this.accesslog.flush();
        }
    }

    @Override
    public final void output(AccessLogEntry entry) throws Exception {
        this.accesslog.println(this.convertToString(entry));
        this.accesslog.flush();
    }

    @Override
    public final void output(EventLogEntry entry) throws Exception {
        this.eventslog.print("[");
        this.eventslog.print(new Date(entry.timestamp).toString());
        this.eventslog.print("] ");
        this.eventslog.println(entry.message);
        this.eventslog.flush();
    }

    @Override
    public final void output(ErrorLogEntry entry) throws Exception {
        this.errorslog.print("[");
        this.errorslog.print(new Date(entry.timestamp).toString());
        this.errorslog.print("] ");
        this.errorslog.println(entry.message);
        CharArrayWriter buf = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buf);
        Utils.printStackTrace(writer, entry.error);
        this.errorslog.println(buf.toString());
        this.errorslog.flush();
    }
}

