/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import stec.iws.ClusterMonitor;
import stec.iws.iws;
import stec.lang.DString;

public abstract class ClusterStub
extends HttpServlet {
    protected ClusterMonitor monitor = null;

    public void init(ServletConfig _config) throws ServletException {
        super.init(_config);
        boolean useBest = false;
        String sValue = _config.getInitParameter("method");
        if (sValue != null && sValue.equalsIgnoreCase("best")) {
            useBest = true;
        }
        int interval = 0;
        sValue = _config.getInitParameter("interval");
        if (sValue != null) {
            try {
                interval = Integer.parseInt(sValue);
            }
            catch (NumberFormatException ex) {
                interval = 50;
            }
            if (interval != 0 && interval < 50) {
                interval = 50;
            }
        }
        if ((sValue = _config.getInitParameter("hosts")) == null) {
            throw new ServletException(iws.local_strings.getLocalString("err.was_not_specified", "hosts"));
        }
        if ((sValue = sValue.trim()).length() == 0) {
            throw new ServletException(iws.local_strings.getLocalString("err.was_not_specified", "hosts"));
        }
        int count = DString.dcount(sValue, ',');
        String[] hosts = new String[count];
        int i = 0;
        while (i < count) {
            hosts[i] = DString.extract(sValue, ',', i).trim();
            ++i;
        }
        this.monitor = new ClusterMonitor(hosts, interval, useBest);
        if (interval > 0) {
            Thread thread = new Thread(this.monitor);
            thread.setDaemon(true);
            thread.start();
        }
    }
}

