/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import stec.iws.ClusterClient;
import stec.iws.ClusterStub;
import stec.iws.Response;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public final class ClusterRedirector
extends ClusterStub {
    public final void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException {
        String value;
        ClusterClient client;
        Cookie[] cookies = _request.getCookies();
        Cookie cookie = Utils.extractCookie(cookies, iws.sessionName);
        if (cookie == null) {
            client = this.monitor.next();
        } else if (cookie.getValue().length() == 0) {
            client = this.monitor.next();
        } else {
            cookie = Utils.extractCookie(cookies, "iwsServerID");
            if (cookie == null) {
                client = this.monitor.next();
            } else {
                value = cookie.getValue();
                if (value.length() == 0) {
                    client = this.monitor.next();
                } else {
                    client = this.monitor.find(value);
                    if (client == null) {
                        client = this.monitor.next();
                    }
                }
            }
        }
        if (client == null) {
            _response.sendError(502, iws.local_strings.getLocalString("err.unable_to_find_a_server_to_service_request"));
            return;
        }
        StringBuffer tsb = new StringBuffer();
        value = client.hostname;
        if (value.indexOf(58) == -1) {
            tsb.append(value);
        } else {
            tsb.append('[');
            tsb.append(value);
            tsb.append(']');
        }
        tsb.append(':');
        tsb.append(client.port);
        String host = tsb.toString();
        StringBuffer url = new StringBuffer();
        value = _request.getScheme();
        if (value == null) {
            value = "http";
        }
        url.append(value);
        url.append("://");
        url.append(host);
        value = _request.getPathInfo();
        if (value != null) {
            if (value.charAt(0) != '/') {
                url.append('/');
            }
            url.append(value);
        }
        if ((value = _request.getQueryString()) != null) {
            url.append('?');
            url.append(value);
        }
        ClusterRedirector.addCookie((Response)_response, "iwsClusterID", host);
        _response.sendRedirect(url.toString());
    }

    private static final void addCookie(Response response, String id, String value) {
        response.removeCookie(id);
        Cookie cookie = new Cookie(id, value);
        cookie.setMaxAge(iws.sessionMaxAge);
        if (iws.sessionDomain != null) {
            String domain = DString.replace(iws.sessionDomain, "%host%", response.handler.request.getServerName());
            domain = DString.replace(domain, "%local_address%", response.handler.request.getLocalAddr());
            cookie.setDomain(domain);
        }
        if (iws.sessionPath != null) {
            String path = DString.replace(iws.sessionPath, "%base_uri%", response.handler.request.getRequestURI());
            path = DString.replace(path, "%request_uri%", response.handler.request.getRequestURI());
            path = DString.replace(path, "%script_name%", response.handler.request.getServletPath());
            path = DString.replace(path, "%servlet_context_path%", response.handler.request.getContextPath());
            cookie.setPath(path);
        }
        cookie.setSecure(iws.sessionSecure);
        response.addCookie(cookie);
    }
}

