/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import stec.iws.ClusterClient;
import stec.iws.ClusterStub;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.Utils;
import stec.iws.iws;

public final class ClusterProxy
extends ClusterStub {
    private int retry;

    @Override
    public final void init(ServletConfig _config) throws ServletException {
        super.init(_config);
        this.retry = 3;
        String sValue = _config.getInitParameter("retry");
        if (sValue != null) {
            try {
                this.retry = Integer.parseInt(sValue);
                if (this.retry < 0) {
                    this.retry = 0;
                }
            }
            catch (NumberFormatException ex) {
                this.retry = 0;
            }
        }
    }

    public final void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException {
        String value;
        Cookie[] cookies = _request.getCookies();
        Cookie cookie = Utils.extractCookie(cookies, iws.sessionName);
        ClusterClient client = cookie == null ? this.monitor.next() : (cookie.getValue().length() == 0 ? this.monitor.next() : ((cookie = Utils.extractCookie(cookies, "iwsServerID")) == null ? this.monitor.next() : ((value = cookie.getValue()).length() == 0 ? this.monitor.next() : this.monitor.find(value))));
        Socket socket = null;
        FilterInputStream dataInputStream = null;
        FilterOutputStream dataOutputStream = null;
        try {
            int bytesRead;
            int i = 0;
            while (i < this.retry) {
                if (client != null || (client = this.monitor.next()) != null) {
                    try {
                        socket = new Socket(client.hostname, client.port);
                        break;
                    }
                    catch (Exception exception) {
                        this.monitor.clientError(client);
                        socket = null;
                        client = null;
                    }
                }
                ++i;
            }
            if (socket == null || client == null) {
                _response.sendError(502, iws.local_strings.getLocalString("err.unable_to_find_a_server_to_service_request"));
                return;
            }
            StringBuffer tsb = new StringBuffer();
            value = client.hostname;
            if (value.indexOf(58) == -1) {
                tsb.append(value);
            } else {
                tsb.append('[');
                tsb.append(value);
                tsb.append(']');
            }
            tsb.append(':');
            tsb.append(client.port);
            String host = tsb.toString();
            dataInputStream = new DataInputStream(socket.getInputStream());
            dataOutputStream = new DataOutputStream(socket.getOutputStream());
            String request_method = _request.getMethod();
            ((DataOutputStream)dataOutputStream).writeBytes(request_method);
            ((DataOutputStream)dataOutputStream).write(32);
            ((DataOutputStream)dataOutputStream).writeBytes(((Request)_request).raw_request_uri);
            ((DataOutputStream)dataOutputStream).write(32);
            ((DataOutputStream)dataOutputStream).writeBytes(_request.getProtocol());
            ((DataOutputStream)dataOutputStream).write(10);
            tsb.setLength(0);
            tsb.append("iwsClusterID");
            tsb.append('=');
            value = _request.getHeader("Cookie");
            if (value == null) {
                tsb.append(host);
            } else {
                String id = tsb.toString();
                tsb.append(host);
                if (value.startsWith(id)) {
                    int eOffset = value.indexOf("; ");
                    if (eOffset != -1) {
                        tsb.append(value.substring(eOffset));
                    }
                } else {
                    String scookie = tsb.toString();
                    tsb.setLength(0);
                    tsb.append("; ");
                    tsb.append(id);
                    id = tsb.toString();
                    tsb.setLength(0);
                    int sOffset = value.indexOf(id);
                    if (sOffset == -1) {
                        tsb.append(value);
                        tsb.append("; ");
                        tsb.append(scookie);
                    } else {
                        int eOffset = value.indexOf("; ", sOffset);
                        if (eOffset == -1) {
                            tsb.append(value);
                            tsb.append("; ");
                            tsb.append(scookie);
                        } else {
                            tsb.append(value.substring(0, sOffset + 2));
                            tsb.append(scookie);
                            tsb.append(value.substring(eOffset));
                        }
                    }
                }
            }
            value = tsb.toString();
            ((Request)_request).setHeader("Cookie", value);
            Enumeration e = _request.getHeaderNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                value = key.equals("Connection") ? "Close" : (key.equals("Host") ? host : _request.getHeader(key));
                ((DataOutputStream)dataOutputStream).writeBytes(key);
                ((DataOutputStream)dataOutputStream).writeBytes(": ");
                ((DataOutputStream)dataOutputStream).writeBytes(value);
                ((DataOutputStream)dataOutputStream).write(10);
            }
            ((DataOutputStream)dataOutputStream).write(10);
            ((DataOutputStream)dataOutputStream).flush();
            byte[] buffer = new byte[8192];
            if (request_method.equalsIgnoreCase("POST")) {
                int buffer_length;
                int maxSize;
                ServletInputStream is = _request.getInputStream();
                int remaining = _request.getContentLength();
                if (remaining == -1) {
                    remaining = 0;
                }
                if ((maxSize = remaining) > (buffer_length = buffer.length)) {
                    maxSize = buffer_length;
                }
                while (remaining > 0) {
                    bytesRead = is.read(buffer, 0, maxSize);
                    if (bytesRead == -1) break;
                    ((DataOutputStream)dataOutputStream).write(buffer, 0, bytesRead);
                    maxSize = remaining -= bytesRead;
                    if (maxSize <= buffer_length) continue;
                    maxSize = buffer_length;
                }
                ((DataOutputStream)dataOutputStream).flush();
            }
            ((Response)_response).headersSent = true;
            ((Response)_response).handler.keepAlive = false;
            ServletOutputStream os = _response.getOutputStream();
            while ((bytesRead = ((DataInputStream)dataInputStream).read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

