/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import stec.iws.ClusterClient;
import stec.iws.iws;

public final class ClusterMonitor
implements Runnable {
    private int interval;
    private ClusterClient[] clients;
    private int nextHost;
    private boolean useBest;
    private long lastRefresh;
    private static final int PORT = 8080;
    private static final String SPORT = "8080";
    private static final String FILE = "/status";

    protected ClusterMonitor(String[] _hosts, int _interval, boolean _useBest) {
        this.interval = _interval;
        this.useBest = _useBest;
        if (this.interval > 0) {
            this.nextHost = 0;
        }
        this.clients = new ClusterClient[_hosts.length];
        int length = _hosts.length;
        int i = 0;
        while (i < length) {
            int port;
            String sport;
            String hostname;
            this.clients[i] = new ClusterClient();
            String host = _hosts[i];
            int offset = host.indexOf(93);
            offset = offset == -1 ? 0 : ++offset;
            offset = host.indexOf(58, offset);
            if (offset == -1) {
                hostname = host;
                sport = null;
            } else {
                hostname = host.substring(0, offset);
                sport = host.substring(offset + 1);
            }
            if (hostname.startsWith("[")) {
                hostname = hostname.substring(1);
            }
            if (hostname.endsWith("]")) {
                hostname = hostname.substring(0, hostname.length() - 1);
            }
            if (sport == null) {
                sport = SPORT;
            } else if (sport.length() == 0) {
                sport = SPORT;
            }
            try {
                port = Integer.parseInt(sport);
            }
            catch (NumberFormatException ex) {
                port = 8080;
            }
            this.clients[i].hostname = hostname;
            this.clients[i].port = port;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        if (this.interval >= 1) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            if (this.useBest) {
                this.refresh();
            } else {
                this.clear();
            }
            try {
                Thread.sleep(this.interval);
                continue;
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
lbl12:
            // 3 sources

            ** while (!iws.shutdown)
        }
lbl13:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refresh() {
        if (System.currentTimeMillis() - this.lastRefresh < 50L) {
            return;
        }
        int length = this.clients.length;
        int i = 0;
        while (i < length) {
            ClusterClient client;
            if (iws.shutdown) {
                return;
            }
            ClusterClient clusterClient = client = this.clients[i];
            synchronized (clusterClient) {
                client.responseTime = ClusterMonitor.getResponseTime(client);
            }
            ++i;
        }
        this.lastRefresh = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clear() {
        if (System.currentTimeMillis() - this.lastRefresh < 50L) {
            return;
        }
        int length = this.clients.length;
        int i = 0;
        while (i < length) {
            ClusterClient client;
            if (iws.shutdown) {
                return;
            }
            ClusterClient clusterClient = client = this.clients[i];
            synchronized (clusterClient) {
                client.responseTime = 0L;
            }
            ++i;
        }
        this.lastRefresh = System.currentTimeMillis();
    }

    private static final long getResponseTime(ClusterClient client) {
        long responseTime = -1L;
        Socket socket = null;
        try {
            try {
                socket = new Socket(client.hostname, client.port);
                socket.setSoTimeout(60000);
                DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.writeBytes("GET ");
                dataOutputStream.writeBytes(FILE);
                dataOutputStream.writeBytes(" HTTP/1.0\n");
                dataOutputStream.writeBytes("Connection: Close\n");
                dataOutputStream.write(10);
                dataOutputStream.flush();
                String sValue = dataInputStream.readLine();
                if (sValue != null) {
                    responseTime = Long.parseLong(sValue);
                }
            }
            catch (Exception exception) {}
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return responseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClusterClient next() {
        ClusterClient client = null;
        if (this.useBest) {
            if (this.interval < 1) {
                this.refresh();
            }
            int length = this.clients.length;
            int i = 0;
            while (i < length) {
                ClusterClient tclient;
                ClusterClient clusterClient = tclient = this.clients[i];
                synchronized (clusterClient) {
                    if (tclient.responseTime != -1L) {
                        if (client == null) {
                            client = tclient;
                        } else if (client.responseTime > tclient.responseTime) {
                            client = tclient;
                        }
                    }
                }
                ++i;
            }
            return client;
        }
        if (this.interval < 1) {
            this.clear();
        }
        int length = this.clients.length;
        int i = 0;
        while (i < length) {
            ClusterClient tclient;
            ClusterClient clusterClient = tclient = this.clients[this.nextHost];
            synchronized (clusterClient) {
                if (tclient.responseTime != -1L) {
                    client = tclient;
                    ++this.nextHost;
                    if (this.nextHost == length) {
                        this.nextHost = 0;
                    }
                    return client;
                }
            }
            ++this.nextHost;
            if (this.nextHost == length) {
                this.nextHost = 0;
            }
            ++i;
        }
        return null;
    }

    protected final ClusterClient find(String _host) {
        StringBuffer tsb = new StringBuffer();
        int length = this.clients.length;
        int i = 0;
        while (i < length) {
            ClusterClient client = this.clients[i];
            String value = client.hostname;
            if (value.indexOf(58) == -1) {
                tsb.append(value);
            } else {
                tsb.append('[');
                tsb.append(value);
                tsb.append(']');
            }
            tsb.append(':');
            tsb.append(client.port);
            if (_host.equalsIgnoreCase(tsb.toString())) {
                return client;
            }
            tsb.setLength(0);
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clientError(ClusterClient client) {
        ClusterClient clusterClient = client;
        synchronized (clusterClient) {
            client.responseTime = -1L;
        }
    }
}

