/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import stec.iws.IOHandler;
import stec.iws.InputReader;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.ServletManager;
import stec.iws.Utils;
import stec.iws.iws;

public final class CgiServlet
extends HttpServlet {
    protected static final String[] HEADERS = new String[]{"AUTH_PASSWORD", "AUTH_TYPE", "AUTH_USER", "CERT_COOKIE", "CERT_FLAGS", "CERT_ISSUER", "CERT_KEYSIZE", "CERT_SECRETKEYSIZE", "CERT_SERIALNUMBER", "CERT_SERVER_ISSUER", "CERT_SERVER_SUBJECT", "CERT_SUBJECT", "CLIENT_CERT_ENCODED", "CONTENT_ENCODING", "CONTENT_LENGTH", "CONTENT_TYPE", "DATE_GMT", "DATE_LOCAL", "DOCUMENT_NAME", "DOCUMENT_ROOT", "DOCUMENT_URI", "GATEWAY_INTERFACE", "HTTPS", "HTTPS_KEYSIZE", "HTTPS_SECRETKEYSIZE", "HTTPS_SERVER_ISSUER", "HTTPS_SERVER_SUBJECT", "INSTANCE_ID", "INSTANCE_META_PATH", "LAST_MODIFIED", "LOCAL_ADDR", "LOCATION", "LOGON_USER", "PATH_INFO", "PATH_TRANSLATED", "QUERY_STRING", "QUERY_STRING_UNESCAPED", "REMOTE_ADDR", "REMOTE_HOST", "REMOTE_IDENT", "REMOTE_USER", "REQUEST_METHOD", "REQUEST_URI", "ROOT", "SCRIPT_NAME", "SERVER_NAME", "SERVER_PORT", "SERVER_PORT_SECURE", "SERVER_PROTOCOL", "SERVER_SOFTWARE", "SERVLET_CONTEXT_PATH", "URL"};
    static Hashtable headers;

    static {
        int count = HEADERS.length;
        headers = new Hashtable(count);
        int i = 0;
        while (i < count) {
            headers.put(HEADERS[i], HEADERS[i]);
            ++i;
        }
    }

    public final void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException {
        String obj;
        String path;
        String cmd;
        Request request = (Request)_request;
        Response response = (Response)_response;
        if (!iws.shell) {
            _response.sendError(403);
            return;
        }
        String script_name = Utils.concatURIs(request.handler.servlet_context.uri, _request.getServletPath());
        String filter_uri = ServletManager.findFilter(script_name);
        if (filter_uri == null) {
            String path_info = _request.getPathInfo();
            if (path_info == null) {
                _response.sendError(403);
                return;
            }
            if (path_info.length() < 2) {
                _response.sendError(403);
                return;
            }
        }
        Hashtable vars = CgiServlet.getEnvironmentalVariables(request);
        ServletConfig config = this.getServletConfig();
        String basedir = config.getInitParameter("bindir");
        if (basedir != null) {
            if (Utils.isAbsolute(basedir)) {
                basedir = Utils.normalizePath(basedir);
            } else {
                String server_basedir;
                Object obj2;
                if (File.separatorChar == '\\') {
                    basedir = Utils.parsePath(basedir);
                }
                if ((obj2 = iws.hosts.get(_request.getServerName().toLowerCase())) == null && (obj2 = iws.hosts.get("*")) == null) {
                    obj2 = "./wwwroot";
                }
                if (Utils.isAbsolute(server_basedir = (String)obj2)) {
                    basedir = Utils.normalizePath(Utils.concatPaths(server_basedir, Utils.normalizeURI(basedir)));
                } else {
                    try {
                        basedir = Utils.normalizePath(Utils.concatPaths(iws.getRealPath(server_basedir), Utils.normalizeURI(basedir)));
                    }
                    catch (Exception ex) {
                        throw new ServletException(ex.getMessage());
                    }
                }
            }
        }
        if (filter_uri == null) {
            String base_cmd = _request.getPathInfo();
            int offset = 1;
            boolean found = false;
            do {
                ++offset;
                cmd = (offset = base_cmd.indexOf(47, offset)) == -1 ? base_cmd : base_cmd.substring(0, offset);
                path = basedir == null ? cmd : Utils.normalizePath(Utils.concatPaths(basedir, cmd));
                File file = new File(path);
                if (!file.exists() || !file.isFile()) continue;
                request.script_name = Utils.concatURIs(request.script_name, cmd);
                request.path_info = cmd.length() == request.path_info.length() ? null : request.path_info.substring(offset);
                vars.put("DOCUMENT_NAME", file.getCanonicalPath());
                vars.put("LAST_MODIFIED", new Date(file.lastModified()));
                found = true;
                break;
            } while (offset != -1);
            if (!found) {
                _response.sendError(404);
                return;
            }
            cmd = basedir == null ? Utils.normalizePath(cmd) : Utils.normalizePath(Utils.concatPaths(basedir, cmd));
            vars.put("SCRIPT_NAME", Utils.normalizeURI(Utils.concatPaths(_request.getContextPath(), _request.getServletPath())));
            if (_request.getPathInfo() == null) {
                vars.remove("PATH_INFO");
            } else {
                vars.put("PATH_INFO", _request.getPathInfo());
            }
            if (_request.getPathTranslated() == null) {
                vars.remove("PATH_TRANSLATED");
            } else {
                vars.put("PATH_TRANSLATED", _request.getPathTranslated());
            }
        } else {
            File file;
            cmd = _request.getServletPath();
            if (basedir != null) {
                cmd = Utils.concatPaths(basedir, cmd);
            }
            if (!(file = new File(cmd)).exists() || !file.isFile()) {
                _response.sendError(404);
                return;
            }
            vars.put("DOCUMENT_NAME", file.getCanonicalPath());
            vars.put("LAST_MODIFIED", new Date(file.lastModified()));
        }
        path = _request.getServletPath();
        vars.put("DOCUMENT_URI", path);
        vars.put("URL", path);
        String charset = request.getCharset();
        if (charset == null) {
            charset = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
        }
        if ((obj = _request.getQueryString()) != null) {
            vars.put("QUERY_STRING_UNESCAPED", Utils.decodeURL(obj, charset));
        }
        CgiServlet.execute(config, request, response, vars, cmd, charset);
    }

    protected static final void execute(ServletConfig _config, Request _request, Response _response, Hashtable _vars, String _cmd, String charset) throws IOException, ServletException {
        InputStream is = null;
        OutputStream os = null;
        InputStream es = null;
        try {
            try {
                int bytesRead;
                String line;
                String value;
                String key;
                String args;
                int offset;
                _cmd = _cmd.trim();
                if (_cmd.length() == 0) {
                    throw new ServletException(iws.local_strings.getLocalString("err.command_was_not_specified"));
                }
                _cmd = _cmd.replace('/', File.separatorChar).replace('\\', File.separatorChar);
                StringBuffer sb = new StringBuffer();
                String exec = _config.getInitParameter("exec");
                if (exec != null && (exec = exec.trim()).length() > 0) {
                    sb.append(exec);
                    sb.append(' ');
                }
                sb.append(_cmd);
                String qs = _request.getQueryString();
                if (qs != null && (offset = qs.indexOf(61)) != -1 && (offset = (args = qs.substring(0, offset)).lastIndexOf(38)) != -1) {
                    sb.append(' ');
                    sb.append(Utils.decodeURL(qs.substring(0, offset), charset));
                }
                String[] envp = new String[_vars.size()];
                StringBuffer tsb = new StringBuffer();
                int i = 0;
                Enumeration e = _vars.keys();
                while (e.hasMoreElements()) {
                    key = new String(((String)e.nextElement()).getBytes(charset));
                    value = new String(_vars.get(key).toString().getBytes(charset));
                    tsb.append(key);
                    tsb.append('=');
                    tsb.append(value);
                    envp[i++] = tsb.toString();
                    tsb.setLength(0);
                }
                Process p = Runtime.getRuntime().exec(sb.toString(), envp);
                is = p.getInputStream();
                os = p.getOutputStream();
                es = p.getErrorStream();
                CgiServlet.processPostData(os, _request.getInputStream(), _request.getContentLength());
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                InputReader ir = new InputReader(is, buffer);
                InputReader er = new InputReader(es, buffer);
                ir.start();
                er.start();
                int rc = -1;
                try {
                    rc = p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ir.waitFor();
                er.waitFor();
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buffer.toByteArray()));
                while ((line = dis.readLine()) != null) {
                    if (line.length() == 0) break;
                    offset = line.indexOf(58);
                    if (offset == -1) continue;
                    key = line.substring(0, offset).trim();
                    value = line.substring(offset + 1).trim();
                    if (key.equalsIgnoreCase("status")) {
                        int status;
                        offset = value.indexOf(32);
                        if (offset == -1) {
                            try {
                                status = Integer.parseInt(value);
                            }
                            catch (NumberFormatException ex) {
                                status = 500;
                            }
                            _response.setStatus(status);
                            continue;
                        }
                        String tValue = value.substring(offset + 1);
                        value = value.substring(0, offset);
                        try {
                            status = Integer.parseInt(value);
                        }
                        catch (NumberFormatException ex) {
                            status = 500;
                        }
                        _response.setStatus(status, tValue);
                        continue;
                    }
                    _response.setHeader(key, value);
                }
                ServletOutputStream sos = _response.getOutputStream();
                byte[] buf = new byte[8192];
                while ((bytesRead = dis.read(buf)) != -1) {
                    sos.write(buf, 0, bytesRead);
                }
            }
            catch (Exception ex) {
                throw new ServletException(ex.getMessage());
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
            if (es != null) {
                try {
                    es.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final void processPostData(OutputStream _os, ServletInputStream _sis, int _length) throws IOException {
        int bytesRead;
        if (_length < 1) {
            return;
        }
        int bytesLeft = _length;
        byte[] buf = new byte[8192];
        while ((bytesRead = _sis.read(buf, 0, bytesLeft)) != -1) {
            _os.write(buf, 0, bytesRead);
            if ((bytesLeft -= bytesRead) <= 0) break;
        }
        _os.flush();
    }

    protected static final Hashtable getEnvironmentalVariables(Request request) throws IOException {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        int envs_length = iws.envs.length;
        int i = 0;
        while (i < envs_length) {
            String env = iws.envs[i];
            int offset = env.indexOf(61);
            if (offset > 0) {
                ht.put(env.substring(0, offset), env.substring(offset + 1));
            }
            ++i;
        }
        Enumeration e = request.headers.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = request.getHeader(key);
            if (!(headers.containsKey(key = key.replace('-', '_').toUpperCase()) || key.startsWith("HTTP_") || key.startsWith("HTTPS_"))) {
                key = "HTTP_" + key;
            }
            ht.put(key, value);
        }
        CgiServlet.addServerVariable(ht, "AUTH_TYPE", request.auth_type);
        CgiServlet.addServerVariable(ht, "AUTH_USER", request.auth_user);
        CgiServlet.addServerVariable(ht, "AUTH_PASSWORD", request.auth_password);
        CgiServlet.addServerVariable(ht, "HTTPS", request.isSecure() ? "on" : "off");
        CgiServlet.addServerVariable(ht, "LOCATION", request.location);
        CgiServlet.addServerVariable(ht, "INSTANCE_ID", request.session == null ? null : request.session.id);
        CgiServlet.addServerVariable(ht, "SERVER_SOFTWARE", request.server_software);
        CgiServlet.addServerVariable(ht, "REMOTE_HOST", request.remote_host);
        CgiServlet.addServerVariable(ht, "REMOTE_ADDR", request.remote_addr);
        CgiServlet.addServerVariable(ht, "SERVER_NAME", request.server_name);
        CgiServlet.addServerVariable(ht, "SERVER_PORT", String.valueOf(request.server_port));
        CgiServlet.addServerVariable(ht, "REQUEST_METHOD", request.request_method);
        CgiServlet.addServerVariable(ht, "REQUEST_URI", request.request_uri);
        CgiServlet.addServerVariable(ht, "QUERY_STRING", request.query_string);
        CgiServlet.addServerVariable(ht, "SCRIPT_NAME", Utils.normalizeURI(Utils.concatPaths(request.getContextPath(), request.getServletPath())));
        CgiServlet.addServerVariable(ht, "SERVLET_CONTEXT_PATH", request.getContextPath());
        CgiServlet.addServerVariable(ht, "SERVER_PROTOCOL", request.server_protocol);
        CgiServlet.addServerVariable(ht, "PATH_TRANSLATED", request.getPathTranslated());
        CgiServlet.addServerVariable(ht, "LOCAL_ADDR", request.local_addr);
        CgiServlet.addServerVariable(ht, "PATH_INFO", request.path_info);
        CgiServlet.addServerVariable(ht, "REMOTE_USER", request.getRemoteUser());
        Date dt = new Date();
        ht.put("DATE_LOCAL", dt);
        ht.put("DATE_GMT", dt.toGMTString());
        ht.put("GATEWAY_INTERFACE", "CGI/1.1");
        IOHandler handler = Utils.getRootHandler(request.getServerName());
        String path = handler.getCanonicalPath();
        ht.put("ROOT", path);
        ht.put("DOCUMENT_ROOT", path);
        ht.put("SERVER_PORT_SECURE", request.isSecure() ? "1" : "0");
        return ht;
    }

    private static final void addServerVariable(Hashtable ht, String key, String value) {
        if (value == null) {
            return;
        }
        ht.put(key, value);
    }
}

