/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import stec.iws.IOHandler;
import stec.iws.Utils;
import stec.iws.iws;

public final class ArchiveIOHandler
implements IOHandler {
    private ZipFile zip_file = null;
    private ZipEntry zip_entry = null;
    protected String archive;
    protected String path;
    protected boolean isAbsolute;

    public ArchiveIOHandler(String path) throws IOException {
        if (Utils.isAbsolute(path)) {
            String tpath = Utils.getCanonicalPath(path);
            if (tpath.startsWith(iws.basedir)) {
                tpath = path.substring(iws.basedir.length());
                this.init(iws.basedir, tpath);
            } else {
                this.init(iws.basedir, path);
            }
        } else {
            this.init(iws.basedir, path);
        }
    }

    public ArchiveIOHandler(String archive, String path) throws IOException {
        this.init(Utils.getCanonicalPath(archive), path);
    }

    public ArchiveIOHandler(IOHandler handler, String path) throws IOException {
        String tpath = Utils.concatPaths(((ArchiveIOHandler)handler).path, path);
        this.init(((ArchiveIOHandler)handler).archive, tpath);
    }

    private final void init(String _archive, String _path) throws IOException {
        ZipEntry tzip_entry;
        boolean repeat;
        this.archive = _archive;
        String tpath = _path.replace('\\', '/');
        this.isAbsolute = tpath.length() == 0 ? true : tpath.charAt(0) == '/';
        do {
            if (tpath.length() == 0) {
                repeat = false;
                continue;
            }
            if (tpath.charAt(0) == '/') {
                tpath = tpath.substring(1);
                repeat = true;
                continue;
            }
            if (tpath.startsWith("./")) {
                tpath = tpath.substring(2);
                repeat = true;
                continue;
            }
            if (tpath.startsWith("../")) {
                tpath = tpath.substring(3);
                repeat = true;
                continue;
            }
            repeat = false;
        } while (repeat);
        this.path = tpath;
        File file = new File(this.archive);
        this.zip_file = new ZipFile(file);
        this.zip_entry = this.zip_file.getEntry(tpath);
        if (this.zip_entry == null) {
            this.zip_entry = this.zip_file.getEntry(String.valueOf(tpath) + "/");
            if (this.zip_entry != null) {
                this.path = String.valueOf(this.path) + "/";
            }
        } else if (this.zip_entry.getSize() == 0L && !tpath.endsWith("/") && (tzip_entry = this.zip_file.getEntry(String.valueOf(tpath) + "/")) != null) {
            this.zip_entry = tzip_entry;
            this.path = String.valueOf(this.path) + "/";
        }
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        if (this.zip_entry == null) {
            throw new FileNotFoundException();
        }
        return this.zip_file.getInputStream(this.zip_entry);
    }

    @Override
    public final String getItem() throws IOException {
        if (this.zip_entry == null) {
            return null;
        }
        return Utils.getItem(this.getInputStream());
    }

    @Override
    public final long lastModified() {
        if (this.path.length() == 0) {
            File file = new File(this.archive);
            return file.lastModified();
        }
        if (this.zip_entry == null) {
            return -1L;
        }
        return this.zip_entry.getTime();
    }

    @Override
    public final long length() {
        if (this.path.length() == 0) {
            return 0L;
        }
        if (this.zip_entry == null) {
            return -1L;
        }
        return this.zip_entry.getSize();
    }

    @Override
    public final boolean exists() {
        if (this.path.length() == 0) {
            return true;
        }
        return this.zip_entry != null;
    }

    @Override
    public final String[] list() {
        Vector<String> vitems = new Vector<String>();
        String tpath = this.path.toLowerCase();
        int tpath_length = tpath.length();
        Enumeration<? extends ZipEntry> e = this.zip_file.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String item = entry.getName();
            String titem = item.toLowerCase();
            if (!titem.startsWith(tpath) || titem.length() <= tpath_length) continue;
            int offset = (item = item.substring(tpath_length)).indexOf(47);
            if (offset == -1) {
                vitems.addElement(item);
                continue;
            }
            if (offset != item.length() - 1) continue;
            vitems.addElement(item.substring(0, offset));
        }
        Object[] items = new String[vitems.size()];
        vitems.copyInto(items);
        return items;
    }

    @Override
    public final String getCanonicalPath() throws IOException {
        if (this.zip_entry == null) {
            return Utils.normalizePath(Utils.concatPaths(this.archive, this.path));
        }
        return Utils.normalizePath(Utils.concatPaths(this.archive, this.zip_entry.getName()));
    }

    @Override
    public final boolean isDirectory() {
        if (this.path.length() == 0) {
            return true;
        }
        if (this.zip_entry == null) {
            return false;
        }
        return this.zip_entry.isDirectory();
    }

    @Override
    public final boolean isFile() {
        if (this.zip_entry == null) {
            return false;
        }
        return !this.zip_entry.isDirectory();
    }

    public final synchronized void destroy() {
        if (this.zip_file != null) {
            try {
                this.zip_file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.zip_file = null;
        }
    }

    @Override
    public final boolean isAbsolute() {
        return Utils.isAbsolute(this.path);
    }
}

