/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.wwhelp4;

import com.webworks.wwhelp4.BaseTabbedPanel;
import com.webworks.wwhelp4.PropertyChangeSupport;
import com.webworks.wwhelp4.VetoableChangeSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Vector;

public class TabPanel
extends BaseTabbedPanel
implements Serializable,
PropertyChangeListener {
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    Vector vPanels = new Vector();
    String[] labels = null;
    transient boolean bOsHack;

    public TabPanel() {
        this(0, 0);
    }

    public TabPanel(boolean bl) {
        this(bl ? 0 : 1, bl ? 0 : 1);
    }

    public TabPanel(int n, int n2) {
        super(n, n2);
        String string = System.getProperty("os.name");
        this.bOsHack = string.equals("Windows 95");
        super.addCurrentTabListener(this);
    }

    public int getCurrentPanelNdx() {
        return this.curIndex;
    }

    public void setCurrentPanelNdx(int n) throws PropertyVetoException {
        if (n != this.curIndex) {
            Integer n2 = new Integer(this.curIndex);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("CurrentPanelNdx", n2, n3);
            this.showTabPanel(n);
            if (!Beans.isDesignTime()) {
                this.curIndex = n;
            }
            this.changes.firePropertyChange("CurrentPanelNdx", n2, n3);
        }
    }

    public void setPanelLabels(String[] stringArray) throws PropertyVetoException {
        String[] stringArray2 = this.labels;
        this.vetos.fireVetoableChange("PanelLabels", stringArray2, stringArray);
        this.labels = stringArray;
        this.updatePanelLabels();
        this.changes.firePropertyChange("PanelLabels", stringArray2, stringArray);
    }

    public String[] getPanelLabels() {
        return this.labels;
    }

    public void setPanelLabel(String string, int n) throws PropertyVetoException {
        if (n >= 0 && n < this.labels.length && this.labels[n] != string) {
            String string2 = this.labels[n];
            this.vetos.fireVetoableChange("PanelLabel", string2, string);
            this.labels[n] = string;
            this.updatePanelLabels();
            this.changes.firePropertyChange("PanelLabel", string2, string);
        }
    }

    public String getPanelLabel(int n) {
        if (n >= 0 && n < this.labels.length) {
            return this.labels[n];
        }
        return null;
    }

    public void setTabsOnBottom(boolean bl) throws PropertyVetoException {
        Boolean bl2;
        Boolean bl3 = new Boolean(this.getTabsOnBottom());
        if (!bl3.equals(bl2 = new Boolean(bl))) {
            this.vetos.fireVetoableChange("TabsOnBottom", bl3, bl2);
            this.setTabsInfo(bl ? 1 : 0, bl ? 1 : 0);
            this.layout();
            this.changes.firePropertyChange("TabsOnBottom", bl3, bl2);
        }
    }

    public boolean isTabsOnBottom() {
        return this.getTabsPosition() != 0;
    }

    public boolean getTabsOnBottom() {
        return this.isTabsOnBottom();
    }

    public synchronized void setTabPanel(String string, boolean bl, Component component, int n) throws PropertyVetoException {
        if (n < 0 || n >= this.vPanels.size()) {
            return;
        }
        if (n == this.getCurrentTab() && !bl) {
            return;
        }
        try {
            Component component2 = (Component)this.vPanels.elementAt(n);
            this.vetos.fireVetoableChange("TabPanel", component2, component);
            this.vPanels.setElementAt(component, n);
            this.setTab(string, bl, n);
            this.changes.firePropertyChange("TabPanel", component2, component);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public synchronized Component getTabPanel(int n) {
        if (n < 0 || n >= this.vPanels.size()) {
            return null;
        }
        Component component = null;
        try {
            component = (Component)this.vPanels.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return component;
    }

    public synchronized int getPanelTabIndex(Component component) {
        return this.vPanels.indexOf(component);
    }

    public synchronized void showTabPanel(int n) {
        block3: {
            if (!this.isEnabled(n)) break block3;
            try {
                Component component = (Component)this.vPanels.elementAt(n);
                this.setCurrentTab(n);
                this.showPanel(component);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public int addTabPanel(String string, boolean bl, Component component) {
        return this.addTabPanel(string, bl, component, -1);
    }

    public int addTabPanel(String string, boolean bl, Component component, int n) {
        if (n == -1) {
            this.vPanels.addElement(component);
        } else {
            this.vPanels.insertElementAt(component, n);
        }
        return this.addTab(string, bl, n);
    }

    public Component add(Component component) {
        return this.add(component, -1);
    }

    public synchronized Component add(Component component, int n) {
        boolean bl = this.setSuppressRepaints(true);
        try {
            int n2 = this.addTabPanel(this.createDefaultLabel(this.vPanels.size()), true, component, n);
            if (n2 == this.curIndex || Beans.isDesignTime()) {
                this.showTabPanel(n2);
            }
            this.updatePanelLabels();
        }
        finally {
            Object var5_5 = null;
            this.setSuppressRepaints(bl);
        }
        this.triggerRepaint();
        return component;
    }

    public synchronized Component add(String string, Component component) {
        return component;
    }

    public synchronized void remove(Component component) {
        int n = this.getPanelTabIndex(component);
        if (this.countTabs() == 1) {
            this.removeAllTabPanels();
        } else {
            if (n == 0) {
                this.showTabPanel(1);
            } else {
                this.showTabPanel(n - 1);
            }
            this.removeTabPanel(n);
        }
    }

    public void updatePanelLabels() {
        try {
            int n = 0;
            while (n < this.vPanels.size()) {
                String string;
                if (this.labels != null) {
                    try {
                        string = this.labels[n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        string = this.createDefaultLabel(n);
                    }
                } else {
                    string = this.createDefaultLabel(n);
                }
                this.setLabel(string, n);
                ++n;
            }
        }
        catch (Throwable throwable) {}
    }

    public synchronized void enableTabPanel(boolean bl, int n) throws PropertyVetoException {
        if (n < 0 || n >= this.vPanels.size() || n == this.curIndex) {
            return;
        }
        this.setEnabled(bl, n);
    }

    public synchronized void insertTabPanel(String string, boolean bl, Component component, int n) {
        if (n < 0 || n >= this.vPanels.size()) {
            return;
        }
        if (n == this.getCurrentTab() && !bl) {
            return;
        }
        try {
            this.vPanels.insertElementAt(component, n);
            this.insertTab(string, bl, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public synchronized void removeTabPanel(int n) {
        if (n < 0 || n >= this.vPanels.size() || n == this.curIndex) {
            return;
        }
        try {
            Component component = (Component)this.vPanels.elementAt(n);
            super.remove(component);
            this.vPanels.removeElementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        this.removeTab(n);
    }

    public synchronized void removeAllTabPanels() {
        this.vPanels = new Vector();
        this.curIndex = -1;
        this.removeAllTabs();
    }

    public int countTabs() {
        return this.vPanels.size();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.showTabPanel((Integer)propertyChangeEvent.getNewValue());
    }

    private String createDefaultLabel(int n) {
        String string = "tab - ";
        string = String.valueOf(string) + String.valueOf(n);
        return string;
    }
}

