/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.tomcat.logging.LogDaemon;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.util.Queue;

public class TomcatLogger
extends Logger {
    static LogDaemon logDaemon = null;
    static Queue logQueue = null;

    public static String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (throwable != null) {
            Throwable throwable2;
            throwable.printStackTrace(printWriter);
            if (throwable instanceof ServletException && (throwable2 = ((ServletException)throwable).getRootCause()) != null) {
                String string = "Root cause:";
                printWriter.println(string);
                throwable2.printStackTrace(printWriter);
            }
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    public TomcatLogger() {
        if (logDaemon == null || logQueue == null) {
            logQueue = new Queue();
            logDaemon = new LogDaemon(logQueue);
            logDaemon.start();
        }
    }

    protected void realLog(String string) {
        logQueue.put(new LogEntry(string, null));
    }

    protected void realLog(String string, Throwable throwable) {
        logQueue.put(new LogEntry(string, throwable));
    }

    public void flush() {
        logDaemon.flush();
    }

    class LogEntry {
        String logName;
        long date;
        String message;
        Throwable t;

        LogEntry(String string, Throwable throwable) {
            if (TomcatLogger.this.timestamp) {
                this.date = System.currentTimeMillis();
            }
            this.message = string;
            this.t = throwable;
        }

        Writer getWriter() {
            return TomcatLogger.this.sink;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (!TomcatLogger.this.custom) {
                stringBuffer.append("<");
                stringBuffer.append(TomcatLogger.this.getName());
                stringBuffer.append("> ");
            }
            if (TomcatLogger.this.timestamp) {
                TomcatLogger.this.formatTimestamp(this.date, stringBuffer);
                stringBuffer.append(" - ");
            }
            if (this.message != null) {
                stringBuffer.append(this.message);
            }
            if (this.t != null) {
                stringBuffer.append(" - ");
                stringBuffer.append(TomcatLogger.throwableToString(this.t));
            }
            if (!TomcatLogger.this.custom) {
                stringBuffer.append("</");
                stringBuffer.append(TomcatLogger.this.getName());
                stringBuffer.append("> ");
            }
            return stringBuffer.toString();
        }
    }
}

