package Omniback;

# (c) Copyright Hewlett-Packard Company 2011, all rights reserved














































use English;
use strict;
use Symbol;
use POSIX ":sys_wait_h";

my $BUILD_WHAT = "@(#) HP Data Protector A.06.20; internal build 407, built on Wed Nov  7 20:32:15 2012";


my $filename = __FILE__;
our $RCS = { $filename => {
	source   => '$Source: /integ/perl/Omniback.pm $',
	revision => '$Revision: 34080 $',
	header   => '$Header: /integ/perl/Omniback.pm $Rev: 34080 $ $Date:: 2012-10-15 11:34:20 #$:',
} };


our %PAN = ();



our $OMNI;


sub DbgPlain;
sub DbgStamp;
sub DbgLog;
sub DbgFcnIn;
sub DbgFcnOut;
sub ErhThrow;
sub NlsGetMessage;
sub CmnInit;
sub CmnHostName;
sub CmnRegOpen;


our %info = (
	USERNAME   => undef,
	GROUPNAME  => undef,
	HOSTNAME   => undef,
	PROGNAME   => undef,
	BUILD_VERSION => 'A.06.20',
	BUILD_NUMBER  => '407',
);


our %PROG = (
	UTILCMD     => undef,
	OMNIGETMSG  => undef,
	OMNIRESOLVE => undef,
	OB2SMBSPLIT => undef,
	DMA         => undef,
	TESTBAR     => undef,
	TESTBAR2    => undef,
);


our %DBG = (
	RANGES  => [],
	STACK   => [],
	SESSION => "",
	FILENAME => "",
);



use constant {
	DEBUG_CIRCULAR_DEFAULT => 1024*1024,
	DEBUG_CIRCULAR_MINIMUM => 4*1024,
	DEBUG_CIRCULAR_FACTOR  => 4,
	DEBUG_STACK_SIZE       => 99,
	DEBUG_AUTOFLUSH        => 1,


	DEBUG_ENCODING         => 'ucs2le',


	OB2ERROR               => 1,
	APPERROR               => 2,
	OSERROR                => 4,
	CHILDERROR             => 8,


	NLS_SET_ERRNO          => 12,


	DBG_ALWAYS             => -1,
	DBG_UNEXPECTED         => -2,
	DBG_MAIN_ACTION        => 30,
	DBG_DETAIL_PROGTRACE   => 199,


	ERH_NO_HEADER  => -1,
	ERH_WARNING    =>  0,
	ERH_MINOR      =>  1,
	ERH_MAJOR      =>  2,
	ERH_CRITICAL   =>  3,
	ERH_NORMAL     =>  4,


	MSG_ID        => 0,
	MSG_ABORT     => 1,
	EAB_USERABORT => 12,
	MSG_OPTIONS   => 2,
	
	BAR2_ADMIN_MODE   => 0,
	BAR2_BACKUP_MODE  => 1,
	BAR2_RESTORE_MODE => 2,


	REG_KEY_WRITE  =>  0x20006,
	REG_KEY_READ   =>  0x20019,


	REG_KEY_WOW64_64KEY => 0x0100,
	



	PATHDELIM => ':',

};



BEGIN
{
	use Exporter ();
	our @ISA = qw(Exporter);
	our @EXPORT = qw(
		DBG_MAIN_ACTION DBG_DETAIL_PROGTRACE DBG_UNEXPECTED
		OB2ERROR OSERROR APPERROR CHILDERROR
		ERH_NO_HEADER ERH_WARNING ERH_MINOR ERH_MAJOR ERH_CRITICAL ERH_NORMAL
		MSG_ID MSG_ABORT EAB_USERABORT MSG_OPTIONS
		BAR2_BACKUP_MODE BAR2_RESTORE_MODE BAR2_ADMIN_MODE
		ErhFullReport ErhConsoleReport ErhAgentReport ErhUtilReport
		ErhThrow ErhCatch ErhClear ErhPeek ErhWas ErhBegin ErhEnd
		DbgInit DbgPlain DbgFcnIn DbgFcnOut DbgStamp DbgExit DbgDump
		%PAN %PROG %DBG $RCS $OMNI
		NlsGetMessage NLS_SET_ERRNO
		CmnInit CmnInitEx CmnExit CmnQuotePath CmnSingleQuotePath CmnCleanPath CmnUnpackPath CmnTempFileName CmnRegOpen CmnGetFile
		MonitorConnect MonitorSend MonitorDisconnect
		StrFromUserSessionId StrToUserSessionId
		REG_KEY_READ REG_KEY_WRITE REG_KEY_WOW64_64KEY
		PATHDELIM);
}


INIT
{
	$info{PROGNAME} = uc(CmnUnpackPath($PROGRAM_NAME)->{barename});


	$ENV{OB2PROGRAMNAME} = lc($info{PROGNAME});



	$PAN{DBG} = $PAN{LOG} = $ENV{TEMP} || $ENV{TMP};













































	$PAN{BASE}          = q(/opt/omni);
	$PAN{BIN}           = q(/opt/omni/bin);
	$PAN{LBIN}          = q(/opt/omni/lbin);
	$PAN{SBIN}          = q(/opt/omni/sbin);
	$PAN{LIBPERL}       = qq($PAN{BASE}/lib/perl);
	$PAN{LIB}           = q(/opt/omni/lib);
	$PAN{TMP}           = q(/var/opt/omni/tmp);
	$PAN{DBG}           = q(/tmp);
	$PAN{LOG}           = q(/var/opt/omni/log);
	$PAN{SHORTBASE}     = $PAN{BASE};
	$PAN{SHORTBIN}      = $PAN{BIN};
	$PAN{SHORTLIB}      = $PAN{LIB};
	$PAN{SHORTLBIN}     = $PAN{LBIN};
	$PAN{SHORTTMP}      = $PAN{TMP};
	$PAN{SHORTLIBPERL}  = $PAN{LIBPERL};
	$PAN{CONFIGBASE}    = q(/etc/opt/omni);
	$PAN{CONFIG}        = q(/etc/opt/omni/server);
	$PAN{CONFIGCLIENT}  = q(/etc/opt/omni/client);
	$PAN{CONFIGDB}      = q(/var/opt/omni/server/db40);












	$info{USERNAME}  = ( getpwuid($EFFECTIVE_USER_ID ) )[0];
	$info{GROUPNAME} = ( getgrgid($EFFECTIVE_GROUP_ID) )[0];
	$info{HOSTNAME}  = CmnHostName;












	$PROG{UTILCMD}     = qq(${PAN{LBIN}}/util_cmd);
	$PROG{OMNIGETMSG}  = qq(${PAN{LBIN}}/omnigetmsg);
	$PROG{OMNIRESOLVE} = qq(${PAN{LBIN}}/omniresolve);
	$PROG{OB2SMBSPLIT} = qq(${PAN{LBIN}}/ob2smbsplit);
	$PROG{DMA}         = qq(${PAN{LBIN}}/dma);
	$PROG{TESTBAR}     = qq(${PAN{BIN}}/testbar);
	$PROG{TESTBAR2}    = qq(${PAN{BIN}}/testbar2);


	$PROG{UTILCMDEXE}  = qq(util_cmd.exe);
	$PROG{DMAEXE}      = qq(dma.exe);
	return 1;
}







sub CmnExpandHostName($)
{
	my $host = shift or return undef;

	my ($name,$alias) = gethostbyname ($host);
	$name =~ m{\..+} or do {
		($alias) = grep /^$name\..+/i, split /\s+/, $alias;
		$name = $alias if $alias;
	};

	return $name || $host;
}

my $cmnHostname;
sub CmnHostName
{

	return $cmnHostname if $cmnHostname;




	my $host = qx(hostname);
	chomp $host;
    unless ($host)
    {
        use Sys::Hostname;
        $host = hostname;
    }


	return $cmnHostname = CmnExpandHostName($host);
}


sub CmnQuotePath ($)
{
	my $path = shift;



	return $path =~ m|\s| ? qq("$path") : $path;

}

sub CmnSingleQuotePath ($)
{
	my $path = shift;



	return $path =~ m|\s| ? qq('$path') : $path;

}

sub CmnCleanPath ($)
{
	my $path = shift;
	$path =~ s|\\+|/|g;
	$path =~ s|/$||;
	return $path;
}


sub CmnUnpackPath ($)
{
	my $path = shift;

	my $p = {};





	$path =~ s|\\|/|g;
	$p->{basename} = $1 if $path =~ s|([^/]+)$||;
	$p->{dirname}  = $path;
	($p->{barename}, $p->{extname}) = $p->{basename} =~ m|(^[^\.]+)\.+(.*)$|;


	$p->{absolute} = $path =~ m|^/|;


	return $p;
}


sub CmnTempFileName
{
	my ($prefix, $postfix) = @_;
	my $rnd = sprintf ("%04x", int(rand(0xFFFF)));
	return qq($PAN{TMP}/ob2_${prefix}_${PROCESS_ID}_${rnd}.$postfix);
}


sub CmnRegOpen ($$;$)
{
	my ($hive, $keyname, $param) = @_;
	$param = ref $param eq 'HASH'? $param : {};
	my $key32 = $hive->Open($keyname);
	my $key64 = $hive->Open($keyname, {Access=>REG_KEY_READ|REG_KEY_WOW64_64KEY});

	my $key =
		$param->{type} == 32? $key32 :
		$param->{type} == 64? $key64 :
		(($ENV{PROCESSOR_ARCHITEW6432} eq "IA64") or ($ENV{PROCESSOR_ARCHITEW6432} eq "AMD64"))? $key64 :
		($key32 || $key64);

	$key or do {
		ErhThrow OSERROR, "Can not open registry key '$keyname'";
	};

	return $key;
}


sub CmnFileOpen ($;$)
{
	my ($mode, $file) = @_;
	my $fd;
	if ( ! defined($file) ) { ( $mode, $file ) = ( $_[0] =~ m|(\+?[<>]{1,2})\s*(.+)| ) }
	$mode =~ s/(\+?[<>]{1,2}).*$/$1 :raw/;
	-f $file or return undef if $mode =~ m|^\+?<|;
	open $fd, "$mode", "$file" or return undef;











	binmode $fd, ':utf8';

	return $fd;
}


sub CmnLoadOmnirc
{
	my %param = @_;
	my $omnirc = {};




	my $omnircname = '.omnirc';


	my $filename = qq($PAN{DATA}/$omnircname);

	my $fd = Omniback::CmnFileOpen("<", $filename) or return undef;

	while (defined (my $line = <$fd>))
	{
		chomp $line;
		$line =~ m{^\s*#} and next; # comment
		$line =~ s{\s+$}{}; # trim trailing blanks

		my $key = $1 if $line =~ s{\s*(\w+)\s*=\s*}{};
		next unless $key;

		my $val = $line =~ m{"([^\"]+)"} ? $1 : $line;

		$omnirc->{$key} = $val;
		$ENV{$key} = $val if $param{export};
	}
	close $fd;
	return $omnirc;
}


sub CmnGetShEnv
{
	my ($file, @env) = @_;
	my %env = map { $_ => undef } @env;
	my $tag = '67f8c024-8bf9-49ca-a359-887609a64a28';
	my ($shell, $script);
	open FD, "<$file" or return undef;
	while (<FD>)
	{
		 s|^#!|| and do { $shell = $_; next };
		 $script .= $_;
	}
	close FD;

	$script .= "\necho $tag $_=\$$_\n" foreach (@env);
	my @out = `sh '$script'`;
	foreach (@out)
	{
		my ($name,$value) = m|^$tag ([^=]+)=(\S+)|;
		$env{$name} = $value if $name && $value && exists $env{$name};
	}
	return \%env;
}





sub CmnLibPath()
{



	return qw(LD_LIBRARY_PATH);





}


sub CmnGetFile ($)
{
	my $filename = shift;
	my $fd = gensym;
	my @out = ();

	open $fd, $filename or do {
		ErhThrow OSERROR, $filename;
		return undef;
	};
	while (<$fd>)
	{

		s|[\r\n]$||g;
		push @out, $_ if m|\S|;
	}
	close $fd;
	return @out;
};












sub CmnEnvExpand ($)
{
	my $val = shift;
	$val =~ s|\$([A-Za-z0-9_]+)|$ENV{$1}|g;
	$val =~ s|\$\{([A-Za-z0-9_]+)\}|$ENV{$1}|g;



	return $val;
}


sub CmnCreateTempFile
{
	my @lines = @_;
	my $filename = CmnTempFileName ('OB2', 'tmp');
	open FD, ">$filename" or return undef;
	foreach (@lines)
	{
		chomp;
		print FD $_, "\n";
	}
	close FD;
	return $filename;
}


sub StrFromUserSessionId ($)
{
	my $sessId = shift;
	my ($date, $count) = ( $sessId =~ m|(\d+/\d+/\d+)-(\d+)| );
	return sprintf("%s %04s", $date, $count);
}


sub StrToUserSessionId ($)
{
	my $str = shift;
	my ($date, $count) = ( $str =~ m|(\d+/\d+/\d+)\s+(\d+)| );
	return sprintf("%s-%d", $date, $count);
}




sub HashMatch ($$)
{
	my ($a,$b) = @_;

	return undef unless ref $a eq 'HASH' && ref $b eq 'HASH';
	my %b; $b{+uc($_)} = $b->{$_} foreach keys %$b;

	foreach (keys %$a) {
		return undef unless $a->{$_} eq $b{+uc($_)};
	};
	return 1;
}



sub Hashify ($)
{
	my $list = shift;
	my $hash = {};
	return $hash unless $list;
	for (my $i=0; $i <= $#$list; ++$i)
	{
		$hash->{$list->[$i]} = $i;
	}
	return $hash;
}







sub array_last($)
{
	my $a = shift;
	return undef unless ref $a eq 'ARRAY';
	my $len = scalar(@$a);
	return $len? $a->[$len-1] : undef;
}



my $erhContext = [];
my $erhStack   = [];
my $erhThrowDisabled = 0;








sub ErhBegin ()
{
	push @$erhContext, $erhStack;
	return $erhStack = [];
}


sub ErhEnd ()
{
	my $stack = pop @$erhContext or return $erhStack;
	push @$stack, @$erhStack;
	return $erhStack = $stack;
}




















sub ErhGetExceptionStack ()
{
	return $erhStack;
}


sub ErhDump ($$)
{
	my ($level, $rpt) = @_;
	ref $rpt eq 'HASH' or return;
	DbgPlain $level, "Exception dump:", DbgDump($rpt), "\n";
	1;
}


sub ErhThrow ($;@)
{
	return if $erhThrowDisabled;
	$erhThrowDisabled = 1;

	my $type = shift;
	my $function = (caller (1))[3] || 'main';
	my ($package, $filename, $line) = caller (0);

	my $report = {};

	if ($type == OSERROR)
	{
		$report->{ERRNO}                  = int($OS_ERROR) || $?;
		$report->{ERRSTR}                 = $OS_ERROR;
		$report->{EXTENDED_OS_ERROR}      = int($EXTENDED_OS_ERROR);
		$report->{EXTENDED_OS_ERROR_TEXT} = $EXTENDED_OS_ERROR;
	}
	elsif ($type == CHILDERROR)
	{
		$report->{EXITCODE} = $CHILD_ERROR>>8;
		$report->{SIGNAL}   = $CHILD_ERROR & 127;
	}
	elsif ($type == OB2ERROR)
	{
		my ($msgset, $msgnum) = split(/:/, shift);
		$msgnum or do {
			$msgnum = $msgset;
			$msgset = NLS_SET_ERRNO;
		};
		$report->{ERRNO}  = $msgnum;
		$report->{ERRSET} = $msgset;


		$report->{ERRSTR} = NlsGetMessage($msgset, $msgnum);
	}

	my @args  = grep {$_ and !ref} @_;
	my %merge = map %$_, grep {ref eq 'HASH'} @_;

	$report->{PACKAGE}  = $package;
	$report->{FUNCTION} = $function;
	$report->{TYPE}     = $type;
	$report->{LINE}     = $line;

	$report = { %$report, %merge };
	$report->{INFO} = \@args;


	ErhDump DBG_MAIN_ACTION, $report;
	push @$erhStack, $report;


	$erhThrowDisabled = 0;
	return $report;
}












sub ErhCatch
{
	my %filter = @_;
	if (wantarray)
	{
		my (@catch, @stack);
		foreach (@$erhStack)
		{
			HashMatch(\%filter,$_)? push @catch, $_ : push @stack, $_;
		}
		$erhStack = \@stack;
		return @catch;
	}
	return HashMatch(\%filter, array_last($erhStack))?
		pop @$erhStack :
		undef;
}



sub ErhPeek
{
	my %filter = @_;
	return
		wantarray? grep { HashMatch (\%filter, $_) } @$erhStack :
		HashMatch(\%filter, array_last($erhStack)) ? array_last($erhStack) :
		undef;
}


sub ErhClear
{
	my %filter = @_;
	$erhStack = [ grep { !HashMatch(\%filter, $_) } @$erhStack ];
}


sub ErhFullReport ($;@)
{
	my $level = shift;
	my $args = join "", @_;
	$erhThrowDisabled = 1;
	my $msg = NlsGetMessage('-report', $level, qq("$args"));
	$erhThrowDisabled = 0;
	$msg =~ s|^\t+||gm;
	$msg =~ s|\n+$||;
	$msg =~ s|\n|\n\t|g;
	print STDOUT $msg, "\n\n" if $msg;
}


sub ErhWas ()
{
	return scalar (@$erhStack);
}













sub ErhConsoleReport (;$$)
{
	my ($retval, $monitor) = @_;
	defined $retval and do {
		print "*RETVAL*$retval\n";
		$retval = 1;
	};
	while (my $rpt=ErhCatch())
	{
		$rpt->{TYPE} eq OB2ERROR and do {
			chomp $rpt->{ERRSTR};
			$retval?
				printf "OB2ERR:%d %s\n", $rpt->{ERRNO}, $rpt->{ERRSTR} :
				printf "*RETVAL*%d\n",   $rpt->{ERRNO} unless $monitor;
		};

		$rpt->{TYPE} eq OSERROR and do {
			$retval?
				printf "OSERROR:%d %s\n",  $rpt->{ERRNO}, $rpt->{ERRSTR} :
				printf "*RETVAL*%d\n(%d) %s\n", 1026, $rpt->{ERRNO}, $rpt->{ERRSTR} unless $monitor;
		};

		$rpt->{TYPE} eq CHILDERROR and do {
			$retval?
				printf "CHILDERROR:%d\n", $rpt->{EXITCODE} :
				printf "*RETVAL*%d\n", 8106 unless $monitor;
				printf "Process exit code: %d, Signal: %d\n", $rpt->{EXITCODE}, $rpt->{SIGNAL};
		};

		$rpt->{TYPE} eq APPERROR and do {
			$retval?
				printf "APPERROR:\n" :
				printf "*RETVAL*%d\n", 8100 unless $monitor;
		};

		my @info = @{ $rpt->{INFO} };
		@info and do {
			chomp foreach @info;
			printf "%s\n", join "\n", @info;
		};
		printf "\n";
		$retval = 1;
	}
	printf "*RETVAL*0\n" unless $retval || $monitor;
}


sub ErhUtilReport ()
{
	my $retval;
	while (my $rpt=ErhCatch())
	{
		ErhDump DBG_DETAIL_PROGTRACE, $rpt;

		$rpt->{TYPE} eq OB2ERROR and do {
			my $info = join ("\n\t", @{$rpt->{INFO}});
			printf "*RETVAL*%d\n", $rpt->{ERRNO};
			printf "OB2ERR: %s\n\t%s\n", $rpt->{ERRSTR}, $info;
		};

		$rpt->{TYPE} eq OSERROR and do {
			printf "*RETVAL*%d\n", 1026;
			printf "OSERROR: %s\n%s\n", NlsGetMessage(NLS_SET_ERRNO, 1026), $rpt->{ERRSTR};
		};

		$rpt->{TYPE} eq CHILDERROR and do {
			my $info = join "\n\t", @{$rpt->{INFO}}, qq(Exit code: $rpt->{EXITCODE}, Signal: $rpt->{SIGNAL});
			printf "*RETVAL*%d\n", 8106;
			printf "CHILDERROR: %s\n%s\n", NlsGetMessage(NLS_SET_ERRNO, 8106), $info;
		};

		$rpt->{TYPE} eq APPERROR and do {
			my $info = join ("\n", @{$rpt->{INFO}});
			printf "*RETVAL*%d\n", 8100;
			printf "APPERROR: %s\n%s\n", NlsGetMessage(NLS_SET_ERRNO, 8100), $info;
		};

		$retval = 1;
	}
	printf "*RETVAL*0\n" unless $retval;
}


sub ErhAgentReport ($)
{
	my $level = shift;
	while (my $rpt=ErhCatch())
	{
		ErhDump DBG_DETAIL_PROGTRACE, $rpt;

		$rpt->{TYPE} eq OB2ERROR and do {
			my $info = join ("\n\t", @{$rpt->{INFO}});
			ErhFullReport $level, $rpt->{ERRSTR}, "\n", $info;
		};

		$rpt->{TYPE} eq OSERROR and do {
			ErhFullReport $level, NlsGetMessage(NLS_SET_ERRNO, 1026), "\n", $rpt->{ERRSTR};
		};

		$rpt->{TYPE} eq CHILDERROR and do {
			my $info = join "\n\t", @{$rpt->{INFO}}, qq(Exit code: $rpt->{EXITCODE}, Signal: $rpt->{SIGNAL});
			ErhFullReport $level, NlsGetMessage(NLS_SET_ERRNO, 8106), "\n", $info;
		};

		$rpt->{TYPE} eq APPERROR and do {
			my $info = join ("\n", @{$rpt->{INFO}});
			ErhFullReport $level, NlsGetMessage(NLS_SET_ERRNO, 8100), "\n", $info;
		};
	}
}







sub RcsUnpack ($)
{
	$_[0] =~ m|^\$[^:]+:\s*([^\$\s]+)\s*\$$|;
	return $1;
}

sub DbgMatch ($)
{
	my $level = shift;
	return $level<0? 1 : vec($DBG{RANGELIST}, $level, 1);
}

sub DbgIsSecure($)
{
	my $arg = shift;
	return $arg !~ m|pass|i;
}


sub DbgDump ($)
{
	sub iDbgDump ($$$)
	{
		my ($x, $level, $r) = @_;
		my $ref = ref $x;
		my $tab = "   ";
		my $ident = $tab x $level;

		$ref eq 'ARRAY' and do {
			$$r .= "(\n";
			my $passwd = undef;
			foreach (@$x) {
				$$r .= "$ident$tab";
				my ($par, $val) = ( m|(\S+)\s*=\s*(\S+)| );
				if ( defined($par) && defined($val) && $par =~ m|passwd|i )
				{
					$$r .= "$par=";
					$passwd = 1;
				}
				$passwd ?
					($$r .= '*****' and $passwd = undef) :
					iDbgDump($_,$level+1,$r);
				$passwd = 1 if ( m|passwd|i && !defined($val) ); 
				$$r .= ",\n";
			}
			$$r .= "$ident)";
			return;
		};

		$ref eq 'REF' and do {
			$$r .= '\\';
			iDbgDump ($$x, $level, $r);
			return;
		};

		$ref eq 'HASH' and do {
			$$r .= "{\n";
			foreach (keys %$x) 
			{ 
				$$r .= "$ident$tab$_ = "; 
				DbgIsSecure($_)? iDbgDump ($x->{$_}, $level+1, $r) : ($$r .= '*****');
				$$r .= ";\n"; 
			}
			$$r .= "$ident}";
			return;
		};

		$$r .= $x;
		return;
	}
	my $r = '';
	iDbgDump ($_[0], 0, \$r);
	return "$r\n";
}


sub DbgDumpEnv
{





	return DbgDump \%ENV;

}





















sub DbgUnpackRanges ()
{
	my @elems  = split(/[\s,]+/, $DBG{RANGES});

	foreach my $elem (@elems)
	{
		my ($keyword, $value) = ($elem =~ m|(\w+):(.*)|);
		if (!$keyword)
		{
			my ($left, $right) = split (/-+/, $elem);
			$right = $left  if $left  && not defined $right;
			$left  = $right if $right && not defined $left;
			$left  = 0 if $left<0;
			$right = 0 if $right<0;
			vec($DBG{RANGELIST}, $_, 1)=1 foreach ($left ... $right);
		}
		elsif ( grep (/^$keyword$/i, qw(ID SESSION C T U)) )
		{
			$DBG{$keyword} = $value;
		}
	}


	$DBG{SESSION} =~ s|[/\\]|-|g;
	if (exists $DBG{C})
	{
		my $size = int($DBG{C}) * 1024;
		$size = DEBUG_CIRCULAR_DEFAULT if $size == 0;
		$size = DEBUG_CIRCULAR_MINIMUM if $size < DEBUG_CIRCULAR_MINIMUM;
		$DBG{C} = $size;
	}
}


sub DbgUnpackString ($)
{
	my $arg = shift;
	$arg =~ s{(^")|("$)}{}g;
	my @all = split /\s+/, $arg;
	shift @all if $all[0] =~ m/^-debug/i;
	return @all;
}


sub DbgDumpHeader ()
{
	DbgStamp DBG_ALWAYS;
	DbgPlain DBG_ALWAYS,
		"==================================================================",
		"\n",
		"  DEBUGGING STARTED\n",
		"     PROGNAME: ${info{PROGNAME}}\n",
		"     VERSION:  ${info{BUILD_VERSION}} Build ${info{BUILD_NUMBER}}\n",
		"     RANGES:   ${DBG{RANGES}}\n",
		"     SELECT:   ${DBG{SELECT}}\n",
		"     FILE:     ${DBG{FILENAME}}\n",
		"     PID:      ${PROCESS_ID}\n",
		"     USER:     ${info{USERNAME}}\n",
		"     GROUP:    ${info{GROUPNAME}}\n",
		"     PROGRAM:  ${info{PROGNAME}}\n",
		"     MACHINE:  OS $^O. Perl $]. Debugging flags: $PERLDB. Unicode: ${^UNICODE}\n",
		"\n",
		"==================================================================\n\n";
}


sub DbgCircularCheck()
{
	return unless exists $DBG{C} and (tell $DBG{FILE} > $DBG{C});
	DbgStamp DBG_ALWAYS;
	DbgPlain DBG_ALWAYS,
		"==================================================================\n",
		"  *** CIRCULAR DEBUG TRACE END MARKER ***\n",
		"  \n",
		"  Debug output continues at \"CIRCULAR DEBUG TRACE START MARKER\"\n",
		"  End of trace is in the middle of the file and is marked by the\n",
		"  \"DEBUGGING ENDED PROPERLY\" banner, unless the process\n",
		"  terminated unexpectedly.\n",
		"==================================================================\n";

	truncate { $DBG{FILE} }, 0;
	seek $DBG{FILE}, $DBG{C}/DEBUG_CIRCULAR_FACTOR, 0;

	DbgPlain DBG_ALWAYS, "...\n\n...\n\n...\n\n...\n";
	DbgStamp DBG_ALWAYS;
	DbgPlain DBG_ALWAYS,
		"==================================================================\n",
		"  *** CIRCULAR DEBUG TRACE START MARKER ***\n",
		"  \n",
		"  Some debug output has already been overwritten. Output just\n",
		"  prior to the output that follows can be found at the end of the\n",
		"  file. End of trace is in the middle of the file and can be found\n",
		"  by searching for the banner or by checking the time stamps.\n",
		"==================================================================\n";
}


sub DbgInit
{
	my %params = map %$_, grep { ref eq 'HASH' } @_;
	my @args   = grep { !ref } @_;
	
	my ($ranges, $postfix, $select) = @args;
	

	CmnLoadOmnirc(export=>1);


	($ranges, $postfix, $select) = DbgUnpackString($ENV{OB2DBG})  unless $ranges;
	($ranges, $postfix, $select) = DbgUnpackString($ENV{OB2OPTS}) unless $ranges;


	$ENV{OB2OPTS} = qq(-debug $ranges $postfix $select) if ( $ranges );


	$DBG{RANGES} = $ranges;
	DbgUnpackRanges();


	return 1 if exists $DBG{FILE};


	return 1 unless $ranges;


	my $path = CmnUnpackPath ($postfix);
	my $debugDir = 
		!$path->{dirname} ? $ENV{OB2DBGDIR} || $PAN{DBG} :
		 $path->{absolute}? $path->{dirname} :
		 qq($PAN{DBG}/$path->{dirname});

	$debugDir && (! -e $debugDir) && mkdir ($debugDir);

	$DBG{POSTFIX} = $path->{basename};
	$DBG{SELECT}  = $select;


	my $program = $info{PROGNAME};
	my $host    = $info{HOSTNAME};
	return 1 if $select and not grep (/$program(\@$host)?/i, split (/[\s,]/, $select));

	my $writeBom = exists $DBG{U};

	if ($DBG{POSTFIX})
	{
		my $dbgID = $DBG{ID};
		$dbgID ||= $PROCESS_ID unless $params{reuse};




		my $name = qq(${debugDir}/OB2DBG_${dbgID}_$DBG{SESSION}_$info{PROGNAME}_$info{HOSTNAME});


		$name .= qq(_$PID) unless $params{reuse};
		$DBG{FILENAME} = qq(${name}_$DBG{POSTFIX});
		
		$writeBom = 0 if $params{reuse} && (-e $DBG{FILENAME});

		my $openMode = exists $DBG{U}? '>> :raw' : '>>';

		open $DBG{FILE}, $openMode, $DBG{FILENAME} or do {
			ErhThrow OSERROR, qq(Unable to open file '$DBG{FILENAME}');
			return;
		};

		seek $DBG{FILE}, 0, 2;
	}
	else
	{
		$writeBom = 0;
		$DBG{FILE}     = *STDERR;
		$DBG{FILENAME} = '<stderr>';
	}

	my $fd = $DBG{FILE};


	if (DEBUG_AUTOFLUSH)
	{
		my $oldfd = select($fd); $| = 1; select($oldfd);
	}


	if ($writeBom)
	{
		print   $fd  "\x{FF}\x{FE}";
	}

	if ($DBG{U})
	{
		binmode $fd, sprintf (":encoding(%s)", DEBUG_ENCODING);
	}
	else
	{
		binmode $fd, ':utf8';
	}


	DbgDumpHeader();


	DbgPlain DBG_MAIN_ACTION, '%ENV = ', DbgDumpEnv;


	DbgPlain DBG_MAIN_ACTION, '@ARGV = ', DbgDump(\@ARGV);


	DbgPlain DBG_MAIN_ACTION, 'Exceptions = ', DbgDump(ErhGetExceptionStack());
	
	1;
}

sub CmnInit
{
	my $status = DbgInit(@_);


	$status and do {
		$OMNI = DPCom::Initialize();
		ErhClear();
	};

	return $status;
}

sub CmnExit
{

	DPCom::Kill($OMNI) if $OMNI;

	DbgExit();
}

my @recordMessage      = qw(event, handle, msgid);
my @recordMessageId    = qw(name, version);
my @recordMessageAbort = qw(exit_code, reason);
my @recordMessageOpt   = qw(opt);

my @messageDefinition = (
	[ @recordMessageId ],
	[ @recordMessageAbort ],
	[ @recordMessageOpt ],
);


sub Listen ($)
{
	DbgFcnIn();
	ErhBegin();
	my $timeout = shift;
	my $msg;
	my $retval;

	$msg = $OMNI->Listen($timeout);
	my $i;
	for ($i = 0; $i < @recordMessage; $i++)
	{
		goto exit_fnc if ( not $$msg[$i] );
		$retval->{$recordMessage[$i]} = $$msg[$i];
	}

	my $msgdef = @messageDefinition[$retval->{msgid}];
	my $j = $i;
	for ($i = 0; $i < @$msgdef; $i++)
	{
		$retval->{$$msgdef[$i]} = $$msg[$j];
	}

exit_fnc:

	ErhClear();
	ErhEnd();

	return DbgFcnOut($retval);
}

sub MonitorConnect($)
{
	DbgFcnIn();
	my $port = shift;
	my $handle;
	DbgPlain DBG_MAIN_ACTION, "OMNI PID: $OMNI->{pid}\n";
	$handle = $OMNI->Connect($info{HOSTNAME}, $port) or return DbgFcnOut($handle);
	MonitorSend($handle, ps => {name => 'UTIL_CMD', pid => $OMNI->{pid}, timeout => -1});
	return DbgFcnOut($handle);
}

sub MonitorSend($@)
{
	DbgFcnIn();
	my $handle = shift;
	my %msg = @_; 
	return DbgFcnOut( $OMNI->Send($handle, PackConfig(\%msg)) );
}

sub MonitorDisconnect($)
{
	DbgFcnIn();
	my $handle = shift;
	return DbgFcnOut( $OMNI->Disconnect($handle) );
}













sub Monitor($$)
{
	sub KillPs($;$)
	{
		DbgFcnIn();
		my $ps = shift;
		my $skipPsName = shift;
		my @pid;
		my @info;

		while ( my $proc = shift( @$ps ) )
		{
			next if (defined($skipPsName) && ($proc->{name} eq $skipPsName));

			push @info, qq($proc->{name} PID=$proc->{pid} : TERMINATED);
			push @pid, $proc->{pid};
		}
		DbgPlain DBG_MAIN_ACTION, "Terminating:\n", DbgDump( \@pid ), "\n";
		kill 'TERM', @pid;
		ErhThrow(OB2ERROR, q(12:8105), @info);
		DbgFcnOut();
	}

	sub CleanupPs($)
	{
		DbgFcnIn();
		my $ps = shift;
		for (my $i = 0; $i < @$ps; $i++)
		{
			if ( not kill 0, %$ps->[$i]{pid} )
			{
				DbgPlain DBG_MAIN_ACTION, "Process not running:\n", DbgDump( $ps->[$i] ), "REMOVED\n";
				splice @$ps, $i, 1;
				CleanupPs($ps);
				last;
			}
		}
		DbgFcnOut();
	}

	sub UpdatePs($$)
	{
		DbgFcnIn();
		my $ps = shift;
		my $proc = shift;
		CleanupPs($ps);
		for (my $i = 0; $i < @$ps; $i++)
		{
			if ( %$ps->[$i]{pid} == $proc->{pid} )
			{
				DbgPlain DBG_MAIN_ACTION, "Duplicate process info:\n", DbgDump( $ps->[$i] ), "UPDATED\n";
				splice @$ps, $i, 1;
				last;
			}
		}
		push @$ps, $proc;
		DbgFcnOut();
	}

	sub UpdateSession($$)
	{
		DbgFcnIn();
		my $session = shift;
		my $opt = shift;
		foreach my $item ( keys %$opt )
		{
			if ( $item eq 'ps' )
			{
				UpdatePs($session->{ps}, $opt->{ps});
				next;
			}
			if ( $item eq 'ENV' )
			{
				foreach my $var ( keys %{ $opt->{$item} } )
				{
					$ENV{$var} = $opt->{$item}->{$var};
					DbgPlain DBG_MAIN_ACTION, "ENV VARIABLE set: $var = $ENV{$var}\n";
				}
				next;
			}
			$session->{$item} = $opt->{$item};
		}
		DbgFcnOut();
	}

	sub SessionConnect($)
	{
		DbgFcnIn();
		ErhBegin();
		my $session = shift;

		0 == $OMNI->OB2_Init($session->{apptype}, $session->{appname}) and do {
			if ( $session->{barmode} == BAR2_BACKUP_MODE )
			{
				$OMNI->OB2_StartBackup($session->{barlist}) and return DbgFcnOut(1);
			}
			elsif ( $session->{barmode} == BAR2_RESTORE_MODE )
			{
				$OMNI->OB2_StartRestore($session->{barlist}) and return DbgFcnOut(1);
			}
		};

		ErhClear();
		ErhEnd();

		$session->{smhandle} = $OMNI->OB2_GetSMHandle();
		DbgFcnOut($session->{smhandle});
	}

	sub SessionDisconnect($)
	{
		DbgFcnIn();
		ErhBegin();
		my $session = shift;

		goto exit_fnc if ( $session->{smhandle} == -1 );

		if ( $session->{barmode} == BAR2_BACKUP_MODE )
		{
			$OMNI->OB2_EndBackup(0);
		}
		elsif ( $session->{barmode} == BAR2_RESTORE_MODE )
		{
			$OMNI->OB2_EndRestore(0);
		}

		$OMNI->OB2_Exit();

exit_fnc:
		ErhClear();
		ErhEnd();
		DbgFcnOut();
	}

	$SIG{'TERM'} = 'IGNORE';

	DbgFcnIn();
	my ( $name, $pid ) = @_;
	my @handle;
	my %killed;
	my %session = (
		'smhandle' => undef,
		'appname'  => undef,
		'apptype'  => undef,
		'barmode'  => undef,
		'barlist'  => undef,
		'id'       => undef,
		'guid'     => undef,
		'ps'       => [{name=>$name, pid=>$pid, timeout=>-1, starttime=>time}]
	);

	while( $pid != waitpid($pid, WNOHANG) )
	{
		DbgPlain DBG_MAIN_ACTION, "SESSION: \n", DbgDump( \%session ), "\n";
		my $msg = Listen(10);
		DbgPlain DBG_MAIN_ACTION, 'IPC_EVENT = ', $msg->{event};

		if ( $msg->{msgid} == MSG_ABORT && $msg->{reason} == EAB_USERABORT )
		{
			KillPs($session{ps}, "UTIL_CMD");
			next; 
		};

		( $msg->{msgid} == MSG_OPTIONS ) and do {
			my $opt = UnpackConfig($msg->{opt});
			UpdateSession(\%session, $opt);
		};

		not defined($session{smhandle}) and defined($session{barmode}) and do {
			SessionConnect(\%session) if ( $session{barmode} != BAR2_ADMIN_MODE);
		};

		foreach my $proc ( @{$session{ps}} )
		{
			next if ( -1 == $proc->{timeout} );

			my $elapsed_time = time - $proc->{starttime};
			if ( $elapsed_time > $proc->{timeout} )
			{
				kill 'TERM', $proc->{pid};
				DbgPlain DBG_MAIN_ACTION, "PROCESS timeout reached\n", DbgDump($proc), "TERMINATED\n";
				$killed{$proc->{pid}} = $proc;
			}
		}
		CleanupPs($session{ps});
	}
	my $exit_code = $?>> 8;
	DbgPlain DBG_MAIN_ACTION, 'CHILD EXIT CODE = ', $exit_code;
	my $exit_signal = $? & 127;
	DbgPlain DBG_MAIN_ACTION, 'CHILD EXIT SIGNAL = ', $exit_signal;

	foreach my $pid ( keys %killed )
	{
		my $proc = $killed{$pid};
		ErhThrow(OB2ERROR, q(12:1014),
			qq($proc->{name} PID=$proc->{pid} TIMEOUT=$proc->{timeout}s : TERMINATED)
		);
	}

	if ( $session{barmode} == BAR2_ADMIN_MODE )
	{
		ErhConsoleReport(undef, values %killed ? 0 : 1);
	}
	elsif ( $session{barmode} == BAR2_BACKUP_MODE || $session{barmode} == BAR2_RESTORE_MODE )
	{
		SessionDisconnect(\%session) if ( defined($session{smhandle}) );
		ErhAgentReport(ERH_MAJOR);
	}

	DbgFcnOut();
	CmnExit();
	exit($exit_code);
}


sub CmnInitEx
{
	my ($rh, $wh) = (gensym, gensym);
	pipe($rh, $wh) or do {
		ErhThrow (OSERROR, 'pipe'); 
		return CmnInit(@_);
	};
	my $pid = fork();
	defined($pid) or do {
		ErhThrow (OSERROR, 'fork');
		return CmnInit(@_);
	};
	$pid == 0 and do {
		close($wh);
		my ( $port ) = ( <$rh> =~ m|MONITOR\slistening\son\sport\s(\d+)| );
		$ENV{'OB2MONITORPORT'} = $port;
		return CmnInit(@_);
	};

	close $rh;
	my $oldfh = select($wh); $| = 1; select($oldfh);
	CmnInit(@_);
	defined($OMNI) or do {
		print $wh "MONITOR listening on port 65535\n";
		close $wh;
		exit 0;
	};
	my $port = $OMNI->Port();
	DbgPlain DBG_MAIN_ACTION, 'MONITOR listening on port ', $port;
	print $wh "MONITOR listening on port $port\n";
	close $wh;
	Monitor($info{PROGNAME}, $pid);
}


sub DbgTime
{
	my ($sec,$min,$hour,$mday,$mon,$year) = localtime(time);
	return sprintf "%04d-%02d-%02d %02d:%02d:%02d",
		$year+1900, $mon+1, $mday, $hour, $min, $sec;
}





sub DbgLog (@)
{

	my $logfile = qq($PAN{LOG}/debug.log);
	my $fd;
	open $fd, ">>$logfile" and do {
		my ($package, $file, $line) = caller (0);
		printf $fd "%s %s.%d ('%s %s':%d) %s b%s\n",
			DbgTime(),
			$info{PROGNAME},
			$PROCESS_ID,
			RcsUnpack ($RCS->{$file}->{source}),
			RcsUnpack ($RCS->{$file}->{revision}),
			$line,
			$info{BUILD_VERSION},
			$info{BUILD_NUMBER};
		print $fd @_, "\n";
	};
	close $fd;
}


sub DbgPlain ($;@)
{
	my $level = shift;
	my $fd = $DBG{FILE};
	local $\;
	local $,;

	return unless $DBG{FILE};
	return unless DbgMatch ($level);

	DbgLog(@_)                    if $level == DBG_UNEXPECTED;
	DbgCircularCheck()            if $level > 0;
	printf ($fd "[%3d] ", $level) if $level != DBG_ALWAYS;
	print  $fd @_, "\n";
	1;
}


sub DbgStamp ($)
{
	my $level = shift;
	my ($package, $file, $line) = caller;
	DbgPlain ($level, sprintf (
		"%s ('%s %s':%d) %s b%s",
		DbgTime(),
		RcsUnpack ($RCS->{$file}->{source}),
		RcsUnpack ($RCS->{$file}->{revision}),
		$line,
		$info{BUILD_VERSION},
		$info{BUILD_NUMBER} )
	);
}


sub DbgFcnIn(@)
{
	my $function = ( caller (1) )[3] || 'main';
	DbgPlain 99, "===>> $function {";
	DbgPlain 99, "\t", join (" ", @_) if @_;
}


sub DbgFcnOut
{
	my $retval = shift;
	my $function = ( caller (1) )[3] || 'main';
	my ($package, $file, $line) = caller;
	DbgPlain (99, sprintf (
		"%s ('%s %s':%d) %s b%s",
		DbgTime(),
		RcsUnpack ($RCS->{$file}->{source}),
		RcsUnpack ($RCS->{$file}->{revision}),
		$line,
		$info{BUILD_VERSION},
		$info{BUILD_NUMBER} )
	);
	DbgPlain (99, "retval = ", DbgDump($retval)) if $retval;
	DbgPlain 99, "<<=== }  /* $function */\n";
	return $retval;
}


sub DbgExit ()
{
	return unless $DBG{FILE};
	DbgStamp DBG_ALWAYS;
	DbgPlain DBG_ALWAYS,
		"\n",
		"==================================================================\n",
		"  DEBUGGING ENDED PROPERLY\n",
		"==================================================================\n";
	close $DBG{FILE};
}
















sub iUnpackConfig ($)
{
	my $buf  = shift;
	my $hash = {};
	return $hash unless ref $buf eq 'SCALAR';

	my $reText = qr(\s*\'([^\']*)\'\s*);

	while ($$buf)
	{
		my $key=$1 if $$buf =~ s|^[\s;]*([^\}\s=]+)\s*=\s*||;


		$$buf =~ s|^$reText[;\s]+|| and do {
			$hash->{$key} = $1;
			next;
		};


		$$buf =~ s|^(\d+)[;\s]+|| and do {
			$hash->{$key} = int($1);
			next;
		};


		$$buf =~ s|^\(|| and do {
			while ($$buf =~ s|^$reText,?||)
			{
				push @{ $hash->{$key} }, $1;
			}
			$$buf =~ s|^[\s;)]+||;
			next;
		};


		$$buf =~ s|^\{|| and do {
			my $sublist = {};
			$hash->{$key} = iUnpackConfig ($buf);
			next;
		};


		return $hash if $$buf =~ s|^\s*\}[\s;]*||;


		ErhThrow OB2ERROR, 1008, $$buf;
		return undef;
	}
	return $hash;
}


sub UnpackConfig ($)
{
	my $buf = shift;
	return iUnpackConfig(\$buf);
}




sub iPackConfig ($$)
{
	my ($buf, $cfg) = @_;

	DbgPlain DBG_DETAIL_PROGTRACE, DbgDump($cfg);

	while (my ($key, $val) = each %$cfg)
	{
		ref $val eq 'ARRAY' and do {
			$$buf .= "$key=(";
			$$buf .= join ',', map {"'$_'"} @$val;
			$$buf .= ");\n";
			next;
		};

		ref $val eq 'HASH' and do {
			$$buf .= "$key={\n";
			iPackConfig ($buf, $val);
			$$buf .= "\n};\n";
			next;
		};

		$$buf .= "$key='$val';\n";
	}
}


sub PackConfig ($)
{
	my $cfg = shift;
	my $buf = "";
	iPackConfig (\$buf, $cfg);
	return $buf;
}












sub GetConfigName (@)
{
	my %args = @_;
	my $host = $args{host} || $ENV{OB2BARHOSTNAME} || CmnHostName();
	$host = lc(CmnExpandHostName($host));

	return $args{name} || qq($host\%$args{instance});
}








sub GetConfig (@)
{
	DbgFcnIn();
	my %param = @_;

	DbgPlain DBG_MAIN_ACTION, "GetConfig: ", DbgDump(\%param);

	$param{type} or do {
		ErhThrow (OB2ERROR, 1007, "Missing application type");
		return DbgFcnOut;
	};
	
	$OMNI and do {
		my $cfg = $OMNI->OB2_GetConfig (\%param);
		return DbgFcnOut($cfg);
	};

	my $name = GetConfigName(%param);

	my $buf = RunRetval (CmnQuotePath($PROG{UTILCMD}), "-getmethod", $param{type}, $name) or do {
		return DbgFcnOut;
	};

	my $cfg = iUnpackConfig (\$buf);
	return DbgFcnOut($cfg);
}









sub DumpConfig ($$)
{
	my ($filename, $cfg) = @_;

	my $rnd = sprintf ("%04x", int(rand(0xFFFF)));
	$filename ||= qq($PAN{TMP}/ob2_putconfig_${PROCESS_ID}_${rnd}.tmp);

	my $fd;
	open $fd, ">$filename" or do {
		ErhThrow (OSERROR, { filename => $filename });
		return;
	};

	print $fd PackConfig ($cfg);
	close ($fd);
	return $filename;
}


sub PutConfig (@)
{
	my %param = @_;
	my $cfg = $param{config};

	DbgFcnIn();
	DbgPlain DBG_MAIN_ACTION, "PutConfig: ", DbgDump(\%param);

	$param{localfile} and do {
		my $status = DumpConfig ($param{localfile}, $cfg);
		return DbgFcnOut($status);
	};

	$param{type} or do {
		ErhThrow (OB2ERROR, 1007, "Missing application type");
		return DbgFcnOut;
	};
	
	my $oldErrors = ErhWas();

	$OMNI and do {
		my $status = $OMNI->OB2_PutConfig (\%param);
		return DbgFcnOut($status);
	};

	my $name = GetConfigName (%param);

	my $oldmask = umask oct("0177");

	my $tmpfile = DumpConfig (undef, $cfg) or do {
		return DbgFcnOut;
	};

	umask $oldmask;


	RunRetval (CmnQuotePath($PROG{UTILCMD}), qq(-putmethod $param{type} "$name" -local "$tmpfile"));

	unlink $tmpfile;
	my $retval = ErhWas() == $oldErrors;
	return DbgFcnOut($retval);
}


sub Encode ($)
{
	my $text = shift or return undef;
	my $out = $OMNI ?
		$OMNI->OB2_EncodePassword($text) :
		RunRetval (CmnQuotePath($PROG{UTILCMD}), qq(-encode "$text"), { hideargs=>1, nodebug=>1 } );

	return $out;
}


sub Decode ($)
{
	my $text = shift or return;
	my $out = $OMNI ?
		$OMNI->OB2_DecodePassword($text) :
		RunRetval (CmnQuotePath($PROG{UTILCMD}), qq(-decode "$text"), { hide=>1, nodebug=>1 });

	return $out;
}





















































my $yaclip_config = {
	case  => undef,
	auto  => undef,
};


sub yaclip_config
{
	my $opts = lc (join " ", @_);
	foreach (split /[:\s]+/, $opts)
	{
		next unless $_;
		my $negate = $_ =~ s|^no||;
		$yaclip_config->{$_} = $negate? undef : 1;
	}
}













sub yaclip_match_auto ($;$)
{
	my ($rules, $arg) = @_;
	my $match = undef;
	foreach my $pattern (keys %$rules)
	{
		my @patterns = split (/\|/, $pattern);


		grep /^$arg$/i, @patterns and return $pattern;

		next unless $yaclip_config->{auto};


		grep /^$arg/i, @patterns or next;
		return undef if $match;
		$match = $pattern;
	}
	return $match;
}









sub yaclip_r ($$$)
{
	my ($rules, $argv, $result) = @_;
	my $sep = $yaclip_config->{blank}? ':=\s' : ':=';
	while (my $arg = shift @$argv)
	{

		$arg =~ m|^([^$sep]+)[$sep](.*)| and do {
			$arg = $1;
			unshift @$argv, $2;
		};


		my $switch = yaclip_match_auto($rules, $arg) or do {
			$result->{'#unknown'} = $arg;
			unshift @$argv, $arg;
			return $result;
		};

		my $rule = $rules->{$switch};
		my ($cleanSwitch) = $switch =~ m|([^-/\|]+)|;

		my $parg = [ $arg ];
		push @{ $result->{'#argv'} }, $parg;


		defined $rule or do {
			$result->{$cleanSwitch} ++;
			next;
		};




		$rule = [ $rule ] unless ref $rule eq 'ARRAY';



		my $store;


		if ( $rule->[scalar(@$rule)-1] eq '...' )
		{
			push @{ $result->{$cleanSwitch} }, ($store = {});
		}

		elsif ( grep { ref eq 'HASH' } @$rule )
		{
			$store = $result->{$cleanSwitch} = {};
		}
		else
		{
			$store = $result;
		}



		foreach my $name (@$rule)
		{
			last if $name eq '...';

			ref $name eq 'HASH' and do {
				yaclip_r ($name, $argv, $store);
				next;
			};

			my $optional = $name =~ s|^\[([^\]]+)\]|$1|;
			scalar (@$argv) or do {
				$store->{'#missing'} = qq($cleanSwitch/$name) unless $optional;
				last;
			};


			$optional and do {
				last if yaclip_match_auto($rules, $argv->[0]);
			};

			$store->{$name} = shift @$argv;
			push @$parg, $store->{$name};
		}

		$result->{$cleanSwitch} = 1 unless exists $result->{$cleanSwitch};

	}
	return $result;
}


sub yaclip ($;@)
{
	my $opts = shift;
	return yaclip_r ($opts, \@_, {});
}


sub yaclip_valid ($;@)
{
	my ($argv, @required) = @_;
	my $required = join '|', grep /\S/, @required;
	return
		ref $argv ne 'HASH' || $argv->{'#unknown'} || $argv->{'#missing'}? undef :
		!$required? 1 :
		grep /^$required$/, keys(%$argv);
}






















sub CloseExecHandle ($)
{
	my $handle = shift;
	my $retval = close $handle or do {








		DbgStamp DBG_DETAIL_PROGTRACE;
		DbgPlain DBG_DETAIL_PROGTRACE, "CloseExecHandle failed.";
	};
	return $retval;
}









sub CmnExpandHashBang ($)
{
	my $cmd = shift;

	DbgFcnIn();






































	DbgFcnOut();
	return $cmd;
}

sub Run (@)
{
	my $cmd    = join " ", grep {!ref} @_;
	my %params = map %$_, grep {ref eq 'HASH'} @_;

	DbgFcnIn();
	my ($exe) = $cmd =~ m{((^'[^\']+')|(^"[^\"]+")|(^\S+))};
	$exe = $params{hideargs}? "$exe ****" : $cmd;
	DbgPlain DBG_DETAIL_PROGTRACE, "Executing: '$exe'";
	DbgPlain DBG_DETAIL_PROGTRACE, "Parameters:", DbgDump(\%params);

	$cmd = CmnExpandHashBang($cmd);

	my ($ob2dbg, $ob2opts) = ($ENV{OB2DBG}, $ENV{OB2OPTS});
	$params{nodebug} and do {
		delete $ENV{OB2DBG}; delete $ENV{OB2OPTS};
	};

	if ($params{noout})
	{
		system($cmd) == 0 or do {
			ErhThrow (OSERROR, "While starting: '$exe'");
		};
		goto OUT;
	}

	my $output;
	my @output;
	my $fd = gensym;

	open $fd, "$cmd | " or do {
		ErhThrow (OSERROR, "While starting: '$exe'");
		goto OUT;
	};

	binmode $fd, ":utf8" if $params{utf8};

	while (!eof($fd))
	{
		my $line = <$fd> or last;
		my $plain = $line; chomp $plain;
		DbgPlain DBG_DETAIL_PROGTRACE, "Read line: ", ($params{hide}? '****' : $plain);
		if (wantarray)
		{
			chomp $line;
			push @output, $line;
		}
		else
		{
			$output .= $line;
		}
	}

	CloseExecHandle ($fd) or do {
		ErhThrow(OSERROR,    "Process exited: $exe") if $OS_ERROR    != 0;
		ErhThrow(CHILDERROR, "Process exited: $exe") if $CHILD_ERROR != 0;
	};

OUT:
	$ENV{OB2DBG} = $ob2dbg; $ENV{OB2OPTS} = $ob2opts;
	DbgFcnOut();
	return wantarray? @output : $output;
}












sub RunRetval (@)
{
	DbgFcnIn();
	my $result;
	my @result;
	my $retval;

	ErhBegin ();
	my @output = Run(@_, {utf8=>1});
	ErhClear (TYPE=>CHILDERROR);
	ErhEnd ();

	while (scalar(@output))
	{
		my $line = shift @output or next;

		$line =~ m|^\*RETVAL\*(\d+)$| or do {
			wantarray? push (@result, $line) : ($result .= $line);
			next;
		};
		$retval = int($1);
		DbgPlain DBG_MAIN_ACTION, 'Got *RETVAL*', $retval;
		$retval != 0 and do {
			ErhThrow (OB2ERROR, $retval, @output);
			last;
		};
	}
	ErhThrow (OB2ERROR, 8018) unless defined($retval);

OUT:
	DbgFcnOut();
	return wantarray? @result : $result;
}


sub NlsGetMessage ($$;@)
{
	my ($msgset, $msgnum, @args) = @_;
	!$OMNI || ($msgset eq '-report') and do {
		my $env = $ENV{OB2_CLI_UTF8};
		$ENV{OB2_CLI_UTF8} = 1;
		my $msg = Run CmnQuotePath($PROG{OMNIGETMSG}), $msgset, $msgnum, @args, { nodebug=>1, utf8=>1 };
		$ENV{OB2_CLI_UTF8} = $env;
		return $msg;
	};

	my $fmt = $OMNI->OB2_NlsGetCatalogString($msgset, $msgnum);






	return sprintf ($fmt, @args);
}













sub CmnRunScript (@)
{
	my $argv   = join " ", grep {!ref} @_;
	my %params = map %$_, grep {ref eq 'HASH'} @_;
	my $host   = $params{host} || CmnHostName();
	$argv     .= qq( -debug $DBG{RANGES} $DBG{POSTFIX} $DBG{SELECT}) if $DBG{FILE} && !$params{nodebug};
	my @cmd    = (CmnQuotePath($PROG{UTILCMD}), '-rexec', $host, qq("$argv"));

	push @cmd, ('-user',  $params{user})  if $params{user};
	push @cmd, ('-group', $params{group}) if $params{group};
	
	return RunRetval @cmd, \%params;
}







my @recordObject = qw(objectname objecttype);

my @recordVersion = qw(ovid related_ovid starttime endtime reltime sizelo sizehi
	status flags backuptype prottype prottime catprottype catprottime accesstype accessvalue
	nfiles nwarnings nerrors diskagentid vertype mediaclass backupdevice
	dftype dfsubtype opt);

my @recordFile = qw(name id type uid gid mode sizelo sizehi mtime flags);

my @recordSession = qw(name longname description owner datalist type
	starttime endtime status flags nerrors nwarnings backuptype quetime opt);

my %queryDefinition = (
	FUN_FINDSESSION         => [ @recordSession ],
	FUN_LISTOVEROFSESSION   => [ @recordObject, @recordVersion ],
	FUN_LISTOVEROFAPPBACKUP => [ @recordObject, @recordVersion ],
	FUN_LISTCATALOG         => [ @recordFile ],
	FUN_LISTOBJECTS         => [ @recordObject ],
	FUN_LISTVEROFOBJECT     => [ @recordVersion, 'sessionname' ],
	FUN_GETOVER             => [ @recordObject, @recordVersion, 'sessionname' ],
);

sub Query ($;@)
{
	DbgFcnIn();

	my $fun = shift;
	my @select = map @$_, grep {ref eq 'ARRAY'} @_;
	my %params = map %$_, grep {ref eq 'HASH'} @_;
	my $args = join " ", map qq('$_'), grep {!ref} @_;

	$args = qq("$args");

	DbgPlain DBG_MAIN_ACTION, "Select: ", DbgDump \@select if @select;

	my $rawOutput = 1 if $fun =~ m|EXECINTEGUTIL|i;

	my $columnNames = $queryDefinition{$fun};
	my $columnIds;

	if ($columnNames && @select)
	{
		my $tmp = Hashify($columnNames);
		$columnIds = join ",", map { $tmp->{$_} + 1 } (@select);
		$columnIds = "-query_columns $columnIds";
		$columnNames = \@select;
	}
	DbgPlain DBG_DETAIL_PROGTRACE, "Record definition: ", DbgDump $columnNames;

	my @a = ('-query', $fun, $args, $columnIds);
	push @a, ('-server', $params{server}) if $params{server};

	my @list = RunRetval CmnQuotePath($PROG{UTILCMD}), @a;

	return \@list if $rawOutput;

	my $out = [];
	my $buffer;

	foreach (@list)
	{
		my $record;
		my $result = 1 if m{^\*RESULT\*\d+$};

		!$result and do {
			$buffer .= $_;
			next;
		};

		my $rec = DeSerialize ($buffer);
		$buffer = undef;

		for (my $i=0; $i < scalar(@$rec); ++$i)
		{
			if ($columnNames)
			{
				$record->{$columnNames->[$i]} = $rec->[$i];
			}
			else
			{
				push @$record, $rec->[$i];
			}

			push @$out, $record;
			DbgPlain DBG_DETAIL_PROGTRACE, "Record: ", DbgDump ($record);
		}
	}

	DbgFcnOut();
	return $out;
}


sub PackString($)
{
	my $str = shift;
	$str =~ s|\001|\001\001|g;
	$str =~ s|\'|\001q|g;
	return qq('$str');
}



sub UnpackString($)
{
	my $str = shift;
	$str =~ s|\001q|\'|g;
	$str =~ s|\001Q|\"|g;
	$str =~ s|\001\001|\001|g;
	return $str;
}


sub Serialize ($)
{
	sub iSerialize ($$$)
	{
		my ($x, $level, $r) = @_;
		my $ref = ref $x;

		$ref eq 'ARRAY' and do {
			$$r .= "(";
			my $i = 0;
			foreach (@$x) { $$r .= "," unless !$i++; iSerialize($_,$level+1,$r); }
			$$r .= ")";
			return;
		};

		$ref eq 'REF' and do {
			iSerialize ($$x, $level, $r);
			return;
		};

		$ref && ($ref ne 'GLOB') and do {
			$$r .= "{";
			foreach (keys %$x) 
			{
				my $key = m|[{}()\[\]=,;\s'"]|? PackString($_) : $_;
				$$r .= "$key = "; 
				iSerialize($x->{$_}, $level+1, $r); 
				$$r .= ";"; 
			}
			$$r .= "}";
			return;
		};

		$$r .= PackString($x);
		return;
	}
	my $r = '';
	iSerialize ($_[0], 0, \$r);
	return "$r\n";
}

sub GetCaller(;$)
{
	my $level = shift;
	my ($package, $function, $line) = ((caller($level+1))[0,3], (caller($level))[2]);
	return {
		PACKAGE  => $package,
		FUNCTION => $function,
		LINE     => $line
	};
}

sub ThrowSerializeError ($)
{
	my $buf = shift;
	ErhThrow OB2ERROR, 1008, substr($buf, 0, 80), GetCaller(1);
	return undef;
}


sub iDeSerialize ($)
{
	my $t = shift;

	$$t =~ s|^[;,\s]*||;

	$$t =~ s|^\(|| and do {
		my @y = ();
		return \@y if $$t =~ s|^\s*\)||;
		do {
			push @y, iDeSerialize($t);
		} while ($$t =~ s|^\s*,||);
		$$t =~ s|^\s*\)|| or return ThrowSerializeError ($$t);
		return \@y;
	};

	$$t =~ s|^{|| and do {
		my %y = ();
		do {

			if ($$t =~ s|^\s*'([^\']*)'\s*=\s*||)
			{
				my $name = UnpackString($1);
				$y{$name} = iDeSerialize($t);
			}


			elsif ($$t =~ s|^\s*([^{}()\[\]=,;\s'"]+)\s*=\s*||)
			{
				my $name = $1;
				$y{$name} = iDeSerialize($t);
			}

		} while ($$t =~ s|^\s*[;,]||);
		$$t =~ s|^\s*}|| or return ThrowSerializeError ($$t);
		return \%y;
	};

	$$t =~ s|^\s*'([^\']*)'\s*|| and do {
		return UnpackString($1);
	};

	$$t =~ s|^\s*(-?\d+)\s*|| and do {
		return int($1);
	};
    
    
	ThrowSerializeError ($$t);
}


sub DeSerialize ($)
{
	my $text = shift;
	return unless $text =~ m|\S|;
	return iDeSerialize (\$text);
}









sub GetInstallInfo (;$)
{
    DbgFcnIn();

    my $host = shift;
    my $REMOTE;
   
    if ($host)
    {
        $REMOTE = DPCom::Initialize(hostname=>$host, server=>$PROG{'UTILCMDEXE'});
    }
    else
    {
        $REMOTE = DPCom::Initialize();
    }
    
    my $result = $REMOTE->GetInstallInfo();
    
    DPCom::Kill($REMOTE);
    return $result
}











sub PutToFile ($$;$)
{
    DbgFcnIn();
   
    my $filename = shift;
    my $object = shift;
    my $host = shift;
    my $REMOTE;
 
    if ($host)
    {
        $REMOTE = DPCom::Initialize(hostname=>$host, server=>$PROG{'UTILCMDEXE'});
    }
    else
    {
        $REMOTE = DPCom::Initialize();
    }
    
    my $result = $REMOTE->PutToFile($filename, $object);
    
    DPCom::Kill($REMOTE);
    return $result
}









sub DeleteFile ($;$)
{
    DbgFcnIn();

    my $filename = shift;
    my $host = shift;
    my $REMOTE;
    
    if ($host)
    {
        $REMOTE = DPCom::Initialize(hostname=>$host, server=>$PROG{'UTILCMDEXE'});
    }
    else
    {
        $REMOTE = DPCom::Initialize();
    }
    
    my $result = $REMOTE->DeleteFile($filename);
    
    DPCom::Kill($REMOTE);
    return $result
}





package DPCom;
use English;
use Symbol;
use IPC::Open2;
use POSIX ":sys_wait_h";
use Omniback;

sub DPCom::Initialize
{
	DbgFcnIn();

	my $self = { @_ };

	my $exe  = $PROG{UTILCMD};
	my @args = ('-dpcom', $self->{hostname}, $self->{server});
	my ($stdin, $stdout) = (gensym, gensym);

	DbgPlain DBG_MAIN_ACTION, "Start $exe ", join ', ', @args;

	$ENV{OB2_DPCOM_CLIENT_PID} = $PID;
	eval {
	 	$self->{pid} = open2 ($stdout, $stdin, $exe, @args);
	};
	delete $ENV{OB2_DPCOM_CLIENT_PID};

	$EVAL_ERROR and do {
	 	ErhThrow (OSERROR, $@, "open2");
		return DbgFcnOut();
	};
	my $oldfd = select($stdout); $| = 1; select($oldfd);
	my $oldfd = select($stdin);  $| = 1; select($oldfd);
	
	binmode $stdout, ":raw :utf8";
	binmode $stdin,  ":raw :utf8";

	$self->{stdout} = $stdout;
	$self->{stdin}  = $stdin;

	bless $self, 'DPCom';
	return DbgFcnOut $self;
}



sub DPCom::AUTOLOAD
{
	DbgFcnIn();
	my $self = shift;
	my $result;
	my $goteof;

	my @args = @_;
	return unless ref $self;
	my ($func) = $DPCom::AUTOLOAD =~ m|([^:]+)$|;

	my $packed = Omniback::Serialize(\@args);
	my $hidepasswd = $func eq "OB2_DecodePassword";
	DbgPlain (DBG_MAIN_ACTION, "Call $func ... ");
	DbgPlain (DBG_MAIN_ACTION, "Args: ", $func eq "OB2_EncodePassword" ? "*****" : $packed);
	
	print { $self->{stdin} } "*FUNCTION*$func\n";
	print { $self->{stdin} } $packed;
	print { $self->{stdin} } "*EOF*\n";

	my $buffer;
	while (!eof $self->{stdout})
	{
		my $line = readline ($self->{stdout});
		my $clean = $line;
		$clean =~ s|[\r\n]+$||g;

		$clean =~ m|^\*RESULT\*(\d+)$| and do {
			DbgPlain (DBG_MAIN_ACTION, "Received ", $clean);
			$result = $1;
			next;
		};

		$clean eq '*EOF*' and do {
			DbgPlain (DBG_MAIN_ACTION, "Received *EOF*");
			$goteof = 1;
			my $out = Omniback::DeSerialize ($buffer);
			$result != 0 and do {
				ErhThrow (OB2ERROR, $result, (ref $out eq 'ARRAY')? @$out : undef);
				return DbgFcnOut();
			};

			DbgFcnOut($hidepasswd ? undef : $out);
			return $out;
		};

		DbgPlain (DBG_MAIN_ACTION, "Received ", $hidepasswd ? "*****" : $clean);

		$buffer .= $line;
	}

	defined($result) && defined($goteof) or do {
		ErhThrow (OB2ERROR, 1009, $buffer);
	};

	DbgFcnOut();
}


sub DPCom::Kill
{
	DbgFcnIn();
	my $self = shift;
	my $pid = $self->{pid};

	DbgPlain (DBG_MAIN_ACTION, "Destroy com object $pid");

	waitpid ($pid, WNOHANG) == $pid and do {
		DbgPlain (DBG_MAIN_ACTION, 'Process already dead ...');
		print { $self->{stdin} } "*EXIT*\n";
		close $self->{stdout};
		close $self->{stdin};
		return DbgFcnOut(0);
	};
	
	print { $self->{stdin} } "*EXIT*\n";

	DbgPlain (DBG_MAIN_ACTION, qq(Closing handles...));
	close $self->{stdout};
	close $self->{stdin};

	DbgPlain (DBG_MAIN_ACTION, "Wait for PID $pid to exit ...");
	waitpid ($pid, 0);

	return DbgFcnOut(0);
}


sub DPCom::DESTROY
{
}

1;

__END__























































































