use strict;
use warnings;
use utf8;
use Test::More tests => 20;
use Data::Dump qw(pp);
use NorisOtrsReport::QuelleProcessor;

my %test_parse_standort_ma = (
    'Berlin'      => [ ['Berlin'], [undef] ],
    'Berlin ?'    => [ ['Berlin'], ['?'] ],
    'Berlin ?/?'  => [ ['Berlin'], ['?/?'] ],
    'Berlin: ?/?'  => [ ['Berlin'], ['?/?'] ],
    'Berlin 5/40'  => [ ['Berlin'], ['5/40'] ],
    'Berlin: 5/40,'  => [ ['Berlin'], ['5/40'] ],
    'Berlin, Mannheim' => [ ['Berlin', 'Mannheim'], [undef, undef] ],
    'Berlin 5 / 20, Mannheim 16/40' => [ ['Berlin', 'Mannheim'], ['5 / 20', '16/40'] ],
    'Berlin, Mannheim: ?' => [ ['Berlin', 'Mannheim'], [undef, '?'] ],
    'Berlin 20/40, Mannheim 16/80' => [ ['Berlin', 'Mannheim'], ['20/40', '16/80'] ],
    'Berlin ,Mannheim ?/80,' => [ ['Berlin', 'Mannheim'], [undef, '?/80'] ],
    'Berlin 20/40; Mannheim 16/80 ' => [ ['Berlin', 'Mannheim'], ['20/40', '16/80'] ],
    'Berlin 20/40 ; Mannheim 16/80 ;' => [ ['Berlin', 'Mannheim'], ['20/40', '16/80'] ],
    'Im Wald' => [ [ 'Im Wald'], [undef] ],
    'Auf der Straße ?' => [ [ 'Auf der Straße' ], ['?'] ],
    'In der Luft: ?/?' => [ [ 'In der Luft' ], ['?/?'] ],
    'In der Luft 5/20, Auf dem Wasser: 38' => [ [ 'In der Luft', 'Auf dem Wasser' ], ['5/20', '38' ] ],
    'Obere Turnstr., Unteres Steißbein 7 5/22', [ [ 'Obere Turnstr.', 'Unteres Steißbein 7' ], [ undef, '5/22' ] ],
    'CoreConnection: 19/19, Primondo Logistik (Leiherstr.): 7/7, SB Quelle Grosshandels GmbH: 12/12, WalterServices: 20/20, KüchenQuelle Nürnberg: ?/?'
        => [ [ 'CoreConnection', 'Primondo Logistik (Leiherstr.)', 
               'SB Quelle Grosshandels GmbH', 'WalterServices', 'KüchenQuelle Nürnberg' ],
             [ '19/19', '7/7', '12/12', '20/20', '?/?' ] ],
    'KüchenQuelle Nürnberg: 10/15, Primondo Clearingstelle. 3/3'
        => [ [ 'KüchenQuelle Nürnberg', 'Primondo Clearingstelle.' ],
             [ '10/15', '3/3' ] ],

);

my ($in, $expected, @computed);

while (($in, $expected) = each %test_parse_standort_ma) {
    @computed = NorisOtrsReport::QuelleProcessor::parse_standort_ma($in);
    # warn pp($expected, @computed);
    is_deeply(\@computed, $expected, "$in -> " . pp($expected));
}