use strict;
use warnings;
use utf8;
use Test::More tests => 4;
use Data::Dump qw(pp);
use NorisOtrsReport::Framework qw(generate :convert);
use NorisOtrsReport::QuelleProcessor;
use NorisOtrsReport::TestRenderer;

my $Conversions = [
    [ CreateTime  => \&convert_isodate_to_date_hash, 'created' ],
    [ Created     => \&convert_isodate_to_date_hash, 'created' ]
];

sub test_run {
    my ($LoadFixture, $DateStr, $Typ) = @_;
    my $Start = convert_isodate_to_date_hash($DateStr)->{epoch};
    my $Renderer = NorisOtrsReport::TestRenderer->new();
    my $Processor = NorisOtrsReport::QuelleProcessor->new(
            Typ => $Typ,
            Start => $Start,
            Renderer => $Renderer
        );
    generate(
        UserID => 1,
        Conversions => $Conversions,
        LoadFixture => $LoadFixture,
        Processors => [ $Processor ]
    );
    return $Renderer->items()->[0];
}
    

my $Computed;

# mit Prio
$Computed = test_run(
        't/functional/10010655-01.json', 
        '2009-03-05 08:00', 
        'daily'
    )->[0];
is $Computed->{PrioQuelle}, 2;
is $Computed->{PrioPrimondo}, 4;

# ohne Prio
$Computed = test_run(
        't/functional/10010655-02.json', 
        '2009-03-05 08:00', 
        'daily'
    )->[0];
is $Computed->{PrioPrimondo}, '';
is $Computed->{PrioQuelle}, '';
