package NorisOtrsReport::TemplateRenderer;

use strict;
use warnings;
use utf8;

use Moose;
use NorisOtrsReport::Framework;
use Template;
use Data::Dump qw(pp);

with 'NorisOtrsReport::Renderer';
has 'TemplatePath' => (is => 'ro', isa => 'Str', default => '-');
has 'AdditionalData' => (is => 'ro', isa => 'HashRef', default => sub { {} } );

sub BUILD {
    my ($Self) = @_;
    $Self->{_TT} = Template->new({
            ENCODING => 'utf8', 
            INCLUDE_PATH => '/opt/noris-otrs-reports/templates',
        });
}

sub item {
    my ($Self, $Item) = @_;
    my $vars = {tickets => $Item, %{$Self->{AdditionalData}}};
    $Self->{_TT}->process($Self->{TemplatePath}, $vars) 
        || die $Self->{_TT}->error() . '\n';
    
}

1;
