#! /usr/bin/perl -w
# MD5: 8a3169b791492842ee3ce32df53ed380
# TEST: ./rwuniq --plugin=flowrate.so --fields=payload-bytes --values=bytes,packets,records --sort-output ../../tests/data.rwf

use strict;
use SiLKTests;

my $rwuniq = $ENV{RWUNIQ} || './rwuniq';
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwuniq.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwuniq --plugin=flowrate.so --fields=payload-bytes --values=bytes,packets,records --sort-output $file{data}";
my $md5 = "8a3169b791492842ee3ce32df53ed380";

check_md5_output($md5, $cmd);
