#! /usr/bin/perl -w
# MD5: e473ac4672be53721bcb7ebad000d100
# TEST: ./rwswapbytes --big-endian ../../tests/data-v6.rwf stdout | ../rwcut/rwcut --fields=1-15,26-29 --epoch-time

use strict;
use SiLKTests;

my $rwswapbytes = $ENV{RWSWAPBYTES} || './rwswapbytes';
my $rwcut = check_silk_app('rwcut');
my %file;
$file{v6data} = get_data_or_exit77('v6data');

exit 77 if sub { return (1 != $SiLKTests::SK_ENABLE_IPV6); }->();

my $cmd = "$rwswapbytes --big-endian $file{v6data} stdout | $rwcut --fields=1-15,26-29 --epoch-time";
my $md5 = "e473ac4672be53721bcb7ebad000d100";

check_md5_output($md5, $cmd);
