#! /usr/bin/perl -w
# MD5: 41ced414d0fb3af49ccff6ecb25889f2
# TEST: ./rwstats --plugin=skplugin-test.so --fields=copy-bytes --values=bytes,packets,records --count=10 ../../tests/data.rwf

use strict;
use SiLKTests;

my $rwstats = $ENV{RWSTATS} || './rwstats';
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwstats.' --plugin=skplugin-test.so', 'fields', qr/copy-bytes/); }->();

my $cmd = "$rwstats --plugin=skplugin-test.so --fields=copy-bytes --values=bytes,packets,records --count=10 $file{data}";
my $md5 = "41ced414d0fb3af49ccff6ecb25889f2";

check_md5_output($md5, $cmd);
