#! /usr/bin/perl -w
# MD5: d2683a38a931083fe610488df5773609
# TEST: ./rwstats --plugin=flowrate.so --fields=payload-bytes --values=bytes,packets,records --count=10 ../../tests/data.rwf

use strict;
use SiLKTests;

my $rwstats = $ENV{RWSTATS} || './rwstats';
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwstats.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwstats --plugin=flowrate.so --fields=payload-bytes --values=bytes,packets,records --count=10 $file{data}";
my $md5 = "d2683a38a931083fe610488df5773609";

check_md5_output($md5, $cmd);
