#! /usr/bin/perl -w
# MD5: 36b82267a86669ba4d44335e5400b93b
# TEST: ./rwstats --plugin=flowrate.so --fields=bytes/sec --values=bytes --count=10 ../../tests/data.rwf

use strict;
use SiLKTests;

my $rwstats = $ENV{RWSTATS} || './rwstats';
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwstats.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwstats --plugin=flowrate.so --fields=bytes/sec --values=bytes --count=10 $file{data}";
my $md5 = "36b82267a86669ba4d44335e5400b93b";

check_md5_output($md5, $cmd);
