#! /usr/bin/perl -w
# MD5: 8a3169b791492842ee3ce32df53ed380
# TEST: ./rwsort --plugin=flowrate.so --fields=payload-bytes ../../tests/data.rwf | ../rwuniq/rwuniq --plugin=flowrate.so --fields=payload-bytes --values=bytes,packets,records --presorted-input

use strict;
use SiLKTests;

my $rwsort = $ENV{RWSORT} || './rwsort';
my $rwuniq = check_silk_app('rwuniq');
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwsort.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwsort --plugin=flowrate.so --fields=payload-bytes $file{data} | $rwuniq --plugin=flowrate.so --fields=payload-bytes --values=bytes,packets,records --presorted-input";
my $md5 = "8a3169b791492842ee3ce32df53ed380";

check_md5_output($md5, $cmd);
