#! /usr/bin/perl -w
# MD5: c95b242a6ed2b7e27a6cb3b9e4ad3cca
# TEST: ../rwipfix/rwsilk2ipfix ../../tests/data-v6.rwf | ./rwipfix2silk --silk-output=/dev/null --print-stat 2>&1

use strict;
use SiLKTests;

my $rwipfix2silk = $ENV{RWIPFIX2SILK} || './rwipfix2silk';
my $rwsilk2ipfix = check_silk_app('rwsilk2ipfix');
my %file;
$file{v6data} = get_data_or_exit77('v6data');

exit 77 if sub { return ((0 == $SiLKTests::SK_ENABLE_IPFIX) || (0 == $SiLKTests::SK_ENABLE_IPV6)); }->();

my $cmd = "$rwsilk2ipfix $file{v6data} | $rwipfix2silk --silk-output=/dev/null --print-stat 2>&1";
my $md5 = "c95b242a6ed2b7e27a6cb3b9e4ad3cca";

check_md5_output($md5, $cmd);
