#! /usr/bin/perl -w
# MD5: 561d1cfa1fee9c3b547a95c8c5123e7e
# TEST: ./rwcut --plugin=flowrate.so --fields=bytes,packets,dur,pckts/sec,bytes/sec,bytes/packet,payload-bytes,payload-rate ../../tests/data.rwf

use strict;
use SiLKTests;

my $rwcut = $ENV{RWCUT} || './rwcut';
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwcut.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwcut --plugin=flowrate.so --fields=bytes,packets,dur,pckts/sec,bytes/sec,bytes/packet,payload-bytes,payload-rate $file{data}";
my $md5 = "561d1cfa1fee9c3b547a95c8c5123e7e";

check_md5_output($md5, $cmd);
