#! /usr/bin/perl -w
# MD5: 11151f02e3e150ffd4b2915cd8d4f190
# TEST: ./rwcount --bin-size=3600 --load-scheme=1 ../../tests/empty.rwf ../../tests/data.rwf ../../tests/data-v6.rwf ../../tests/empty.rwf

use strict;
use SiLKTests;

my $rwcount = $ENV{RWCOUNT} || './rwcount';
my %file;
$file{data} = get_data_or_exit77('data');
$file{v6data} = get_data_or_exit77('v6data');
$file{empty} = get_data_or_exit77('empty');

exit 77 if sub { return (1 != $SiLKTests::SK_ENABLE_IPV6); }->();

my $cmd = "$rwcount --bin-size=3600 --load-scheme=1 $file{empty} $file{data} $file{v6data} $file{empty}";
my $md5 = "11151f02e3e150ffd4b2915cd8d4f190";

check_md5_output($md5, $cmd);
