#! /usr/bin/perl -w
# MD5: 52a016b2ff37815a70f639b8639b694f
# TEST: ./rwcat --byte-order=big ../../tests/data-v6.rwf | ../rwcut/rwcut --fields=1-15,20,21,26-29 --epoch-time --delimited

use strict;
use SiLKTests;

my $rwcat = $ENV{RWCAT} || './rwcat';
my $rwcut = check_silk_app('rwcut');
my %file;
$file{v6data} = get_data_or_exit77('v6data');

exit 77 if sub { return (1 != $SiLKTests::SK_ENABLE_IPV6); }->();

my $cmd = "$rwcat --byte-order=big $file{v6data} | $rwcut --fields=1-15,20,21,26-29 --epoch-time --delimited";
my $md5 = "52a016b2ff37815a70f639b8639b694f";

check_md5_output($md5, $cmd);
