/*
** Copyright (C) 2008-2012 by Carnegie Mellon University.
**
** @OPENSOURCE_HEADER_START@
**
** Use of the SILK system and related source code is subject to the terms
** of the following licenses:
**
** GNU Public License (GPL) Rights pursuant to Version 2, June 1991
** Government Purpose License Rights (GPLR) pursuant to DFARS 252.227.7013
**
** NO WARRANTY
**
** ANY INFORMATION, MATERIALS, SERVICES, INTELLECTUAL PROPERTY OR OTHER
** PROPERTY OR RIGHTS GRANTED OR PROVIDED BY CARNEGIE MELLON UNIVERSITY
** PURSUANT TO THIS LICENSE (HEREINAFTER THE "DELIVERABLES") ARE ON AN
** "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY
** KIND, EITHER EXPRESS OR IMPLIED AS TO ANY MATTER INCLUDING, BUT NOT
** LIMITED TO, WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE,
** MERCHANTABILITY, INFORMATIONAL CONTENT, NONINFRINGEMENT, OR ERROR-FREE
** OPERATION. CARNEGIE MELLON UNIVERSITY SHALL NOT BE LIABLE FOR INDIRECT,
** SPECIAL OR CONSEQUENTIAL DAMAGES, SUCH AS LOSS OF PROFITS OR INABILITY
** TO USE SAID INTELLECTUAL PROPERTY, UNDER THIS LICENSE, REGARDLESS OF
** WHETHER SUCH PARTY WAS AWARE OF THE POSSIBILITY OF SUCH DAMAGES.
** LICENSEE AGREES THAT IT WILL NOT MAKE ANY WARRANTY ON BEHALF OF
** CARNEGIE MELLON UNIVERSITY, EXPRESS OR IMPLIED, TO ANY PERSON
** CONCERNING THE APPLICATION OF OR THE RESULTS TO BE OBTAINED WITH THE
** DELIVERABLES UNDER THIS LICENSE.
**
** Licensee hereby agrees to defend, indemnify, and hold harmless Carnegie
** Mellon University, its trustees, officers, employees, and agents from
** all claims or demands made against them (and any related losses,
** expenses, or attorney's fees) arising out of, or relating to Licensee's
** and/or its sub licensees' negligent use or willful misuse of or
** negligent conduct or willful misconduct regarding the Software,
** facilities, or other rights or assistance granted by Carnegie Mellon
** University under this License, including, but not limited to, any
** claims of product liability, personal injury, death, damage to
** property, or violation of any laws or regulations.
**
** Carnegie Mellon University Software Engineering Institute authored
** documents are sponsored by the U.S. Department of Defense under
** Contract FA8721-05-C-0003. Carnegie Mellon University retains
** copyrights in all material produced under this contract. The U.S.
** Government retains a non-exclusive, royalty-free license to publish or
** reproduce these documents, or allow others to do so, for U.S.
** Government purposes only pursuant to the copyright license under the
** contract clause at 252.227.7013.
**
** @OPENSOURCE_HEADER_END@
*/
#ifndef _SKPLUGIN_PRIV_H
#define _SKPLUGIN_PRIV_H

#include <silk/silk.h>

RCSIDENTVAR(rcsID_SKPLUGIN_PRIV_H, "$SiLK: skplugin_priv.h 372a8bc31d8a 2012-02-10 21:55:28Z mthomas $");

/*
**  skplugin_priv.h
**
**  Functions, variables, and types exported from skplugin.c for
**  skplugin-dynlib.c.
**
*/

#include <silk/skplugin.h>

#define HANDLE_TYPE(x) skp_handle_type(x)

#define HANDLE_FIELD                                    \
    (   HANDLE_TYPE(SKPLUGIN_APP_CUT)                   \
        | HANDLE_TYPE(SKPLUGIN_APP_SORT)                \
        | HANDLE_TYPE(SKPLUGIN_APP_GROUP)               \
        | HANDLE_TYPE(SKPLUGIN_APP_UNIQ_FIELD)          \
        | HANDLE_TYPE(SKPLUGIN_APP_UNIQ_VALUE)          \
        | HANDLE_TYPE(SKPLUGIN_APP_STATS_FIELD)         \
        | HANDLE_TYPE(SKPLUGIN_APP_STATS_VALUE))

#define CHECK_MEM(x) \
    do { if (!(x)) { skp_memory_error(); } } while (0)


typedef struct skp_function_common_st {
    const char             *plugin_name;
    skplugin_callback_fn_t  init;
    skplugin_callback_fn_t  cleanup;
    skplugin_callback_fn_t  cbfree;
    void                   *data;
    sk_dllist_t            *extra;
    ssize_t                *extra_remap;
    size_t                  remap_size;
} skp_function_common_t;


typedef struct skp_field_st {
    skp_function_common_t       common; /* Must be first element */
    char                       *title;
    char                      **names;
    char                       *description;
    skplugin_text_fn_t          rec_to_text;
    skplugin_bin_fn_t           rec_to_bin;
    skplugin_bin_to_text_fn_t   bin_to_text;
    skplugin_bin_merge_fn_t     bin_merge;
    skplugin_bin_cmp_fn_t       bin_compare;
    skplugin_fn_mask_t          fn_mask;
    size_t                      field_width_text;
    size_t                      field_width_bin;
    uint8_t                    *initial_value;
} skp_field_t;


typedef void (*skplugin_simple_help_fn_t)(FILE *fh);

/* Whether to print debug information when loading a plugin */
extern int skp_debug;

/* Set to non-zero once skPluginSetup has been called */
extern int skp_initialized;

/* Set to non-zero when we are in the process of running a a plugin's
   setup function */
extern int skp_in_plugin_init;

/* The current operating plugin */
extern const char *skp_current_plugin_name;

/* A list of plugin names */
extern sk_dllist_t *skp_plugin_names;

/* Specifies the types of functionality the app wants from its
 * plugins */
extern skplugin_fn_mask_t *skp_app_type;

/* Holds the extra arguments the application says it will handle */
extern sk_dllist_t *skp_app_support_extra_args;

/* EXPORTED FUNCTIONS */

void skp_memory_error(void);
int skp_handle_type(skplugin_fn_mask_t fn_mask);
ssize_t skp_arg_location(const char *arg, sk_dllist_t *list);
void skp_dynlib_usage(FILE *fh);


#endif /* _SKPLUGIN_PRIV_H */

/*
** Local Variables:
** mode:c
** indent-tabs-mode:nil
** c-basic-offset:4
** End:
*/
