/*
** Copyright (C) 2004-2012 by Carnegie Mellon University.
**
** @OPENSOURCE_HEADER_START@
**
** Use of the SILK system and related source code is subject to the terms
** of the following licenses:
**
** GNU Public License (GPL) Rights pursuant to Version 2, June 1991
** Government Purpose License Rights (GPLR) pursuant to DFARS 252.227.7013
**
** NO WARRANTY
**
** ANY INFORMATION, MATERIALS, SERVICES, INTELLECTUAL PROPERTY OR OTHER
** PROPERTY OR RIGHTS GRANTED OR PROVIDED BY CARNEGIE MELLON UNIVERSITY
** PURSUANT TO THIS LICENSE (HEREINAFTER THE "DELIVERABLES") ARE ON AN
** "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY
** KIND, EITHER EXPRESS OR IMPLIED AS TO ANY MATTER INCLUDING, BUT NOT
** LIMITED TO, WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE,
** MERCHANTABILITY, INFORMATIONAL CONTENT, NONINFRINGEMENT, OR ERROR-FREE
** OPERATION. CARNEGIE MELLON UNIVERSITY SHALL NOT BE LIABLE FOR INDIRECT,
** SPECIAL OR CONSEQUENTIAL DAMAGES, SUCH AS LOSS OF PROFITS OR INABILITY
** TO USE SAID INTELLECTUAL PROPERTY, UNDER THIS LICENSE, REGARDLESS OF
** WHETHER SUCH PARTY WAS AWARE OF THE POSSIBILITY OF SUCH DAMAGES.
** LICENSEE AGREES THAT IT WILL NOT MAKE ANY WARRANTY ON BEHALF OF
** CARNEGIE MELLON UNIVERSITY, EXPRESS OR IMPLIED, TO ANY PERSON
** CONCERNING THE APPLICATION OF OR THE RESULTS TO BE OBTAINED WITH THE
** DELIVERABLES UNDER THIS LICENSE.
**
** Licensee hereby agrees to defend, indemnify, and hold harmless Carnegie
** Mellon University, its trustees, officers, employees, and agents from
** all claims or demands made against them (and any related losses,
** expenses, or attorney's fees) arising out of, or relating to Licensee's
** and/or its sub licensees' negligent use or willful misuse of or
** negligent conduct or willful misconduct regarding the Software,
** facilities, or other rights or assistance granted by Carnegie Mellon
** University under this License, including, but not limited to, any
** claims of product liability, personal injury, death, damage to
** property, or violation of any laws or regulations.
**
** Carnegie Mellon University Software Engineering Institute authored
** documents are sponsored by the U.S. Department of Defense under
** Contract FA8721-05-C-0003. Carnegie Mellon University retains
** copyrights in all material produced under this contract. The U.S.
** Government retains a non-exclusive, royalty-free license to publish or
** reproduce these documents, or allow others to do so, for U.S.
** Government purposes only pursuant to the copyright license under the
** contract clause at 252.227.7013.
**
** @OPENSOURCE_HEADER_END@
*/
#ifndef _LIBUTILS_PRIV_H
#define _LIBUTILS_PRIV_H

#include <silk/silk.h>

RCSIDENTVAR(rcsID_LIBUTILS_PRIV_H, "$SiLK: libutils_priv.h 372a8bc31d8a 2012-02-10 21:55:28Z mthomas $");


/*
**  libutils_priv.h
**
**  "Private" typedefs for use within the files that create libutils.a
**
*/


#include <silk/utils.h>


typedef struct mapOptionsStruct_st {
    int oIndex;                 /* original index */
    clientData cData;           /* client data -- opaque pointer */
    optHandler handler;         /* handler */
} mapOptionsStruct;

struct skAppContext_st {
    /* complete pathname to the application */
    char                name_fullpath[PATH_MAX];
    /* argv[0] used to invoke application */
    const char         *name_argv0;
    /* basename of the application, pointer into 'name_argv0' */
    const char         *name_short;
    /* pointer into 'name_fullpath' that points at the last char in
     * the parent directory of the directory containing the app.  For
     * example, this points to the '/' after "local" in
     * "/usr/local/bin/rwfilter" */
    const char         *parent_lastchar;
    /* where to send errors */
    FILE               *err_stream; /* stderr for now */
    /* function used by skAppPrintErr() */
    sk_msg_vargs_fn_t   err_print_fn;
    /* function used by skAppPrintSyserror() */
    sk_msg_vargs_fn_t   errsys_print_fn;
    /* function used by skAppPrintAbort*() functions */
    sk_msg_fn_t         fatal_print_fn;

    /** from options.c **/

    /* global option count */
    int                 gCount;
    /* number of clients */
    int                 numClients;
    /* function to use to print usage */
    usage_fn_t          usageFunction;
    /* array of all options for this app */
    struct option      *gOptions;
    /* array mapping options to a particular options handler */
    mapOptionsStruct   *oMap;

    /* for printing version info */
    usage_fn_t          versionFunction;
};

/* from sku-app.c; eventually we'll get this from the caller */
extern skAppContext_t *app_context;

#endif /* _LIBUTILS_PRIV_H */


/*
** Local Variables:
** mode:c
** indent-tabs-mode:nil
** c-basic-offset:4
** End:
*/
