/*
** Copyright (C) 2004-2012 by Carnegie Mellon University.
**
** @OPENSOURCE_HEADER_START@
**
** Use of the SILK system and related source code is subject to the terms
** of the following licenses:
**
** GNU Public License (GPL) Rights pursuant to Version 2, June 1991
** Government Purpose License Rights (GPLR) pursuant to DFARS 252.227.7013
**
** NO WARRANTY
**
** ANY INFORMATION, MATERIALS, SERVICES, INTELLECTUAL PROPERTY OR OTHER
** PROPERTY OR RIGHTS GRANTED OR PROVIDED BY CARNEGIE MELLON UNIVERSITY
** PURSUANT TO THIS LICENSE (HEREINAFTER THE "DELIVERABLES") ARE ON AN
** "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY
** KIND, EITHER EXPRESS OR IMPLIED AS TO ANY MATTER INCLUDING, BUT NOT
** LIMITED TO, WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE,
** MERCHANTABILITY, INFORMATIONAL CONTENT, NONINFRINGEMENT, OR ERROR-FREE
** OPERATION. CARNEGIE MELLON UNIVERSITY SHALL NOT BE LIABLE FOR INDIRECT,
** SPECIAL OR CONSEQUENTIAL DAMAGES, SUCH AS LOSS OF PROFITS OR INABILITY
** TO USE SAID INTELLECTUAL PROPERTY, UNDER THIS LICENSE, REGARDLESS OF
** WHETHER SUCH PARTY WAS AWARE OF THE POSSIBILITY OF SUCH DAMAGES.
** LICENSEE AGREES THAT IT WILL NOT MAKE ANY WARRANTY ON BEHALF OF
** CARNEGIE MELLON UNIVERSITY, EXPRESS OR IMPLIED, TO ANY PERSON
** CONCERNING THE APPLICATION OF OR THE RESULTS TO BE OBTAINED WITH THE
** DELIVERABLES UNDER THIS LICENSE.
**
** Licensee hereby agrees to defend, indemnify, and hold harmless Carnegie
** Mellon University, its trustees, officers, employees, and agents from
** all claims or demands made against them (and any related losses,
** expenses, or attorney's fees) arising out of, or relating to Licensee's
** and/or its sub licensees' negligent use or willful misuse of or
** negligent conduct or willful misconduct regarding the Software,
** facilities, or other rights or assistance granted by Carnegie Mellon
** University under this License, including, but not limited to, any
** claims of product liability, personal injury, death, damage to
** property, or violation of any laws or regulations.
**
** Carnegie Mellon University Software Engineering Institute authored
** documents are sponsored by the U.S. Department of Defense under
** Contract FA8721-05-C-0003. Carnegie Mellon University retains
** copyrights in all material produced under this contract. The U.S.
** Government retains a non-exclusive, royalty-free license to publish or
** reproduce these documents, or allow others to do so, for U.S.
** Government purposes only pursuant to the copyright license under the
** contract clause at 252.227.7013.
**
** @OPENSOURCE_HEADER_END@
*/
#ifndef _SKDQPRIVATE_H
#define _SKDQPRIVATE_H

#include <silk/silk.h>

RCSIDENTVAR(rcsID_SKDQPRIVATE_H, "$SiLK: skdqprivate.h 372a8bc31d8a 2012-02-10 21:55:28Z mthomas $");


/*
**  skdqprivate.h
**
**  Internal data structures used by deques
**
**/

#include <silk/skdeque.h>


typedef void (*callbackfn_t)(void *);

/* Deque methods */
typedef struct deque_methods_st {
    skDQErr_t (*status)(skDeque_t self);
    skDQErr_t (*pop)(skDeque_t self, void **item, uint8_t block,
                     uint8_t front, uint32_t seconds);
    skDQErr_t (*peek)(skDeque_t self, void **item, uint8_t front);
    skDQErr_t (*push)(skDeque_t self, void *item, uint8_t front);
    skDQErr_t (*destroy)(skDeque_t self);
    skDQErr_t (*block)(skDeque_t self, uint8_t flag);
    uint32_t (*size)(skDeque_t self);
} deque_methods_t;

/* Deque data structure */
typedef struct sk_deque_st {
    pthread_mutex_t mutex_data; /* mutex storage */
    pthread_mutex_t *mutex;     /* mutex */
    pthread_cond_t cond_data;   /* condition variable storage */
    pthread_cond_t *cond;       /* condition variable */
    deque_methods_t methods;    /* methods */
    void *data;                 /* data (NULL == destroyed) */
    uint8_t ref;                /* reference count */
} sk_deque_t;

/* Deque item */
typedef struct item_st {
    void *item;
    struct item_st *dir[2];      /* 0 == back, 1 == front */
} item_t;

#endif /* _SKDQPRIVATE_H */


/*
** Local Variables:
** mode:c
** indent-tabs-mode:nil
** c-basic-offset:4
** End:
*/
