/*
** Copyright (C) 2001-2012 by Carnegie Mellon University.
**
** @OPENSOURCE_HEADER_START@
**
** Use of the SILK system and related source code is subject to the terms
** of the following licenses:
**
** GNU Public License (GPL) Rights pursuant to Version 2, June 1991
** Government Purpose License Rights (GPLR) pursuant to DFARS 252.227.7013
**
** NO WARRANTY
**
** ANY INFORMATION, MATERIALS, SERVICES, INTELLECTUAL PROPERTY OR OTHER
** PROPERTY OR RIGHTS GRANTED OR PROVIDED BY CARNEGIE MELLON UNIVERSITY
** PURSUANT TO THIS LICENSE (HEREINAFTER THE "DELIVERABLES") ARE ON AN
** "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY
** KIND, EITHER EXPRESS OR IMPLIED AS TO ANY MATTER INCLUDING, BUT NOT
** LIMITED TO, WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE,
** MERCHANTABILITY, INFORMATIONAL CONTENT, NONINFRINGEMENT, OR ERROR-FREE
** OPERATION. CARNEGIE MELLON UNIVERSITY SHALL NOT BE LIABLE FOR INDIRECT,
** SPECIAL OR CONSEQUENTIAL DAMAGES, SUCH AS LOSS OF PROFITS OR INABILITY
** TO USE SAID INTELLECTUAL PROPERTY, UNDER THIS LICENSE, REGARDLESS OF
** WHETHER SUCH PARTY WAS AWARE OF THE POSSIBILITY OF SUCH DAMAGES.
** LICENSEE AGREES THAT IT WILL NOT MAKE ANY WARRANTY ON BEHALF OF
** CARNEGIE MELLON UNIVERSITY, EXPRESS OR IMPLIED, TO ANY PERSON
** CONCERNING THE APPLICATION OF OR THE RESULTS TO BE OBTAINED WITH THE
** DELIVERABLES UNDER THIS LICENSE.
**
** Licensee hereby agrees to defend, indemnify, and hold harmless Carnegie
** Mellon University, its trustees, officers, employees, and agents from
** all claims or demands made against them (and any related losses,
** expenses, or attorney's fees) arising out of, or relating to Licensee's
** and/or its sub licensees' negligent use or willful misuse of or
** negligent conduct or willful misconduct regarding the Software,
** facilities, or other rights or assistance granted by Carnegie Mellon
** University under this License, including, but not limited to, any
** claims of product liability, personal injury, death, damage to
** property, or violation of any laws or regulations.
**
** Carnegie Mellon University Software Engineering Institute authored
** documents are sponsored by the U.S. Department of Defense under
** Contract FA8721-05-C-0003. Carnegie Mellon University retains
** copyrights in all material produced under this contract. The U.S.
** Government retains a non-exclusive, royalty-free license to publish or
** reproduce these documents, or allow others to do so, for U.S.
** Government purposes only pursuant to the copyright license under the
** contract clause at 252.227.7013.
**
** @OPENSOURCE_HEADER_END@
*/
#ifndef _RWPACK_H
#define _RWPACK_H

#include <silk/silk.h>

RCSIDENTVAR(rcsID_RWPACK_H, "$SiLK: rwpack.h 372a8bc31d8a 2012-02-10 21:55:28Z mthomas $");

#include <silk/rwrec.h>
#include <silk/skstream.h>
#include <silk/rwascii.h>


#define rwIOStruct    skstream_t
#define rwIOStruct_t  skstream_t
#define rwIOStructPtr skstream_t*


#define RWIO_ERROR_IS_FATAL(err)    SKSTREAM_ERROR_IS_FATAL(err)


/* macros for accessing header fields */
#define rwGetFileName(rwIOS)        skStreamGetPathname(rwIOS)
#define rwGetHeader(rwIOS)          skStreamGetSilkHeader(rwIOS)

#define rwioClose(rwIOS)            skStreamClose(rwIOS)
#define rwioDestroy(rwIOS)          skStreamDestroy(rwIOS)

#define rwioReadRecord(rwIOS, rec)  skStreamReadRecord((rwIOS), (rec))
#define rwioWriteRecord(rwIOS, rec) skStreamWriteRecord((rwIOS), (rec))

#define rwioWriteHeader(rwIOS)      skStreamWriteSilkHeader(rwIOS)

#define rwioPrintLastErr            skStreamPrintLastErr

#define rwioSetCompression(rwIOS, comp_method)                          \
    skHeaderSetCompressionMethod(skStreamGetSilkHeader(rwIOS), (comp_method))


int rwioCreate(
    skstream_t    **rwIOS,
    const char     *pathname,
    skstream_mode_t read_write_append);
/*
 *    Create a new rwio Stream at the location pointed to by rwIOS.
 *    The new stream is bound to the file at 'pathname', and is
 *    created for read (SK_IO_READ), write (SK_IO_WRITE), or append
 *    (SK_IO_APPEND) according to the value in 'read_write_append'.
 *
 *    For write, the file's format is set to the default version of
 *    FT_RWGENERIC using the machine's native byte order and the
 *    default compression specified when SiLK was configured.
 *
 *    The function returns a value defined in rwioErrorCodes_t.
 */


int rwioOpen(
    skstream_t     *rwIOS);
/*
 *    Open the pathname that 'rwIOS' is bound to.  For an 'rwIOS' that
 *    were created for read or append, this will read the file's
 *    header.
 *
 *    The function returns a value defined in rwioErrorCodes_t.
 */



/* Older API */
#define rwRead(rwIOS, rec)      (!(skStreamReadRecord((rwIOS), (rec))))
#define rwWrite(rwIOS, rec)     skStreamWriteRecord((rwIOS), (rec))

skstream_t *rwOpenFile(const char *fPath, skstream_t *copyInput);
/*
 *  rwIOSPtr = rwOpenFile(filename, copy_stream);
 *
 *    Open the given file 'filename' and based on the header
 *    information setup everything we need to read through the file
 *    always returning rwRec.
 *
 *    If 'copy_stream' is not-NULL, it should be an open skstream_t*
 *    stream to copy the input to.
 *
 *    Return a pointer to a new struct to contain all the information
 *    needed to traverse the file.  Return NULL on error.
 *
 *    If 'filename' is "stdin", then read binary input stream from
 *    stdin.
 */


#define rwCloseFile(rwio)                                       \
    (((rwio) == NULL) ? SKSTREAM_OK : rwioDestroy(&(rwio)))


#endif /* _RWPACK_H */

/*
** Local Variables:
** mode:c
** indent-tabs-mode:nil
** c-basic-offset:4
** End:
*/
