#!/usr/bin/perl -w

use strict;
use Test::More 'no_plan';
$| = 1;



# =for example begin
$::__tc = Test::Builder->new->current_test;
{
eval q{
  my $example = sub {
    local $^W = 0;
    use lib 'lib';
    use noris::Ticket::API qw(select_tickets);
    my @with_area = qw(area1 area42);
    my @without_area = qw(area41 area42);
    my $Selection = select_tickets(in_out_list({
        Arbeitszeit4Ticket::in_out_list(area => \@with_area, \@without_area)
    }));
  };
};
is($@, '', 'Example 1 compiles cleanly');
}
is( Test::Builder->new->current_test - $::__tc, 1,
	'1 test was run in the section' );



# =begin testing
{
is_deeply in_out_list(name => [1,3,5], []), (name => ['in', 1, 3, 5]);
is_deeply in_out_list(name => [], [1,2,3]), (name => [not_in => 1,2,3]);
is_deeply in_out_list(name => [1,3,5], [1,2,3]), (name => [in => 5]);
is_deeply in_out_list(name => [1,2,3], [1,2,3]), (name => ['in']);
is_deeply in_out_list(name => [], []), ();
}




1;
