# (c) 1999 Matthias Urlichs, smurf@noris.de

package RT::ui::web::admin;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use RT::database::config qw(is_a_queue is_a_user);
use RT::ui::web qw(CheckAuth);
use RT::support::utils qw(can_admin_queue can_manipulate_queue can_display_queue booleanize);
use RT::ui::web::support qw(rt_header rt_footer esc select_an_int);
use CGI qw(:standard center);
use RT::database::admin;
use Dbase::Help qw(DoTime);

require Exporter;
use vars qw(@ISA @EXPORT_OK);
@ISA = qw(Exporter);
@EXPORT_OK = qw(activate);

use vars qw(%queues %users);

my $post = "GET";

BEGIN {
    *users = \%RT::users;
    *queues = \%RT::queues;
}

sub activate($;$) { 
	my($request,$user) = @_;
  	use Time::Local;

	my ($value, $message)=&RT::initialize('web_not_authenticated_yet');
	if ($value) {
    	$message="";
	}
	return unless CheckAuth($request,$user);
	# Headers_Authenticated($request);

	return if TakeAction($request);
	DisplayForm($request);
}

### subroutines 

sub DisplayForm($) {
	my($request) = @_;
	my($display) = $request->param('display');
	my($user) = $request->param('auth_user');

    rt_header($request,"WebRT Administration");
    
	print esc($request->param('message')),p(),hr()
        if $request->param('message');

    if (not $display or $display eq 'Return to Main Menu') {
		admin_menu($request);
    } elsif ($display eq 'DumpEnv'){
	    dump_env();
	} elsif (lc($display) eq 'show your rt account permissions') {
	    FormShowUser($request, $user);
	} elsif (lc($display) eq 'create a new queue') {
	    FormModifyQueue($request);
	} elsif (lc($display) eq 'show the user called'){
       	FormShowUser($request, $request->param('user_id'));
	} elsif (lc($display) =~ /(view|modify) the queue called/){
	    FormModifyQueue($request, $queues{$request->param('queue_id')}{id});
	} elsif (lc($display) eq 'delete this queue'){
	    FormDeleteQueue($request, $queues{$request->param('queue_id')}{id});
	} elsif (lc($display) eq 'delete this user'){
	    FormDeleteUser($request, $request->param('user_id'));
	} else {
		admin_menu($request);
		print h2("Unknown request '$display'"),p();
	}
	rt_footer($request);
}

sub TakeAction($) {
	my($request) = @_;
	my $action = $request->param('whatever');
	my $user = $request->param('auth_user');
    my ($queue_id,$acl,$user_id,$value);
	my($flag,$message);

	return 0 unless $action;
    
	if ($action eq "Update Queue") {
		my $queue_id;
		($flag, $queue_id,$message)=add_modify_queue_conf($request->param('queue_id'), $request->param('name'), $request->param('email'), booleanize($request->param('m_owner_trans')), booleanize($request->param('m_members_trans')), booleanize($request->param('m_admin_trans')),booleanize($request->param('m_user_trans')), booleanize($request->param('m_user_create')), booleanize($request->param('m_members_correspond')), booleanize($request->param('m_members_comment')), booleanize($request->param('allow_user_create')), booleanize($request->param('incidents')), booleanize($request->param('m_mail')),$request->param('initial_prio_tens').$request->param('initial_prio_ones'),$user);

		foreach $user_id(sort { lc($a) cmp lc($b) } keys %users) {
			next if $user_id =~ /^\d+$/;
			
			$acl=$request->param("acl_${queue_id}_${user_id}");
			my($res,$ress);

			if ($acl eq 'admin') {
				($res,$ress) = add_modify_queue_acl($request->param('queue_id'),$user_id,1,1,1,$user);
			} elsif ($acl eq 'manip') {
				($res,$ress) = add_modify_queue_acl($request->param('queue_id'),$user_id,1,1,0,$user);
			} elsif ($acl eq 'disp') {
				($res,$ress) = add_modify_queue_acl($request->param('queue_id'),$user_id,1,0,0,$user);
			} elsif ($acl eq 'none') {
				($res,$ress) = add_modify_queue_acl($request->param('queue_id'),$user_id,0,0,0,$user);
			} else {
				$res = 0;
				$ress = "Unknown acl '$acl'";
			}
			if($flag == 2) {
				$flag = $res;
				$message = $ress;
			} else {
				$flag = 0 if $flag == 1 and $ress == 0;
				$message .= ";\n".$ress if $ress ne "";
			}
		}
	} elsif ($action eq "delete_user") {
		($flag, $message)=delete_user($request->param('user_id'), $user);

	
	} elsif ($action eq "delete_queue") {
        ($flag, $message)=delete_queue($request->param('queue_id'), $user);

    } elsif ($action eq 'delete_area') {
		($flag, $message)=delete_queue_area($request->param('queue_id'), $request->param('delete_area'), $user);
    } elsif ($action eq 'add_area') {
		($flag, $message)=add_queue_area($request->param('queue_id'), $request->param('add_area'), $user);
    } else {
		$request->param('message',"No such action '$action'");
		return 0;
	}
	$request->delete_all();
	$request->param('message', $message || "Updated");
	print $request->redirect(-nph => !$DB::apache2, -uri => $request->url(-absolute=>1,-path_info=>1,-query=>1));
	1;
}



sub admin_menu ($) {
	my($request) = @_;
	my $user = $request->param('auth_user');

    my ($queue_id,$user_id,$value);

    page_head($request, "Main Menu");
    
	print startform(-autocomplete=>'off', -action=>$request->url(-absolute=>1,-path_info=>1), -method=>"get"),
	  table({width=>"100%"},
	    Tr({valign=>"top"},
		  td({valign=>"top",align=>"left"},
		     h2("User Configuration"),
			 p('Nur zur Anzeige; siehe auch das <a href="/wiki/index.php/RT#Benutzerverwaltung">Wiki</a>.'),
			$users{$user}{admin_rt} ?
			    submit("display","Show the user called").
			    popup_menu("user_id", [ grep {$_ !~ /^\d+$/} sort { lc($a) cmp lc($b) } keys %users ])
			 : "",br(),
			 submit("display","Show your RT account permissions")),
		  td({valign=>"top",align=>"right"},
		     h2("Queue Configuration"),
			 p('Hier sind &Auml;nderungen m&ouml;glich.'),
	         $users{$user}{admin_rt} ?
			    submit("display","Create a new queue")." "
			 : "", br(),
			 ($users{$user}{admin_rt} or grep {$_ !~ /^\d+$/ and can_admin_queue($_,$user)>0 } keys %queues) ?
			    submit("display","Modify the queue called")." ".
			    popup_menu("queue_id", [ grep {$_ !~ /^\d+$/ and ($users{$user}{admin_rt} or can_admin_queue($_,$user)>0) } sort { lc($a) cmp lc($b) } keys %queues ])
			 : grep {$_ !~ /^\d+$/ and can_manipulate_queue($_,$user)>0 } keys %queues ?
			    submit("display","View the queue called")." ".
			    popup_menu("queue_id", [ grep {$_ !~ /^\d+$/ and  can_manipulate_queue($_,$user)>0 } sort { lc($a) cmp lc($b) } keys %queues ])
			 : "You're not allowed to view/modify queue configuration."
			 ))),
		endform();
}

sub FormShowUser($$){
	my($request,$user_id) = @_;
	my $user = $request->param('auth_user');

	page_head($request, $user_id eq $user ? 'Show your own access rights' : 'Show access rights for '.b(esc $user_id));

	print startform(-autocomplete=>'off', -action=>$request->url(-absolute=>1,-path_info=>1), -method=>$post),
			   h2("Access Control for $user_id"),
		          ($users{user_id}{admin_rt} ? b("This user is an RT administrator").br() : "") . 
			   	  table(
				     map { ($_ !~ /^\d+$/) ? Tr(td(b($_).":"),td(
						(can_admin_queue($_,$user_id) == 1) ? 'admin' :
						(can_manipulate_queue($_,$user_id) == 1) ? 'manipulate' :
					 	(can_display_queue($_,$user_id) == 1) ? 'display' : 
					 	can_display_queue($_,$user_id) ? 'no access' : undef
						)) : undef
					} sort { lc($a) cmp lc($b) } keys %queues
				  ),
		table({width=>"100%",bgcolor=>"#dddddd",border=>0,cellspacing=>0,cellpadding=>3},
		   Tr( td( submit("display","Return to Main Menu")))),
		endform();
}


sub FormModifyQueue($$){
    my ($request,$queue_id) = @_;
	my $user = $request->param('auth_user');

    if ($queue_id) {
		page_head($request, "View/Modify the queue",b(esc($queues{$queue_id}{name})));
	} else {
		page_head($request, "Create a new queue");
    }


	print startform(-autocomplete=>'off', -action=>$request->url(-absolute=>1,-path_info=>1), -method=>$post ),
	  table({width=>"100%",border=>0,cellspacing=>5},
		 Tr(
		    td({align=>"left",valign=>"top"},
			   h2("Queue Configuration"),
			   $queue_id ? hidden("queue_id",$queues{$queue_id}{id}) : "",
			   table(
			      Tr(
				     td("Queue name:"),
					 td(textfield("name",$queues{$queue_id}{name},20,30))),
			      Tr(
				     td("Mail alias:"),
					 td(textfield("email",$queues{$queue_id}{mail_alias},30,50))),
				  Tr(
				     td("Initial priority:"),
					 td(select_an_int($queues{$queue_id}{default_prio},"initial_prio"))),
				),
			   table(
			      Tr(
					 td(
						checkbox("m_owner_trans",$queues{$queue_id}{m_owner_trans}?"checked":"","ON","Mail request owner on transaction"),
						br(),
						checkbox("m_members_trans",$queues{$queue_id}{m_members_trans}?"checked":"","ON","Mail request queue members on transaction"),
						br(),
						checkbox("m_admin_trans",$queues{$queue_id}{m_admin_trans}?"checked":"","ON","Mail request queue administrators on transaction"),
						br(),
						checkbox("m_user_trans",$queues{$queue_id}{m_user_trans}?"checked":"","ON","Mail requestors on transaction"),
						br(),
						checkbox("m_user_create",$queues{$queue_id}{m_user_create}?"checked":"","ON","Autoreply to requestors on creation"),
						br(),
						checkbox("m_members_correspond",$queues{$queue_id}{m_members_correspond}?"checked":"","ON","Mail correspondence to queue members"),
						br(),
						checkbox("m_members_comment",$queues{$queue_id}{m_members_comment}?"checked":"","ON","Mail comments to queue members"),
						br(),
						checkbox("m_mail",$queues{$queue_id}{m_mail}?"checked":"","ON","Send mail for comments received via mail"),
						br(),
						checkbox("allow_user_create",$queues{$queue_id}{allow_user_create}?"checked":"","ON","Allow non-members to create requests"),
						br(),
						checkbox("incidents",$queues{$queue_id}{incidents}?"checked":"","ON","Tickets in this queue are incidents"),
						br(),
						"Delete the area ",
						popup_menu("area",
						   [ ( "--", grep {$_ !~ /^\d+$/ } sort { lc($a) cmp lc($b) } keys %{$queues{$queue_id}{areas}} ) ],
							  "--",{"--" => "None"}),
						br(),
						"Add an area called ",
						textfield("add_area","",15,20))))),
			         td({align=>"right",valign=>"top"},
					    h2("Access Control"),br(),
						table(
				     		map { ($_ !~ /^\d+$/) ? Tr(td(a({href=>$request->url(-absolute=>1,-path_info=>1)."?display=Show+the+user+called&user_id=$_"},$_)), td(select_queue_acls($request, $_, $queue_id))) : undef } sort { lc($a) cmp lc($b) } keys %users )))),
		table({width=>"100%",bgcolor=>"#dddddd",border=>0,cellspacing=>0,cellpadding=>0},
			Tr(
				td({align=>"left",width=>"33%"},
				can_admin_queue($queue_id, $user) ? submit("whatever","Update Queue") : ""),
				td({align=>"center",width=>"33%"},
				can_admin_queue($queue_id, $user) ? submit("display","Delete this Queue") : ""),
				td({align=>"right",width=>"33%"},
				submit("display","Return to Main Menu")))),
	  endform();
}



sub FormDeleteUser($$) {
    my ($request,$user_id) = @_;
    page_head($request,"Confirm Deletion of user",b(esc($users{$user_id}{name})));

	print startform(-autocomplete=>'off', -action=>$request->url(-absolute=>1,-path_info=>1), -method=>$post ),
	  hidden("user_id",$user_id),
	  hidden("whatever","delete_user"),
	  center(submit("Delete this user")),
	  endform(),
	  startform(-action=>$request->url(-absolute=>1,-path_info=>1), -method=>"get"),
	  center(submit("Abort. Do not delete this user")),
	  endform();
}

sub FormDeleteQueue($$){
    my ($request,$queue_id) = @_;
    
    page_head($request,"Confirm deletion of queue",b(esc($queues{$queue_id}{name})));

	print startform(-autocomplete=>'off', -action=>$request->url(-absolute=>1,-path_info=>1), -method=>$post ),
	  hidden("queue_id",$queue_id),
	  hidden("whatever","delete_queue"),
	  center(submit("Delete this queue")),
	  endform(),
	  startform(-autocomplete=>'off', -action=>$request->url(-absolute=>1,-path_info=>1), -method=>"get"),
	  center(submit("Abort. Do not delete this queue")),
	  endform();
}

sub page_head($@) {
	my($request,@args) = @_;
	my $page_title = join(" ",@args);
	print table({width=>"100%",cellpadding=>5,cellspacing=>0,border=>0},
	            Tr({bgcolor=>"#dddddd"},
				   td({align=>"left",valign=>"center"},
				      font({size=>"+2"},
					       a({href=>$request->url(-absolute=>1,-path_info=>1)},
						     "RT Web Administrator"))),
				   td({align=>"right",valign=>"center"},
				      font({size=>"+2"},
					       $page_title))));
}

sub select_queue_acls($$$) {
    my ($request,$user_id, $queue_id) = @_;
    my $flag;

	if(can_display_queue($queue_id,$user_id) != 1) {
		$flag = "none";
	} elsif(can_manipulate_queue($queue_id,$user_id) != 1) {
		$flag = "disp";
	} elsif(can_admin_queue($queue_id,$user_id) != 1) {
		$flag = "manip";
	} else {
		$flag = "admin";
	}
	popup_menu("acl_${queue_id}_${user_id}",
		["none","disp","manip","admin"],
		$flag,
		{none=>"No access",disp=>"Display",manip=>"Manipulate",admin=>"Admin"});
}

1;
