# (c) 1999 Matthias Urlichs, smurf@noris.de

package RT::support::mail;
no warnings 'redefine';

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use vars qw(@ISA @EXPORT_OK);
@ISA = qw(Exporter);
@EXPORT_OK = qw(extract_mailaddresses template_mail);

use RT::I18N qw(english_preferred);
use RT::support::utils qw(is_rt_system template_read template_replace_tokens);
use Cf qw($MAILDOM $RT_DOMAIN $WDESCR);
use Dbase::Globals qw(aufzaehlung get_person mpersinfo sendmail name_kunde get_kunde);
use Dbase::Help qw(DoFn DoTime);
use Email::Valid ();
use Loader qw(get_mailadr);
use Fehler qw(fehler);
use UTFkram qw(is_utf8 decode_anything);

#####
##### Mailing Routines
#####

my $mailseq=0;
use vars qw(%req %users %queues);
sub req_in($;$);

BEGIN {
	*req = \%RT::req;
	*users = \%RT::users;
	*queues = \%RT::queues;

	*req_in = \&RT::database::req_in;
}

sub extract_mailaddresses($) {
	my($input) = @_;
	my @addr;
	for ( split /,/, $input ) {
		s/^\s+//;
		s/\s+\z//;
		push @addr, $_ if length;
	}
	if (wantarray) { @addr }
	else { join ', ', @addr }
}

my $re_header = qr/:\s[^\n]*\n(?:\s[^\n]*\n)*/;

sub template_mail($$$$$$$$$$) {
    my ($in_template,$in_queue_id, $in_recipient, $in_cc, $in_bcc, $in_serial_num, $in_transaction, $in_subject, $in_current_user, $in_custom_content) = @_;
    my ($mailto, $template);
	my @dest;
	my $kunde = $req{$in_serial_num}{kunde};

	defined or $_ = '' for $in_recipient, $in_cc, $in_bcc;

    $template=template_read($in_template, $in_queue_id);
    $template=template_replace_tokens($template,$in_serial_num,$in_transaction, $in_custom_content, $in_current_user);
	if($in_subject eq "") {
		$in_subject = $req{$in_serial_num}{'subject'};
		$in_subject = "$kunde | $in_subject" if index($in_subject,$kunde) < 0;
	} else {
    	$in_subject=template_replace_tokens($in_subject,$in_serial_num,$in_transaction, $in_custom_content, $in_current_user);
	}
    my $from = template_replace_tokens("%trans:actor_long%",$in_serial_num,$in_transaction, "", $in_current_user);
	$from = template_replace_tokens("%user:short_name% <%user:email%>",$in_serial_num,$in_transaction, "", $in_current_user) if $from eq "";

	# Schnellschuss-Lösung, RT#243839
	$from = decode_anything($from) if is_utf8($from);
	$from =~ s/ä/ae/g; $from =~ s/Ä/Ae/g; 
	$from =~ s/ö/oe/g; $from =~ s/Ö/Oe/g; 
	$from =~ s/ü/ue/g; $from =~ s/Ü/Ue/g; 
	$from =~ s/ß/ss/g; 

	return 'template_mail','No Recipient specified'
		unless length $in_recipient || length $in_cc || length $in_bcc;

	for ( $in_recipient, $in_cc, $in_bcc ) {
		next unless length;
		$_ = join ', ', my @addresses = extract_mailaddresses $_;
		push @dest, @addresses;
	}
	if ( $in_template ne 'autoreply' ) { # Workaround für RT#298835
		my $ev = Email::Valid->new(-mxcheck=>1);
		if ( my @invalid = grep !$ev->address( /\@/ ? $_ : $_.'@'.$MAILDOM ), @dest ) {
			fehler 'template_mail','ungültige E-Mail-Adresse', @invalid;
		}
	}

	my $rfrom = "";
	my $nfrom = $in_template ne 'autoreply' && $in_template ne 'subscription' && "$in_serial_num\@$RT_DOMAIN";
	$rfrom = exists $users{$in_current_user} && $users{$in_current_user}{email}
	  || "$in_current_user\@$MAILDOM"
	  if defined $in_current_user;
	$rfrom = $nfrom if $rfrom eq "";

	my $mail = "";
	# print STDERR "Mail EXEC >$mp<\n";

	if($in_transaction || $in_serial_num) {
		my($tid,$seq,$msgid);
		if($in_transaction) {
			$tid = $in_transaction->[0];
			$seq = $in_transaction->[1];
			$msgid = sprintf("%d-%d%%%x-%x-%x",$tid,$seq,$$,DoTime,$mailseq++);
		} else {
			$tid = $in_serial_num;
			$seq = 0;
			$msgid = sprintf("%d%%%x-%x-%x",$tid,$$,DoTime,$mailseq++);
		}
		$msgid .= "\@ticket.$MAILDOM";

		$mail .= "Message-ID: <$msgid>\n";
		# print STDERR "Message-ID: <$msgid>\n";

		my $repid = DoFn("select id from ticketid where ticket = $in_serial_num and seq = 1");
		if($repid ne "") {
			$mail .= "In-Reply-To: <$repid>\n";
			# print STDERR "In-Reply-To: <$repid>\n";
		} else {
			$repid = sprintf("%d-1",$tid);
			$repid .= "\@ticket.$MAILDOM";
			$mail .= "In-Reply-To: <$repid>\n";
			# print STDERR "In-Reply-To: <$repid>\n";
		}
	}
	my($header,$body) = split(/\n\n/,$template,2);
	# Hier den MIME-Kram zu setzen ist ein Hack
	if($header !~ /^\S+:\s/) {
		$body = $template;
		$header = "Mime-Version: 1.0\nContent-Type: text/plain; charset=utf-8\nContent-Transfer-Encoding: 8bit\n";
	} else {
		$header .= "\n";
		$header .= "Mime-Version: 1.0\n" unless $header =~ /^Mime-Version:/mi;
		$header .= "Content-Type: text/plain; charset=utf-8\n" unless $header =~ /^Content-Type:/mi;
		$header .= "Content-Transfer-Encoding: 8bit\n" unless $header =~ /^Content-Transfer-Encoding:/mi;
	}
	$in_subject =~ s/^\s*(re|aw|antwort)\d*:\s*//i;
	$header =~ s/^Delivered-To$re_header//mgio;
	$header =~ s/^(?:Resent-)?Reply-To$re_header//mgio;
	$header =~ s/^(?:Resent-)?Message-ID$re_header//mgio;
	# unklar, wozu das gut war, und momentan stört's, vgl. RT#221430:
	# $header =~ s/^X-\S+$re_header//mgio;
	$header =~ s/^Bcc$re_header//mgio;
	if($from !~ /\w/) {
		$from = get_person($in_current_user);
		if(defined $from and $from > 0) {
			$from = get_mailadr($from);
		} elsif( defined $in_current_user && is_rt_system($in_current_user) ) {
			$from = "root";
		} else {
			$from = $in_current_user;
		}
	}
	$from = $rfrom." ($WDESCR tracking system)"
		if not defined $from or $from eq "" or $from eq "root" or $from eq "<unbekannt>"; ## <= lib/RT/database.pm

	my $subj;
	if($header =~ s/^Subject:\s+(.*(?:\n\s.*)*)\n//mi) {
	 	$subj = $1;
	} else {
		$subj = $in_subject;
	 	1 while $subj =~ s/^\s*(?:Re|AW|Antwort):\s*//i;
		$subj = "Re: $subj";
	}
	my $qn = $queues{$in_queue_id}{name};
	1 while $subj =~ s/\s*\[$WDESCR\s+#\d+\]\s*/ /;
	1 while $subj =~ s/\s*\($qn\)\s*/ /;

	# So, jetzt noch MIME-Kram draus bauen ...
	$subj .= " ($queues{$in_queue_id}{name}) [$WDESCR \#$in_serial_num]";

	# $kunde = get_kunde($kunde);
	# $mail .= "X-Customer: $WDESCR #$kunde ".name_kunde($kunde)."\n" if $kunde;

    $mail .= <<END;
Subject: $subj
END
    $mail .= <<END if $header !~ /^From:\s/mi;
From: $from
END
    $mail .= <<END unless $header =~ /^Reply-To:\s/mi;
Reply-To: $queues{$in_queue_id}{'mail_alias'}
END
    $mail .= <<END if $in_recipient ne "" and $header !~ /^To:\s/mi;
To: $in_recipient
END
    $mail .= <<END if $in_cc ne "" and $header !~ /^Cc:\s/mi;
Cc: $in_cc
END
	$mail .= <<END if $in_current_user;
X-Sender: $in_current_user
END
    $mail .= <<END; ## der Header hat schon eine Newline
X-RT-Queue: $WDESCR.$in_serial_num
X-Managed-By: Request Tracker ($RT::rtversion)
$header
$body
END
    
    sendmail($mail,$nfrom,@dest)
      or $in_template eq 'autoreply' # Workaround für RT#318204/RT#318240
      or fehler "template_mail","Mailversand fehlgeschlagen","$!","<$nfrom> -> <@dest>";

    ( english_preferred() ? 'an e-mail was sent to ' : 'Eine E-Mail wurde verschickt an ' )
      . join ', ', map "<$_>", @dest;
}

1;
