# (c) 1999 Matthias Urlichs, smurf@noris.de

package RT::database::admin;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use vars qw(@ISA @EXPORT);
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(delete_user delete_queue_area delete_queue add_modify_queue_conf add_queue_area add_modify_queue_acl);

use RT::database;
use Dbase::Globals qw(bignum find_descr get_person);
use RT::database::config qw(is_a_queue is_a_user read_config);
use Dbase::Help qw(Do DoFn qquote DoSeq);

use vars qw(%queues %users $time);
BEGIN {
    *queues = \%RT::queues;
	*users = \%RT::users;
	*time = \$RT::time;
}

sub delete_user($$) {
    my  ($user_id,$current_user) = @_;
    my ($query_string,$update_clause);

	return(0,"User $user_id does not exist!")
    	unless is_a_user($user_id);
    

	return(0, "You do not have the privileges to delete user $user_id.")
		unless $users{$current_user}{admin_rt};
	return(0,"You may not delete yourself. (Do you know why?)")
    	if $user_id eq $current_user;
#		$query_string = "DELETE FROM users WHERE user_id = $user_id";
#		$dbh->Query($query_string) or 
#		    return (0, "[delete_user] Query1 had some problem: $Mysql::db_errstr\n$query_string\n");
	Do("DELETE FROM queue_acl WHERE user_id = $user_id");
	    	    
	delete $users{$user_id};
	while (my($queue_id,$value)= each %queues) {
	    delete $queues{$queue_id}{acls}{$user_id};
	}
	return (1, "User $user_id deleted.");
}

sub delete_queue_area($$$) {
    # TODO: this function needs to move all requests into some other area!
    my  ($queue_id,$in_area, $current_user) = @_;
    my ($query_string,$update_clause);


    return (1, "") if $in_area =~ /^none$/i;
    return (0,"Queue $queue_id doesn't have an area \"$in_area\"")
    	unless is_an_area($queue_id, $in_area);
    
    $queue_id=$queues{$queue_id}{id};
    return(0, "You do not have the privileges to delete areas in queue $queue_id.")
    	unless $users{$current_user}{admin_rt} or $queues{$queue_id}{acls}{$current_user}{admin};

    my $aid = DoFn("SELECT id FROM queue_areas WHERE queue=$queue_id AND name=${\qquote $in_area}");
	if(defined $aid) {
    	Do("update ticket set queue_area=NULL, area=NULL where queue_area=$aid");
    	Do("DELETE FROM queue_areas WHERE id=$aid");
	}
	    
    delete $queues{$queue_id}{areas}{$in_area};
    return (1, "Area $in_area in queue $queue_id deleted.");
}          


sub delete_queue($$) {
    # this function needs to move all requests into some other queue!
    my  ($queue_id,$current_user) = @_;
    my ($query_string,$update_clause);


	return(0,"Queue $queue_id does not exist!")
    	unless is_a_queue($queue_id);

    $queue_id=$queues{$queue_id}{id};
	my $queue_name = $queues{$queue_id}{name};

	return(0, "You do not have the privileges to delete queue $queue_id.")
		unless $users{$current_user}{admin_rt} or $queues{$queue_id}{acls}{$current_user}{admin};
	return(0, "This queue is not empty")
    	if DoFn("select count(*) from ticket where queue=$queue_id");
    Do("DELETE FROM queue WHERE id = $queue_id");
    Do("DELETE FROM queue_acl WHERE queue = $queue_id");
    Do("DELETE FROM queue_areas WHERE queue = $queue_id");
    delete $queues{$queue_id};
    delete $queues{$queue_name};
    return (1, "Queue $queue_id deleted.");
}

sub add_modify_queue_conf($$$$$$$$$$$$$$$) {
    my ($queue_id, $in_name, $in_mail_alias, $in_m_owner_trans, $in_m_members_trans, $in_m_admin_trans, $in_m_user_trans, $in_m_user_create, $in_m_members_correspond, $in_m_members_comment, $in_allow_user_create, $in_incidents, $in_m_mail, $in_default_prio, $current_user) = @_;
    my ($query_string,$update_clause);
  
	unless ($queue_id) {

		if ($users{$current_user}{admin_rt}) {
			my $flags = 0;
			$flags |= (bignum(1)<<find_descr("rt_queue","m_owner_trans")) if $in_m_owner_trans;
			$flags |= (bignum(1)<<find_descr("rt_queue","m_members_trans")) if $in_m_members_trans;
			$flags |= (bignum(1)<<find_descr("rt_queue","m_admin_trans")) if $in_m_admin_trans;
			$flags |= (bignum(1)<<find_descr("rt_queue","m_user_trans")) if $in_m_user_trans;
			$flags |= (bignum(1)<<find_descr("rt_queue","m_user_create")) if $in_m_user_create;
			$flags |= (bignum(1)<<find_descr("rt_queue","m_members_correspond")) if $in_m_members_correspond;
			$flags |= (bignum(1)<<find_descr("rt_queue","m_members_comment")) if $in_m_members_comment;
			$flags |= (bignum(1)<<find_descr("rt_queue","allow_user_create")) if $in_allow_user_create;
			$flags |= (bignum(1)<<find_descr("rt_queue","incidents")) if $in_incidents;
			$flags |= (bignum(1)<<find_descr("rt_queue","m_mail")) if $in_m_mail;
			return(0,"No mail address given") unless $in_mail_alias;

			$queue_id = Do("INSERT INTO queue set name=${\qquote $in_name}, email=${\qquote $in_mail_alias}, flags=$flags, defprio=$in_default_prio");

			DoSeq("rtupdate");
			read_config();
			return(1,$queue_id,qq(Queue "$in_name" successfully created.));   
		} else {
			use Carp 'cluck';
			cluck("Create");
			return(0,0,"You do not have permission to create RT queues");
		}
	} else {
		$queue_id = $queues{$queue_id}{id};
		my $flags = DoFn("select flags from queue where id = $queue_id");
		my $origflags = $flags;

		if ($in_name and $in_name ne $queues{$queue_id}{name}) {$update_clause .= "name=${\qquote $in_name}, ";}
		if ($in_mail_alias and $in_mail_alias ne $queues{$queue_id}{mail_alias}) {$update_clause .= "email = ${\qquote $in_mail_alias}, ";}
		if ($in_m_owner_trans) { $flags |= (bignum(1)<<find_descr("rt_queue","m_owner_trans")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","m_owner_trans")); }
		if ($in_m_members_trans) { $flags |= (bignum(1)<<find_descr("rt_queue","m_members_trans")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","m_members_trans")); }
		if ($in_m_admin_trans) { $flags |= (bignum(1)<<find_descr("rt_queue","m_admin_trans")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","m_admin_trans")); }
		if ($in_m_user_trans) { $flags |= (bignum(1)<<find_descr("rt_queue","m_user_trans")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","m_user_trans")); }
		if ($in_m_user_create) { $flags |= (bignum(1)<<find_descr("rt_queue","m_user_create")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","m_user_create")); }
		if ($in_m_members_correspond) { $flags |= (bignum(1)<<find_descr("rt_queue","m_members_correspond")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","m_members_correspond")); }
		if ($in_m_members_comment) { $flags |= (bignum(1)<<find_descr("rt_queue","m_members_comment")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","m_members_comment")); }
		if ($in_allow_user_create) { $flags |= (bignum(1)<<find_descr("rt_queue","allow_user_create")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","allow_user_create")); }
		if ($in_incidents) { $flags |= (bignum(1)<<find_descr("rt_queue","incidents")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","incidents")); }
		if ($in_m_mail) { $flags |= (bignum(1)<<find_descr("rt_queue","m_mail")); } else { $flags &= ~(bignum(1)<<find_descr("rt_queue","m_mail")); }
		if ($flags ne $origflags) {$update_clause .= "flags = $flags, ";}
		if ($in_default_prio ne $queues{$queue_id}{default_prio}) {$update_clause .= "defprio = $in_default_prio, ";}
		if ($update_clause ne "") {

			if (($users{$current_user}{admin_rt}) or ($queues{$queue_id}{acls}{$current_user}{admin})) {
				$update_clause =~ s/,\s*$//;
				$query_string = "UPDATE queue SET $update_clause WHERE id = $queue_id";
				Do($query_string);
				DoSeq("rtupdate");
				read_config();
				return (1, $queue_id, "Queue ".$queues{$queue_id}{name}." updated.");
			} else {
				return(0, $queue_id, "You do not have the privileges to modify queue $queue_id.");
			}
		} else {
			return (2, $queue_id, "No changes in ".$queues{$queue_id}{name}." have been made.");
		}
	}
}


sub add_queue_area($$$) {
    my ($queue_id,$in_area,$current_user) = @_;
    my ($query_string,$update_clause);

    return(0,"Queue $queue_id already has an area \"$in_area\"")
    	unless is_an_area($queue_id, $in_area);
    return(0,"That area cannot be created")
    	if $in_area =~ /^none$/i;

    return(0,"That queue does not exist")
    	unless is_a_queue($queue_id);
    
    $queue_id = $queues{$queue_id}{id};

    return(0, "You do not have the privileges to add areas to queue $queue_id.")
		unless $users{$current_user}{admin_rt} or $queues{$queue_id}{acls}{$current_user}{admin};
    Do("INSERT INTO queue_areas set queue=$queue_id, queue_area=${\qquote $in_area}");
	DoSeq("rtupdate");
	$queues{$queue_id}{areas}{$in_area}=1;
    return(1,"Area $in_area has been added to queue $queue_id");
}       

my $dd;
sub add_modify_queue_acl($$$$$$) {
    my ( $queue_id,$user_id,$in_display,$in_manipulate,$in_admin,$current_user) = @_;
    my ($query_string,$update_clause);
    $queue_id = $queues{$queue_id}{id};
    $user_id = get_person($user_id);
    
    return(0,"That queue does not exist")
    unless is_a_queue($queue_id);
    return(0,"That user does not exist")
    	unless is_a_user($user_id);

    my $flag;
	return(0, "You do not have the privileges to modify users' ACLs for queue $queue_id.")
    	unless $users{$current_user}{admin_rt} or $queues{$queue_id}{acls}{$current_user}{admin};
# don't lock yourself out

    $in_admin = 1 if $user_id eq $current_user and not $in_admin and $queues{$queue_id}{acls}{$current_user}{admin};

	if (not defined ($flag = DoFn("select acls from queue_acl where queue = $queue_id and person = $user_id"))) {
	    $flag = 0;
	    $flag |= bignum(1)<<find_descr("rt_acl","display") if $in_display;
	    $flag |= bignum(1)<<find_descr("rt_acl","manipulate") if $in_manipulate;
	    $flag |= bignum(1)<<find_descr("rt_acl","admin") if $in_admin;
		# print STDERR "...Flag INSERT $flag\n";

	    Do("INSERT INTO queue_acl set queue=$queue_id, person=$user_id, acls=$flag") if $flag;
		DoSeq("rtupdate");

	    $queues{$queue_id}{acls}{$user_id}{display}=$in_display;
	    $queues{$queue_id}{acls}{$user_id}{manipulate}=$in_manipulate;
	    $queues{$queue_id}{acls}{$user_id}{admin}=$in_admin;
	    return(1,"User ".$users{$user_id}{name}." has been granted permissions to queue ".$queues{$queue_id}{name}.".");   
	} else {
	    my $old_flag = $flag;

	    if ($in_display) { $flag |= (bignum(1)<<find_descr("rt_acl","display")); } else { $flag &= ~(bignum(1)<<find_descr("rt_acl","display")); }
	    if ($in_manipulate) { $flag |= (bignum(1)<<find_descr("rt_acl","manipulate")); } else { $flag &= ~(bignum(1)<<find_descr("rt_acl","manipulate")); }
	    if ($in_admin) { $flag |= (bignum(1)<<find_descr("rt_acl","admin")); } else { $flag &= ~(bignum(1)<<find_descr("rt_acl","admin")); }

	    if ($flag != $old_flag) {
			if($flag) {
				print STDERR "...Flag UPDATE $flag\n";
				Do("UPDATE queue_acl SET acls = $flag WHERE queue = $queue_id AND person = $user_id");
			} else {
				print STDERR "...Flag DELETE\n";
	    		Do("DELETE FROM queue_acl WHERE queue = $queue_id AND person = $user_id");
			}
			DoSeq("rtupdate");
			delete $queues{$queue_id}{acls}{$user_id};
			read_config();
		
			return (1, "User ".$users{$user_id}{name}."'s ACLs for queue ".$queues{$queue_id}{name}." updated.");
	    } else {
			return (2, ""); # unchanged
	    }
	}
}

1;
