# Webserver-Script für die RT-Administration

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;

package RT::Admin;

use vars qw(%req %queues);

use strict;
use RT;
use RT::database qw(connectdb); 
use RT::database::config qw(read_config);  
use Dbase::Help qw(DoFree DoTime);

RT::initialize();

use CGI qw(:standard);
use Dbase::Help qw(DoFn);

sub handler($) {
	$DB::apache2 = 1;

	my($r) = @_;
	my $cgi = $CGI::Q = new CGI;
	my $program = $cgi->url(-absolute=>1,-path_info=>1,-query=>1);
	#$cgi->use_named_parameters(1);

	use RT::ui::web::admin;

	my $remote_user;
	eval { $remote_user = $r->connection->user; $DB::apache2 = 0; };
	$remote_user = $r->user if $@;

	$r->content_type("text/html; charset='utf-8'") if $DB::apache2;

	my $res = RT::ui::web::admin::activate ($cgi,$remote_user);
	DoFree();
	$res;
}

1;
