package RT::AddOn::Confitems;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use base 'RT::AddOn';

use Dbase::Globals qw(aufzaehlung get_descr get_kunde list_descr mpersinfo);
use Dbase::Help qw(Do DoFn DoSelect in_list qquote);
use HTML::Entities qw(encode_entities);
use RT::support::utils qw(normalize_sn);
use RT::ui::web::support qw(get_default_query4user);

our %all_queues = ( change_kunde => 1 );

my @fragen;    # Liste mit Einträgen [ num.ID, Kurzname, Fragetext ]
list_descr( rt_fragen => 1, undef, sub { shift; push @fragen, \@_ } );

sub _get_confitems(&$) {
	my ( $sub, $kunde_id ) = @_;
	return unless $kunde_id && $kunde_id =~ /^\d+\z/;
	DoSelect \&$sub, <<_;
	SELECT id, name, kunde
	FROM   confitem
	WHERE  kunde IS NULL OR kunde = $kunde_id
_
}

sub _get_objects4ticket($$) {
	my ( $object_type, $serial ) = @_;
	my @objects;
	DoSelect { push @objects, @_ } <<_;
	SELECT $object_type
	FROM   rt_incidents_$object_type
	WHERE  incident = $serial
_
	@objects;
}

sub _get_leitungen(&$) {
	my ( $sub, $kunde_id ) = @_;
	return unless $kunde_id && $kunde_id =~ /^\d+\z/;
	DoSelect \&$sub, <<_;
	SELECT id, name, art, carrier, name_carrier, name_kunde
	FROM   leitung
	WHERE  kunde = $kunde_id
	  AND  ( ende IS NULL OR ende > UNIX_TIMESTAMP(NOW()) )
_
}

sub _get_antworten4ticket($) {
	my ($serial) = @_;
	my %antwort;
	DoSelect {
		my ( $frage_id, $antwort ) = @_;
		$antwort{$frage_id} = $antwort;
	  }
	  "SELECT frage, antwort FROM rt_antwort WHERE ticket = $serial";
	%antwort;
}

sub _link2similar_tickets(@) {
	my ( $package, @confitems ) = @_;
	require RT::Web;
	my $cgi = get_default_query4user($package->user);
	$cgi->param( display => 'Queue' );
	$cgi->param( q_ci => @confitems );
	$cgi->param( q_owner_all => 'true' );
	$cgi->param( q_queue_all => 'true' );
	$cgi->param( q_sort => 'date_acted,DOWN,number,DOWN' );
	$cgi->param( q_status => qw( open stalled resolved ) );
	$cgi->url( -query => 1, -relative => 1 );
}

sub _assign2ticket(&$$$$) {
	my ( $get_function, $object_type, $kunde, $ticket, $subject ) = @_;
	my %object;
	$get_function->(
		sub {
			my ( $id, $name ) = @_;
			$object{ uc $name } = $id;
		},
		$kunde
	);
	my $pattern = join '|', map quotemeta,
	  sort { length $b <=> length $a } keys %object
	  or return;
	my %seen;
	my $values = join ', ', map "($ticket,$_)", grep !$seen{$_}++,
	  map $object{ +uc }, $subject =~ /\b($pattern)\b/gi
	  or return;
	Do(<<_);
	INSERT INTO rt_incidents_$object_type (incident, $object_type)
	VALUES $values
_
}

sub change_kunde {    # s. RT#393815
	my ( $package, $serial, $kunde ) = @_;
	die qq(Invalid serial "$serial"; caller: ), map "<$_>", caller
	  unless $serial =~ /^\d+\z/;

	my $kunde_id = get_kunde($kunde) or return qq(Kunde "$kunde" unbekannt);

	my ( @loesche_cis, @loesche_ids );
	DoSelect {
		my ( $ci_alt_name, $ci_alt_id, $ci_neu_id ) = @_;
		if ( defined $ci_neu_id ) {
			Do(<<_) }
	UPDATE rt_incidents_confitem
	SET    confitem = $ci_neu_id
	WHERE  confitem = $ci_alt_id AND incident = $serial
_
		else {
			push @loesche_cis, $ci_alt_name;
			push @loesche_ids, $ci_alt_id;
		}
	}
	<<_;
	SELECT    confitem.name, confitem.id, ci_neu.id
	FROM      ( confitem, rt_incidents_confitem )
	LEFT JOIN confitem ci_neu
	       ON ci_neu.name = confitem.name AND ci_neu.kunde = $kunde_id
	WHERE     rt_incidents_confitem.incident = $serial
	      AND rt_incidents_confitem.confitem = confitem.id
	      AND confitem.kunde IS NOT NULL
_

	if (@loesche_ids) {
		Do( "DELETE FROM rt_incidents_confitem WHERE incident = $serial AND "
			  . in_list( confitem => '', @loesche_ids ) );
		$package->add_transaction(
			$serial, undef,
			(
				@loesche_cis == 1
				? 'Kundenspezifisches CI'
				: 'Kundenspezifische CIs'
			  )
			  . ' '
			  . aufzaehlung( map "'$_'", @loesche_cis )
			  . ' gelöscht'
		);
	}

	();
}

sub copy {
	my ( $package, $serial, $copy_from_serial ) = @_;
	die qq(Invalid serial "$serial"; caller: ), map "<$_>", caller
	  if $serial !~ /^\d+\z/;
	die qq(Invalid other serial "$copy_from_serial"; caller: ), map "<$_>",
	  caller
	  if $copy_from_serial !~ /^\d+\z/;

	for my $typ (qw(confitem leitung)) {
		Do(<<_) for _get_objects4ticket( $typ => $copy_from_serial );
	INSERT INTO rt_incidents_$typ (incident, $typ) VALUES ($serial, $_)
_
	}
}

sub do_merge {
	my ( $package, $serial, $into ) = @_;
	/^\d+\z/ or die qq(Invalid serial "$serial"; caller: ), map "<$_>", caller
	  for $serial, $into;
	for ( qw(confitem leitung) )  {
		Do(<<_);
	DELETE s
	FROM   rt_incidents_$_ s, rt_incidents_$_ i
	WHERE  s.incident = $serial
	   AND i.incident = $into
	   AND s.$_       = i.$_
_
		Do(<<_);
	UPDATE rt_incidents_$_ SET incident = $into WHERE incident = $serial
_
	}
	return;
}

sub init_ticket($$;$$$) {

	my ( $package, $serial, $date_created, $kunde, $subject ) = @_;

	die qq(Invalid serial "$serial"; caller: ), map "<$_>", caller
	  unless $serial =~ /^\d+\z/;

	return unless $kunde && $subject;
	_assign2ticket ( \&_get_leitungen, leitung  => $kunde, $serial, $subject );
	_assign2ticket ( \&_get_confitems, confitem => $kunde, $serial, $subject );
	return;
}

sub resolvable($$) {
	my ( $package, $req ) = @_;

	return
	  'Das Ticket darf erst resolved werden, wenn alle Fragen beantwortet sind.'
	  if keys %{ { _get_antworten4ticket( $req->{serial_num} ) } } < @fragen;

	return
	  if _get_objects4ticket( confitem => $req->{serial_num} ) || !DoFn(<<_);
	SELECT COUNT(*)
	FROM   confitem
	WHERE  kunde IS NULL OR kunde = $req->{kunde_id}
_
'Das Ticket darf erst geschlossen werden, wenn mindestens ein Conf. Item eingetragen ist.';
}

sub show_form {
	my ( $package, $req, $request ) = @_;
	( my $serial = $req->{serial_num} ) =~ /^\d+\z/ or die;

	my ( %confitem, @confitems, %leitung, @leitungen );

	my $kunde_id = $req->{kunde_id};

	if ($kunde_id) {

		$kunde_id =~ s/\D+//g;
		die unless $kunde_id;

		_get_confitems {
			my ( $id, $name, $kunde ) = @_;
			$confitem{ $kunde || '' }{$id} = $name;
		  }
		  $kunde_id;

		@confitems = _get_objects4ticket( confitem => $serial );

		_get_leitungen {
			my ( $id, $name, $art, $carrier, $name_carrier, $name_kunde ) = @_;
			my @add_names;
			if ( defined $carrier ) {
				$carrier = mpersinfo $carrier;
				push @add_names,
				  defined $name_carrier
				  ? "\@$carrier: $name_carrier"
				  : "Carrier: $carrier";
			}
			else {
				push @add_names, "\@Carrier: $name_carrier"
				  if defined $name_carrier;
			}
			push @add_names, "\@Kunde: $name_kunde" if defined $name_kunde;
			$leitung{$id} = (
				@add_names
				? "$name (" . join( '; ', @add_names ) . ')'
				: $name
			  )
			  . ( defined $art
				  && ( ' [' . get_descr( leitungsart => $art ) . ']' ) );
		  }
		  $kunde_id;

		@leitungen = _get_objects4ticket( leitung => $serial );
	}

	return unless @fragen || keys %confitem || keys %leitung;

	my %antwort = _get_antworten4ticket($serial);

	require RT::CGI4AddOn;
	my $cgi = RT::CGI4AddOn->new;
	print $cgi->table(
		{ bgcolor => '#ccffcc', cellpadding => 16 },
		$cgi->Tr(
			[
				@confitems > 0
				? $cgi->th(
					$cgi->a(
						{
							href   => $package->_link2similar_tickets(@confitems),
							target => 'aehnliche_Tickets'
						},
'letzte Tickets mit &auml;hnlichen Configuration Items anzeigen'
					)
				  )
				: (),
				$cgi->td(
					$cgi->start_form,
					$cgi->table(
						$cgi->Tr(
							[
								map( {
										my (
											$description, $typ, $plsuffix,
											$hr,          $ar
										  )
										  = @$_;
										  keys %$hr
										? $cgi->td(
											{ valign => 'top' },
											[
												"$description:",
												$cgi->hidden(
													-name =>
"_confitems_$typ$plsuffix",
													-value => 'X'
												  )
												  . $cgi->scrolling_list(
													-name => "_confitems_$typ",
													-values => [
														sort {
															lc $hr->{$a} cmp
															  lc $hr->{$b}
														  } keys %$hr
													],
													-default  => $ar,
													-labels   => $hr,
													-multiple => 1,
													-size     => keys %$hr > 4
													? 5
													: scalar keys %$hr
												  )
											]
										  )
										: ()
									}[
'Betroffene(s) globale(s) Conf. Item(s)',
										qw(confitem s),
										\%{ $confitem{''} },
										\@confitems
									],
									$kunde_id
									? [
'Betroffene(s) Conf. Item(s) des Kunden',
										qw(confitem s),
										\%{ $confitem{$kunde_id} },
										\@confitems
									  ]
									: (),
									[
										'Betroffene Leitung(en)',
										qw(leitung en),
										\%leitung,
										\@leitungen
									] ),
								@fragen
								? $cgi->td(
									{ colspan => 2 },
									$cgi->table(
										$cgi->Tr(
											[
												map $cgi->td(
													{ valign => 'top' },
													encode_entities( $_->[2] )
												  )
												  . $cgi->td(
													$cgi->radio_group(
														-default =>
														  $antwort{ $_->[0] }
														  || '-',
														-labels => {
															J => 'ja',
															N => 'nein'
														},
														-name =>
														  "antwort[$_->[0]]",
														-values => [qw(J N)]
													)
												  ),
												@fragen
											]
										)
									)
								  )
								: (),
								$cgi->td(
									{ align => 'center', colspan => 2 },
									$cgi->reset . ' ' . $cgi->save_data($serial)
								)
							]
						)
					)
				)
			]
		)
	  ),
	  $cgi->end_form;
}

sub save_data {
	my ( $package, $cgi ) = @_;
	my @messages;
	my $serial = $cgi->param('serial_num');
	die qq(Keine korrekte Ticketnummer: "$serial"\n) if $serial !~ /^\d+\z/;
	$serial = normalize_sn($serial);

	for ( [qw(confitem s)], [qw(leitung en)] ) {
		my ( $typ, $plsuffix ) = @$_;
		next unless $cgi->param("_confitems_$typ$plsuffix");
		my %selected;
		@selected{ $cgi->param("_confitems_$typ") } = ();
		{
			my $deleted;
			DoSelect {
				my ($id) = @_;
				if ( exists $selected{$id} ) { delete $selected{$id} }
				else {
					Do <<_ and ++$deleted;
	DELETE FROM rt_incidents_$typ
	WHERE       incident = $serial AND $typ = $id
_
				}
			  }
			  "SELECT $typ FROM rt_incidents_$typ WHERE incident = $serial";
			push @messages,
			  "$deleted \u$typ" . ( $deleted != 1 && $plsuffix ) . ' gelöscht'
			  if $deleted;
		}
		{
			my $inserted;
			while ( my ($id) = each %selected ) {
				Do <<_ and ++$inserted;
	INSERT INTO rt_incidents_$typ (incident, $typ) VALUES ($serial, $id)
_
			}
			push @messages,
			  "$inserted \u$typ"
			  . ( $inserted != 1 && $plsuffix )
			  . ' eingetragen'
			  if $inserted;
		}
	}

	my %antwort = _get_antworten4ticket($serial);
	for (@fragen) {
		defined( my $neue_antwort = $cgi->param("antwort[$_->[0]]") ) or next;
		unless ( defined( my $bisherige_antwort = $antwort{ $_->[0] } ) ) {
			Do(<<_);
	INSERT rt_antwort (ticket, frage, antwort)
	           VALUES ($serial, $_->[0], ${\ qquote($neue_antwort) })
_
			push @messages,
			  qq(Antwort "$neue_antwort" zu Frage "$_->[1]" gespeichert);
		}
		elsif ( $bisherige_antwort ne $neue_antwort ) {
			Do(<<_);
	REPLACE rt_antwort (ticket, frage, antwort)
	            VALUES ($serial, $_->[0], ${\ qquote($neue_antwort) })
_
			push @messages,
			  qq(Antwort zu Frage "$_->[1]" auf "$neue_antwort" geändert);
		}
	}

	$package->add_transaction( $serial, undef, $_ ) for @messages;
	join '; ', @messages or '(keine Änderungen)';
}

1;
