#!/usr/bin/perl

use utf8;
use strict;
use warnings;
use CGI::Carp qw(fatalsToBrowser);
use Umlaut qw(utf8modus);

BEGIN {
	unshift @INC, ( $ENV{'POPHOME'} || '@POPHOME@' ) . '/lib'
		unless $ENV{'KUNDE_NO_PERLPATH'};
	eval "use Apache2::RequestRec;";
	eval "use Apache;" if $@;
}

use Cf qw($BGCOLOR);
use Dbase::Globals qw(
  soll_bis_heute
  content
  get_descr
  get_person
  iso_intervall
  name_kunde
  stunden_bereich
  test_flag
  this_date
);
use Dbase::Help qw(Do DoFn isodate unixdate isotime DoTrans DoTime);
use Loader qw(log_update delete_stunde);
use CGI qw(:standard remote_user center);
use RT::ui::web::support qw(esc);
use HTTPerror qw(run);
use noris::Ticket::API qw(clean_connection_pool get_pooled_connection);

utf8modus(\*STDOUT);

sub abbrev($$) {
	my ( $text, $length ) = @_;
	return $text if length $text < $length;
	substr( $text, 0, $length - 3 ) . '...';
}

sub stdtab($$$$$) {
	my ( $user, $person, $today, $tomor, $sumstunden ) = @_;
	my $res = "";
	my $stunden = 0;
	my $cnt = 0;

	my $tagstd = DoFn("select tagstunden from perso where person=$person");
	$tagstd = 8000 unless defined $tagstd;
	my $heute = ($today <= DoTime() && $tomor > DoTime()) ? 1 : undef;
	$heute = soll_bis_heute($person) if $heute;

	my $ticket_conn;
	stunden_bereich($person,undef,$today,$tomor,16,sub {
		my (
			$id,   $beginn, $dauer, undef,   $kunde, $faktor,
			$text, $ticket, $art,   $artflg, undef,  $flg,
		) = @_;
		$flg=0 unless defined $flg;
		my $ende = $beginn + $dauer;
		my $count = $_[$#_];
		# $faktor = 100 if $faktor > 100;
		$dauer *= $tagstd/8000 if test_flag("stunden_art","keine_arbeit",$artflg);
		my $artname = $art ? $RT::artname{$art} : sprintf("%3.1f",$faktor/100);
		$artname = $RT::artname{$art} = DoFn("select name from stunden_art where id=$art") unless defined $artname;

		my ( $subject, $url );
		if ($ticket) {
			$ticket_conn ||= get_pooled_connection();
			( $subject, $url ) =
			  $ticket_conn->get_ticket( $ticket, [qw(title ticket_url)] );
		}

		my $kd = name_kunde($kunde);
		$kunde = 0 if not defined $kunde or $kunde == 1;

		unless ( content($text) ) {
			$text =
			  font( { color => 'blue' }, ' (' . abbrev( $subject, 42 ) . ')' )
			  if content($subject);
		}
		elsif ( $text =~ /^RT#\d+(?:-\d+)?$/ ) {
			$text =
			  esc($text)
			  . font( { color => 'blue' },
				' (' . abbrev( $subject, 32 ) . ')' )
			  if content($subject);
		}
		else { $text = esc( abbrev( $text, 42 ) ) }

		my $xid = $id;
		$id .= ".".$count;
		$res .= Tr({bgcolor => (++$cnt%2)?"ffffff":"eeeeee"},
			td(a({href=>"manipulate.pl?action=update&id=$xid",target=>"manipulate"},$id)),
			td($kd),
			td(iso_intervall($beginn,2)),
			td((this_date($beginn) == this_date($ende)) ? iso_intervall($ende,2) : "24:00"),
			### TODO: wenn $flg&1: OTRS-Link
			td(
				$ticket
				? a(
				  {
					  href => $url,
					  target => 'Ticket',
					  defined $subject ? ( title => $subject ) : ()
				  },
				  $ticket
				)
				: "&nbsp;"
			  ),
			td( content($text) ? $text : '&nbsp;' ),
			td({align=>"left"},$artname),
			td({align=>"right"},a({href=>"view.pl?action=delete&id=$xid", target=>"view"},"löschen")))."\n";
	});

	# Zu berechnende Zeit an diesem Tag zählen
	stunden_bereich($person,undef,$today,$tomor,1|2,sub {
		my ($id,$beginn,$dauer,undef,$kunde,$faktor,$text,$ticket,$art,$artflg) = @_;
		$faktor=100 unless defined $faktor;
		$stunden += $dauer*$faktor/100;
	});

	$res .= Tr(
		td({colspan=>10,align=>"right"},hr({width=>"100%",size=>2,color=>"blue",noshade=>undef}),
			b("Gesamtstunden dieses Tages:")," ", iso_intervall($stunden,4|16),br(),
			b("Monatssumme ohne Hotline:")," ",iso_intervall($sumstunden,4|16),br(),
			(defined $heute) ? (b("Soll bis heute:")," ",iso_intervall($heute,4|16),br()) : (),
			( defined $heute )
			  ? (
				b('Abweichung:'),
				" ",
				( '-', '', '+' )[ ( $sumstunden <=> $heute ) + 1 ]
				  . iso_intervall( abs( $heute - $sumstunden ), 4 | 16 ),
				br()
			  )
			  : (),
			));
}

run {
my $user;
eval { $user = Apache2::RequestRec->user(); };
$user = Apache->request->connection->user() if $@;
die "kein User bekannt.\n" unless $user;

# für spätere Aufrufe von stunden_bereich():
local $ENV{TICKET_API_USER} = $user;

my $person  = get_person($user);
{
	no warnings 'once';
	$Db::current_user = $person;
}

my $id	 	= param('id');
my $year 	= param('year');
my $month 	= param('month');
my $day		= param('day');
my $action	= param('action');

if($id) {
	my ($d,$u) = DoFn("select beginn,person from stunden where id = $id");
	die "User: $u $person\n" unless $u == $person;
	($year,$month,$day) = isodate($d) unless $year;
}
print STDERR "User: $user $person\n";

my $today	= unixdate($year,$month,$day);
my $tomor	= unixdate(isodate($today+25*60*60+2));

my $ny=$year;
my $nm=$month;

if(++$nm > 12) { $ny++; $nm=1; }

my $thism	= unixdate($year,$month,1);
my $nextm	= unixdate($ny,$nm,1);

my $sumstunden = 0;
#my $sumstunden = DoFn("select 0-hotline from persomonat where person=$person and monat=".(100*$year+$month)) || 0;

my $tagstd = DoFn("select tagstunden from perso where person=$person");
$tagstd = 8000 unless defined $tagstd;

stunden_bereich($person,undef,$thism,$nextm,1|2,sub {
	my $zaehler = pop @_;
	my($id,$beginn,$dauer,$pers,$kunde,$faktor,$text,$ticket,$art,$artflg) = @_;
	$dauer *= $tagstd/8000 if test_flag("stunden_art","keine_arbeit",$artflg);
	$sumstunden += $dauer*$faktor/100;
});
my $script;

if(defined $action and $action eq 'delete' and $id =~ /^\d+$/) {
	delete_stunde($id);

$script = <<END;
 function show(URL1,F1)
  {  
    parent.frames[F1].location.href=URL1;
  }
END

} else {
$script = <<END;
 function show(URL1,F1)
  {  
  }
END
}


print header(-charset=>'utf-8'),
      start_html( -alink   => 'blue',
                  -bgcolor => $BGCOLOR,
                  -link    => 'blue',
                  -onLoad  => "show('manipulate.pl?action=add&day=$day&month=$month&year=$year',2)",
                  -script  => $script,
                  -text    => 'black',
                  -vlink   => 'blue',
                );

print center(h2(qq#Tagesübersicht für $user am #.isodate($today)));
print table({border=>0,width=>"100%"},
Tr(
	th({align=>"left"},"ID"),
	th({align=>"left"},"Kunde"),
	th({align=>"left"},"Beginn"),
	th({align=>"left"},"Ende"),
	th({align=>"left"},"Ticket"),
	th({align=>"left"},"Kurztext"),
	th({align=>"left"},"Art"),
	th({align=>"right"},font({color=>"red"},"löschen?"))),

stdtab($user,$person,$today,$tomor,$sumstunden),
);

print end_html();

    # Da es nicht so wahrscheinlich ist, dass derselbe User so schnell
    # wieder an diesen Prozess gerät, schließen wir die Verbindung zur
    # Ticket-API, um nicht unnötig viele offen zu halten:
    clean_connection_pool($user);
};

