#!/usr/bin/perl

use utf8;
use strict;
use warnings;

use Umlaut qw(utf8modus);
utf8modus(\*STDOUT);

BEGIN {
	unshift @INC, ( $ENV{'POPHOME'} || '@POPHOME@' ) . '/lib'
		unless $ENV{'KUNDE_NO_PERLPATH'};
}

no warnings "uninitialized";
package cal::Calendar;

use Date::Calc qw(Day_of_Week Days_in_Month);
 
use constant M => 0;
use constant Y => 1;
use constant O => 2; 

sub new {
  my $package = shift;
  bless [ shift || (localtime)[-5]+1,    # month (default: current)
          shift || (localtime)[-4]+1900, # year  (default: current)
          (shift || 0) % 7,              # offset (default: Sunday)
          @_
        ],
        $package
}

sub rows {
  my $self = shift;
  my $wday = $self->[O] - 2 + Day_of_Week @{$self}[Y,M], 1;
  my $row = 0;
  my @cal;
  for (1 .. Days_in_Month @{$self}[Y,M]) {
    $cal[$row][$wday %= 7] = $_;
    ++$row if ++$wday == 7
  }
  @cal
}

sub wdays {
  my $self = shift;
  map $_%7, $self->[O]..$self->[O]+6
}

sub month  { shift->_get_set(M) }
sub year   { shift->_get_set(Y) }
sub offset { shift->_get_set(O) }

sub _get_set {
  my $self = shift;
  my $attr = shift;
  if (@_) {
    $self->[$attr] = shift
  } else {
    $self->[$attr]
  }
}

=cut

=head1 NAME

cal::Calendar

=head1 SYNOPSIS

 use cal::Calendar;

 my $cal = new cal::Calendar 12, 1999, 1;

 my @wdays = $cal->wdays;

 my @rows = $cal->rows;

=head1 CONSTRUCTOR

=over 4

=item new([month[, year[, offset]]])

If month and/or year are omitted, the current values
(from L<perlfunc/localtime>) are taken.

Offset specifies which day of the week is supposed to be at the leftmost
column of the calendar. Default (offset = 0) is Sunday. Germans would
normally want to use offset 1 to start with Monday.

=back

=head1 METHODS

=over 4

=item rows

Returns a LoL (see L<perllol>), containing one sublist per week.
Empty values at the start of the month are C<undef>.

=item wdays

Returns a list of weekday numbers (counting from 0 = Sun to 6 = Sat),
ordered according to offset.

=item month([month])

To get or set the calendar's month. (1..12)

=item year([year])

To get or set the calendar's year.

=item offset([offset])

To get or set the calendar's offset (see above).

=back

=head1 AUTHOR

Martin H. Sluka E<lt>martin@sluka.deE<gt>

=head1 DEDICATED TO

E<lt>ulysses@checkts.netE<gt> who really wanted to parse cal(1)'s output. #-|

=cut

#use cal::Calendar;
package main;
 
use constant WDAYS => qw(So Mo Di Mi Do Fr Sa);
use constant MONTHS => qw(Januar Februar M&auml;rz April Mai Juni
                          Juli August September Oktober November Dezember);
use CGI qw(:standard param);
use CGI::Carp 'fatalsToBrowser';
use Cf qw($BGCOLOR);
use HTTPerror qw(run);

run {
my ($month,$year);
$month = param 'month';
$year  = param 'year';
        
my $cal = new cal::Calendar $month, $year, 1;

my $prev = $month-1;
my $next = $month+1;
$prev = 'month=' . $prev . '&year=' . $year;
$next = 'month=' . $next . '&year=' . $year;

if ($month eq 1) {
	my $nyear = $year-1;
	$prev  = 'month=12&year='.$nyear;
} elsif ($month eq 12) {
	my $nyear = $year+1;
	$next  = 'month=1&year='.$nyear;
}
my(undef,undef,undef,$xtag,$xmonat,$xjahr)=localtime;
$xmonat++; $xjahr+=1900;
my $q = new CGI;

my $seconds_til_midnight;
{
    my($s,$m,$h) = localtime;
    $seconds_til_midnight = 86400 - $s - 60 * $m - 3600 * $h;
}

print header(-charset=>'utf-8', -refresh => $seconds_til_midnight),
	start_html({ -bgcolor => $BGCOLOR,
							-LINK=>'blue',
							-ALINK=>'blue',
							-VLINK=>'blue',
							-TITLE=>'Stunden-Dings',
							-STYLE=>{-SRC=>'/css/stunden.css'},
							-SCRIPT=><<END_SCRIPT
 function DreiFrames(URL1,F1,URL2,F2,URL3,F3)
 {  
  parent.frames[F1].location.href=URL1;
  parent.frames[F2].location.href=URL2;
  parent.frames[F3].location.href=URL3;
 }
 function ZweiFrames(URL1,F1,URL2,F2)
 {  
  parent.frames[F1].location.href=URL1;
  parent.frames[F2].location.href=URL2;
 }
END_SCRIPT
						}),
      table({BORDER=>0},
            caption((MONTHS)[$cal->month-1], $cal->year),
            Tr ([ th({BGCOLOR=>'red'}, [(WDAYS)[$cal->wdays]]),
                 '',
                 map td({ALIGN=>'RIGHT', BGCOLOR=>'orange'}, [map a({HREF=>"JavaScript:ZweiFrames('view.pl?day=$_&month=${month}&year=${year}',1,'manipulate.pl?action=add&day=$_&month=${month}&year=${year}',2)"},$_||''), @$_]), $cal->rows
               ]),
						Tr(td({COLSPAN=>2},a({HREF=>'kalender.pl?update=n&'.$prev},'last')),
								b(($xjahr == $year && $xmonat == $month)
								? td({COLSPAN=>3, ALIGN=>'center'},a({HREF=>"JavaScript:ZweiFrames('view.pl?day=${xtag}&month=${xmonat}&year=${xjahr}',1,'manipulate.pl?action=add&day=${xtag}&month=${xmonat}&year=${xjahr}',2)"},'today')) 
								: td({COLSPAN=>2, ALIGN=>'center'},a({HREF=>"JavaScript:DreiFrames('kalender.pl?month=${xmonat}&year=${xjahr}',0,'view.pl?day=${xtag}&month=${xmonat}&year=${xjahr}',1,'manipulate.pl?action=add&day=${xtag}&month=${xmonat}&year=${xjahr}',2)"},'today')),
								td({COLSPAN=>2, ALIGN=>'right'},a({HREF=>'kalender.pl?update=n&'.$next},'next'))))),
	end_html();
	
};
